/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import org.apache.log4j.PropertyConfigurator;

public final class OuiTestComms
implements AuthorizationPrompter {
    private static final String CORPORATE_ENDPOINT = "https://ccr.oracle.com";
    private static final String CCR_ENDPOINT_PROPERTY = "CCR.endPoint";
    private static final String CCR_PROXY_USER = "http.proxyUser";
    private static final String CCR_PROXY_PASSWORD = "http.proxyPassword";
    private static Properties m_httpConnectionProperties = new Properties();

    static {
        Properties properties = new Properties();
        ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
        ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
        ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
        ((Hashtable)properties).put("log4j.rootCategory", "WARN, Console");
        PropertyConfigurator.configure(properties);
        System.setProperty("ocm.keystore_resource", "true");
        System.setProperty("ocm.countrymap_resource", "true");
    }

    private static OCMEndPoint connect(String string, String string2, Properties properties) throws NetworkException {
        m_httpConnectionProperties = properties;
        EndPoint.setAuthorizationHandler(new OuiTestComms());
        String string3 = System.getProperty(CCR_ENDPOINT_PROPERTY);
        if (string3 == null) {
            string3 = CORPORATE_ENDPOINT;
        }
        URI uRI = null;
        try {
            uRI = new URI(string3);
            uRI = new URI(uRI.getScheme(), uRI.getHost(), uRI.getPort(), string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Unable to construct URI for " + string3);
        }
        return new OCMEndPoint(uRI, properties);
    }

    public static StringBuffer formatExceptionChain(CCRException cCRException) {
        Vector vector = cCRException.formatExceptionChain();
        Iterator iterator = ((AbstractList)vector).iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public NVPair getUsernamePassword(AuthorizationInfo authorizationInfo, boolean bl) {
        NVPair nVPair = null;
        String string = m_httpConnectionProperties.getProperty(CCR_PROXY_USER);
        String string2 = m_httpConnectionProperties.getProperty(CCR_PROXY_PASSWORD);
        if (string != null && string2 != null) {
            nVPair = new NVPair(string, string2);
        }
        return nVPair;
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        try {
            String string = System.getProperty("http.proxyHost");
            if (string != null) {
                ((Hashtable)properties).put("http.proxyHost", string);
            }
            if ((string = System.getProperty("http.proxyPort")) != null) {
                ((Hashtable)properties).put("http.proxyPort", string);
            }
            if ((string = System.getProperty(CCR_PROXY_USER)) != null) {
                ((Hashtable)properties).put(CCR_PROXY_USER, string);
            }
            if ((string = System.getProperty(CCR_PROXY_PASSWORD)) != null) {
                ((Hashtable)properties).put(CCR_PROXY_PASSWORD, string);
            }
            System.out.println("Testing connection");
            OuiTestComms.testConnect(properties);
            System.out.println("Testing registration");
            String string2 = System.getProperty("CSI");
            String string3 = System.getProperty("METALINK");
            String string4 = System.getProperty("CC");
            String string5 = System.getProperty("ORACLE_HOME");
            if (string2 == null || string3 == null || string4 == null || string5 == null) {
                System.err.println("CSI, METALINK, CC and ORACLE_HOME are required System Properties.");
                System.exit(1);
            }
            OuiTestComms.testRegister(string2, string3, Integer.parseInt(string4), string5, System.getProperties());
        }
        catch (CCRException cCRException) {
            System.err.println(OuiTestComms.formatExceptionChain(cCRException));
            System.exit(1);
        }
    }

    public static void testConnect(Properties properties) throws NetworkException {
        OuiTestComms.connect("/em/upload", "", properties);
    }

    public static void testRegister(String string, String string2, int n, String string3, Properties properties) throws NetworkException {
        OCMEndPoint oCMEndPoint = OuiTestComms.connect("", string3, properties);
        oCMEndPoint.authenticateUser(string2, string, n);
    }
}

