/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.ccr.netmgr.OCMHTTPResponse;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WebsvcResponse
implements ContentHandler {
    private ContentHandler m_responseDataHandler = null;
    private int m_intHttpResponseCode = -1;
    private String m_strHttpResponseLine = null;
    private Integer m_IntRequestStatusCode = new Integer(202);
    private StringBuffer m_sbRequestStatusLine = new StringBuffer();
    private String m_strCurrentElement = null;
    private Vector m_vectorLifoElements = new Vector();
    private static final int REQUEST_LIST_UNINITIALIZED = -1;
    private int m_intRequestLevel = -1;

    WebsvcResponse(OCMHTTPResponse oCMHTTPResponse, ContentHandler contentHandler) throws IOException, ModuleException, ParseException, SAXException {
        this.m_intHttpResponseCode = oCMHTTPResponse.getStatusCode();
        this.m_strHttpResponseLine = oCMHTTPResponse.getReasonLine();
        this.m_responseDataHandler = contentHandler;
        this.parseResponse(oCMHTTPResponse.getText());
    }

    private void beginRequestSubDocument() {
        ++this.m_intRequestLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inRequestSubDocument()) {
            if (this.m_responseDataHandler != null) {
                this.m_responseDataHandler.characters(cArray, n, n2);
            }
        } else if (this.m_strCurrentElement.equals("MESSAGE")) {
            this.m_sbRequestStatusLine.append(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.inRequestSubDocument()) {
            if (this.m_responseDataHandler != null) {
                this.m_responseDataHandler.endElement(string, string2, string3);
            }
            this.endRequestSubDocument();
        }
        this.m_vectorLifoElements.remove(this.m_vectorLifoElements.size() - 1);
        this.m_strCurrentElement = this.m_vectorLifoElements.size() != 0 ? (String)this.m_vectorLifoElements.elementAt(this.m_vectorLifoElements.size() - 1) : null;
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.inRequestSubDocument() && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.endPrefixMapping(string);
        }
    }

    private void endRequestSubDocument() {
        --this.m_intRequestLevel;
    }

    public String getCurrentElement() {
        return this.m_strCurrentElement;
    }

    public String getHttpResponseMessage() {
        return this.m_strHttpResponseLine;
    }

    public int getHttpStatusCode() {
        return this.m_intHttpResponseCode;
    }

    public String getRequestResponseMessage() {
        return this.m_sbRequestStatusLine.toString();
    }

    public int getRequestStatusCode() {
        return this.m_IntRequestStatusCode;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.inRequestSubDocument() && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    private boolean inRequestSubDocument() {
        return this.m_intRequestLevel >= 0;
    }

    private void initializeRequestSubDocumentCounter() {
        this.m_intRequestLevel = -1;
    }

    void parseResponse(String string) throws SAXException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
        xMLReader.setContentHandler(this);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputSource inputSource = new InputSource(byteArrayInputStream);
        try {
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {}
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inRequestSubDocument() && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.processingInstruction(string, string2);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.inRequestSubDocument() && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.skippedEntity(string);
        }
    }

    public void startDocument() throws SAXException {
        this.initializeRequestSubDocumentCounter();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.m_strCurrentElement = string3;
        this.m_vectorLifoElements.add(this.m_strCurrentElement);
        if (this.inRequestSubDocument()) {
            this.beginRequestSubDocument();
            if (this.m_responseDataHandler != null) {
                this.m_responseDataHandler.startElement(string, string2, string3, attributes);
            }
        } else {
            if (string3.equals("STATUS")) {
                String string4 = attributes.getValue("CODE");
                this.m_IntRequestStatusCode = Integer.valueOf(string4);
            }
            if (string3.equals("REQUEST_DATA")) {
                this.beginRequestSubDocument();
            }
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.inRequestSubDocument() && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.startPrefixMapping(string, string2);
        }
    }
}

