/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.security;

import com.phaos.jce.provider.Phaos;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.CryptoHandler;
import oracle.sysman.ccr.util.SecureRandomUtil;

public class OCMCrypto
implements CryptoHandler {
    private static final String RSA_ALG = "RSA/None/PKCS1Padding";
    private static final String RSA_PROVIDER = "Phaos";
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$security$OCMCrypto == null ? (class$oracle$sysman$ccr$security$OCMCrypto = OCMCrypto.class$("oracle.sysman.ccr.security.OCMCrypto")) : class$oracle$sysman$ccr$security$OCMCrypto);
    private static final String SYM_ALG = "AES";
    private static final String SYM_PROVIDER = "SunJCE";
    private static final String SYM_METHOD = "CFB";
    private static final String SYM_PADDING = "NoPadding";
    private static final String SYM_ALG_METHOD_PADDING = "AES".concat("/").concat("CFB").concat("/").concat("NoPadding");
    private static final int IV_BLOCK_SIZE = 16;
    private static final int KEY_LENGTH = 128;
    private byte[] m_ivAndKey = null;
    private byte[] m_ivBytes = null;
    private byte[] m_keyBytes = null;
    SecureRandom m_random = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$security$OCMCrypto;

    public void generateSymmetricKey() throws GeneralSecurityException {
        this.generateKey();
    }

    public void setSymmetricKey(byte[] byArray) {
        this.m_ivAndKey = byArray;
        int n = byArray[0] & 0xFF;
        if (n != 16) {
            throw new IllegalArgumentException("The input iv size is " + n + " when " + 16 + "is expected");
        }
        int n2 = this.m_ivAndKey.length - n - 1;
        this.m_ivBytes = new byte[n];
        this.m_keyBytes = new byte[n2];
        System.arraycopy(this.m_ivAndKey, 1, this.m_ivBytes, 0, n);
        System.arraycopy(this.m_ivAndKey, 1 + n, this.m_keyBytes, 0, n2);
    }

    public byte[] getIvAndKey() {
        if (this.m_ivAndKey == null) {
            this.m_ivAndKey = new byte[this.m_ivBytes.length + this.m_keyBytes.length + 1];
            this.m_ivAndKey[0] = (byte)this.m_ivBytes.length;
            System.arraycopy(this.m_ivBytes, 0, this.m_ivAndKey, 1, this.m_ivBytes.length);
            System.arraycopy(this.m_keyBytes, 0, this.m_ivAndKey, 1 + this.m_ivBytes.length, this.m_keyBytes.length);
        }
        return this.m_ivAndKey;
    }

    public byte[] encrypt(byte[] byArray) throws GeneralSecurityException {
        return this.process(byArray, 1);
    }

    public byte[] decrypt(byte[] byArray) throws GeneralSecurityException {
        return this.process(byArray, 2);
    }

    public byte[] process(byte[] byArray, int n) throws GeneralSecurityException {
        Cipher cipher = this.getCipher(n);
        byte[] byArray2 = new byte[cipher.getOutputSize(byArray.length)];
        int n2 = cipher.update(byArray, 0, byArray.length, byArray2, 0);
        n2 += cipher.doFinal(byArray2, n2);
        return this.shrinkArray(byArray2, n2);
    }

    private void generateKey() throws GeneralSecurityException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("OCMCrypto:Generating Key\n");
        }
        SecureRandom secureRandom = this.getSecureRandom();
        this.m_ivBytes = new byte[16];
        secureRandom.nextBytes(this.m_ivBytes);
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.getAlgorithm(), this.getProviderName());
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Key Generator params:Alg=" + this.getAlgorithm() + "Provider:" + this.getProviderName());
        }
        if (keyGenerator == null) {
            throw new GeneralSecurityException("Key generator failed\n");
        }
        keyGenerator.init(this.getKeyLength(), secureRandom);
        this.m_keyBytes = keyGenerator.generateKey().getEncoded();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("OCMCrypto: Key Generated");
        }
    }

    private synchronized SecureRandom getSecureRandom() {
        if (this.m_random == null) {
            this.m_random = SecureRandomUtil.getSecureRandomInstance();
        }
        return this.m_random;
    }

    private Cipher getCipher(int n) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.m_keyBytes, this.getAlgorithm());
        Cipher cipher = Cipher.getInstance(this.getAlgoMethodPadding(), this.getProviderName());
        cipher.init(n, (Key)secretKeySpec, new IvParameterSpec(this.m_ivBytes), this.getSecureRandom());
        return cipher;
    }

    private byte[] shrinkArray(byte[] byArray, int n) {
        byte[] byArray2 = byArray;
        if (n < byArray.length) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        return byArray2;
    }

    protected int getKeyLength() {
        return 128;
    }

    protected String getAlgoMethodPadding() {
        return SYM_ALG_METHOD_PADDING;
    }

    protected String getProviderName() {
        return SYM_PROVIDER;
    }

    protected String getAlgorithm() {
        return SYM_ALG;
    }

    public InputStream getCipherInputStream(InputStream inputStream) throws GeneralSecurityException {
        Cipher cipher = this.getCipher(1);
        return new CipherInputStream(inputStream, cipher);
    }

    public byte[] publicEncrypt(byte[] byArray, PublicKey publicKey) throws GeneralSecurityException {
        Cipher cipher = this.getRSACipher();
        cipher.init(1, (Key)publicKey, this.getSecureRandom());
        return cipher.doFinal(byArray);
    }

    private Cipher getRSACipher() throws GeneralSecurityException {
        return Cipher.getInstance(RSA_ALG, RSA_PROVIDER);
    }

    public byte[] privateDecrypt(byte[] byArray, PrivateKey privateKey) throws GeneralSecurityException {
        Cipher cipher = this.getRSACipher();
        cipher.init(2, (Key)privateKey, this.getSecureRandom());
        return cipher.doFinal(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Security.addProvider((Provider)new Phaos());
    }
}

