/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.TestCmd;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.ConnectionPageImpl;
import oracle.sysman.ccr.impl.InvalValueException;
import oracle.sysman.ccr.impl.PageImpl;
import oracle.sysman.ccr.ui.EMCCRConfigAssistant;
import oracle.sysman.ccr.ui.PageException;
import oracle.sysman.ccr.ui.UIMsgID;
import oracle.sysman.ccr.ui.border.CheckTitledPane;

public class ConnectionPage
extends JPanel
implements ItemListener,
ActionListener {
    private MessageBundle m_bundle = MessageBundle.getInstance("oracle.sysman.ccr.ui.UI");
    private JCheckBox m_useProxyChkbox = new JCheckBox(this.m_bundle.getMessage(UIMsgID.USE_PROXY, false));
    private JCheckBox m_authenticateChkbox = new JCheckBox(this.m_bundle.getMessage(UIMsgID.AUTHENTICATION, false));
    private JTextField m_proxyUserField = new JTextField(15);
    private JPasswordField m_proxyPasswdField = new JPasswordField(15);
    private JLabel m_proxyUserLabel = new JLabel(this.m_bundle.getMessage(UIMsgID.USERNAME, false));
    private JLabel m_proxyPasswdLabel = new JLabel(this.m_bundle.getMessage(UIMsgID.PASSWORD, false));
    private JTextField m_proxyServerField = new JTextField(12);
    private JTextField m_proxyPortField = new JTextField(4);
    private JLabel m_proxyServerLabel = new JLabel(this.m_bundle.getMessage(UIMsgID.SERVERNAME, false));
    private JLabel m_proxyPortLabel = new JLabel(this.m_bundle.getMessage(UIMsgID.SERVERPORT, false));
    private JButton m_testConnBtn = new JButton(this.m_bundle.getMessage(UIMsgID.TEST_CONNECTION, false));
    private JTextArea m_testDetails = new JTextArea();
    private JScrollPane m_scroller = null;
    private EmptyBorder m_border10 = new EmptyBorder(10, 10, 10, 10);
    private ConnectionPageImpl m_conPageImpl = new ConnectionPageImpl();
    private static final String STARS = "*****";

    public ConnectionPage() {
        CheckTitledPane checkTitledPane = new CheckTitledPane();
        this.initControls();
        checkTitledPane.setTitle(this.m_useProxyChkbox);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(this.m_border10);
        jPanel.add((Component)this.proxySettingsPane(), "North");
        jPanel.add((Component)this.proxyCredentialsPane(), "Center");
        checkTitledPane.setContent(jPanel);
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)checkTitledPane, "North");
        this.add((Component)this.initTestCtls(), "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_testConnBtn) {
            this.testConnection();
        }
    }

    public void applyChanges() throws PageException {
        this.m_conPageImpl.applyChanges();
    }

    private void authSettingsOnOff(int n) {
        boolean bl = n == 1;
        this.m_proxyUserField.setEnabled(bl);
        this.m_proxyPasswdField.setEnabled(bl);
        this.m_proxyUserLabel.setEnabled(bl);
        this.m_proxyPasswdLabel.setEnabled(bl);
        if (bl) {
            this.m_proxyUserField.requestFocus();
        }
    }

    public PageImpl getPageImpl() {
        return this.m_conPageImpl;
    }

    private void initControls() {
        this.m_useProxyChkbox.setSelected(this.m_conPageImpl.getUseProxy());
        this.m_proxyServerField.setText(this.m_conPageImpl.getProxyServer());
        this.m_proxyPortField.setText(this.m_conPageImpl.getProxyPort());
        this.m_proxyUserField.setText(this.m_conPageImpl.getProxyUser());
        if (this.m_conPageImpl.getUseCredentials()) {
            ((JTextComponent)this.m_proxyPasswdField).setText(STARS);
        }
        this.m_authenticateChkbox.setSelected(this.m_conPageImpl.getUseCredentials());
        this.m_useProxyChkbox.addItemListener(this);
        this.m_authenticateChkbox.addItemListener(this);
        this.proxySettingsOnOff(this.m_useProxyChkbox.isSelected() ? 1 : 2);
    }

    private JPanel initTestCtls() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel2.add(this.m_testConnBtn);
        this.m_testConnBtn.addActionListener(this);
        this.m_scroller = new JScrollPane(this.m_testDetails);
        this.m_scroller.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.m_scroller, "Center");
        this.m_scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_testDetails.setEditable(false);
        this.m_testDetails.setVisible(false);
        return jPanel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.m_useProxyChkbox) {
            this.proxySettingsOnOff(itemEvent.getStateChange());
        } else if (itemEvent.getItemSelectable() == this.m_authenticateChkbox) {
            this.authSettingsOnOff(itemEvent.getStateChange());
        }
    }

    private Container proxyCredentialsPane() {
        CheckTitledPane checkTitledPane = new CheckTitledPane();
        checkTitledPane.setTitle(this.m_authenticateChkbox);
        Container container = new Container();
        Container container2 = new Container();
        container.setLayout(new GridLayout(2, 2, 0, 10));
        container2.setLayout(new FlowLayout(0));
        container.add(this.m_proxyUserLabel);
        container.add(this.m_proxyUserField);
        container.add(this.m_proxyPasswdLabel);
        container.add(this.m_proxyPasswdField);
        container2.add(container);
        checkTitledPane.setContent(container2);
        return checkTitledPane;
    }

    private void proxySettingsOnOff(int n) {
        boolean bl = n == 1;
        this.m_proxyServerField.setEnabled(bl);
        this.m_proxyPortField.setEnabled(bl);
        this.m_proxyServerLabel.setEnabled(bl);
        this.m_proxyPortLabel.setEnabled(bl);
        this.m_authenticateChkbox.setEnabled(bl);
        this.authSettingsOnOff(this.m_authenticateChkbox.isSelected() && bl ? 1 : 2);
        if (bl) {
            this.m_proxyServerField.requestFocus();
        }
    }

    private Container proxySettingsPane() {
        Container container = new Container();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_proxyServerLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_proxyPortLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_proxyPortField, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagLayout.setConstraints(this.m_proxyServerField, gridBagConstraints);
        container.add(this.m_proxyServerLabel);
        container.add(this.m_proxyServerField);
        container.add(this.m_proxyPortLabel);
        container.add(this.m_proxyPortField);
        return container;
    }

    private void requestFocusnThrow(JTextField jTextField, Exception exception) throws PageException {
        jTextField.requestFocus();
        jTextField.selectAll();
        throw new PageException("", exception, this);
    }

    private void testConnection() {
        Window window = (Window)SwingUtilities.getRoot(this);
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        PrintStream printStream3 = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
        this.m_testDetails.selectAll();
        this.m_testDetails.replaceRange(null, 0, this.m_testDetails.getSelectionEnd());
        try {
            try {
                this.validateChanges();
                this.applyChanges();
                window.setCursor(Cursor.getPredefinedCursor(3));
                System.setOut(printStream3);
                System.setErr(printStream3);
                this.m_testDetails.setVisible(true);
                new TestCmd().processRequest();
            }
            catch (PageException pageException) {
                EMCCRConfigAssistant.errorDialog(window, pageException);
            }
            catch (CommandException commandException) {
                this.m_testDetails.append(PageImpl.getErrorStr(commandException).toString());
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            System.setOut(printStream);
            System.setErr(printStream2);
            printStream3.close();
            window.setCursor(null);
            throw throwable;
        }
        System.setOut(printStream);
        System.setErr(printStream2);
        printStream3.close();
        window.setCursor(null);
    }

    public void validateChanges() throws PageException {
        block10: {
            boolean bl = this.m_useProxyChkbox.isSelected();
            this.m_conPageImpl.setUseProxy(bl);
            if (!bl) break block10;
            try {
                this.m_conPageImpl.setProxyServer(this.m_proxyServerField.getText());
            }
            catch (InvalValueException invalValueException) {
                this.requestFocusnThrow(this.m_proxyServerField, invalValueException);
            }
            try {
                this.m_conPageImpl.setProxyPort(this.m_proxyPortField.getText());
            }
            catch (InvalValueException invalValueException) {
                this.requestFocusnThrow(this.m_proxyPortField, invalValueException);
            }
            boolean bl2 = this.m_authenticateChkbox.isSelected();
            this.m_conPageImpl.setUseCredentials(bl2);
            if (bl2) {
                try {
                    this.m_conPageImpl.setProxyUser(this.m_proxyUserField.getText());
                }
                catch (InvalValueException invalValueException) {
                    this.requestFocusnThrow(this.m_proxyUserField, invalValueException);
                }
                try {
                    String string = new String(this.m_proxyPasswdField.getPassword());
                    if (!STARS.equals(string)) {
                        this.m_conPageImpl.setProxyPasswd(string);
                    }
                }
                catch (InvalValueException invalValueException) {
                    this.requestFocusnThrow(this.m_proxyPasswdField, invalValueException);
                }
            }
        }
    }

    private class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray) throws IOException {
            ConnectionPage.this.m_testDetails.append(new String(byArray));
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            ConnectionPage.this.m_testDetails.append(new String(byArray, n, n2));
        }
    }
}

