/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.AgreementImpl;
import oracle.sysman.ccr.impl.PageImpl;
import oracle.sysman.ccr.ui.ConnectionPage;
import oracle.sysman.ccr.ui.GeneralPage;
import oracle.sysman.ccr.ui.PageException;
import oracle.sysman.ccr.ui.UIMsgID;
import oracle.sysman.ccr.ui.dialog.AgreementDialog;
import oracle.sysman.ccr.ui.dialog.HelpDialog;

public class EMCCRConfigAssistant
extends JFrame
implements ActionListener {
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.ui.UI");
    private GeneralPage genPage = null;
    private ConnectionPage connPage = null;
    private JButton okButton = new JButton(s_bundle.getMessage(UIMsgID.OK_BUTTON, false));
    private JButton cancelButton = new JButton(s_bundle.getMessage(UIMsgID.CANCEL_BUTTON, false));
    private JButton helpButton = new JButton(s_bundle.getMessage(UIMsgID.HELP_BUTTON, false));
    private JTabbedPane tabPanel = new JTabbedPane();
    private static Border border10 = new EmptyBorder(10, 10, 0, 10);
    private static Border border510 = new EmptyBorder(5, 10, 5, 10);
    private String m_strOracleHome = null;
    private static final int MIN_HEIGHT = 500;
    private static final int MIN_WIDTH = 525;
    private static final String FWD_SLASH = "/";
    private static String HTML_HELP_BASE_PATH = "/resources";
    private static String HELP_PAGES_DIR = "help";
    private static String CONNECTION_HELP_PAGE = "customerconnect_connection.html";
    private static String GENERAL_HELP_PAGE = "customerconnect_general.html";
    public static final int SUCC = 0;
    public static final int LOAD_ERROR = 1;

    public EMCCRConfigAssistant() {
        this.load();
        this.setTitle(s_bundle.getMessage(UIMsgID.TITLE, false));
        this.getContentPane().setLayout(new BorderLayout());
        this.addTabs();
        this.getContentPane().add(this.getHeader(), "North");
        this.getContentPane().add((Component)this.addButtons(), "South");
        this.getContentPane().add((Component)this.tabPanel, "Center");
        ((Component)this).setSize(525, 500);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new MyWindowListener());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.okPressed();
            this.setCursor(null);
        }
        if (actionEvent.getSource() == this.cancelButton) {
            this.destroy(0);
        }
        if (actionEvent.getSource() == this.helpButton) {
            this.displayHelp();
        }
    }

    private Container addButtons() {
        Container container = new Container();
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        container.setLayout(new GridLayout());
        container.add(this.okButton);
        container.add(this.cancelButton);
        container.add(this.helpButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(container);
        return jPanel;
    }

    private void addTabs() {
        this.genPage.setBorder(border10);
        this.tabPanel.addTab(s_bundle.getMessage(UIMsgID.GENERAL, false), this.genPage);
        this.connPage.setBorder(border10);
        this.tabPanel.addTab(s_bundle.getMessage(UIMsgID.CONNECTION, false), this.connPage);
        this.tabPanel.setBorder(border510);
    }

    public static String catResourcePath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(FWD_SLASH);
            ++n;
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    private void destroy(int n) {
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(n);
    }

    private void displayHelp() {
        Component component = this.tabPanel.getSelectedComponent();
        String string = this.getClass().getPackage().getName().replace('.', '/');
        String string2 = EMCCRConfigAssistant.catResourcePath(new String[]{HTML_HELP_BASE_PATH, string, HELP_PAGES_DIR});
        string2 = component == this.connPage ? EMCCRConfigAssistant.catResourcePath(new String[]{string2, CONNECTION_HELP_PAGE}) : EMCCRConfigAssistant.catResourcePath(new String[]{string2, GENERAL_HELP_PAGE});
        new HelpDialog((Frame)this, null, this.getClass().getResource(string2));
    }

    public static void errorDialog(Window window, Exception exception) {
        String string = PageImpl.getErrorStr(exception).toString().trim();
        if ((string = string.trim()).length() == 0) {
            string = exception.toString();
        }
        if (string.length() != 0) {
            EMCCRConfigAssistant.errorDialog(window, string);
        }
    }

    public static void errorDialog(Window window, String string) {
        Object[] objectArray = new Object[]{s_bundle.getMessage(UIMsgID.OK_BUTTON, false)};
        int n = 0;
        string = string.trim();
        n = string.length();
        int n2 = 35;
        int n3 = 7;
        int n4 = n < 35 ? n : 35;
        int n5 = n / n4 + 1;
        if (n5 > 7 || EMCCRConfigAssistant.getNumNewLineChars(string) > n5) {
            n5 = 7;
        }
        JTextArea jTextArea = new JTextArea(string, n5, n4);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        JOptionPane jOptionPane = new JOptionPane(jScrollPane, 0, 0, null, objectArray, objectArray[0]);
        JDialog jDialog = jOptionPane.createDialog(window, s_bundle.getMessage(UIMsgID.ERROR, false));
        jDialog.setResizable(false);
        ((Component)jDialog).setVisible(true);
    }

    private Component getHeader() {
        String string = String.valueOf(s_bundle.getMessage(UIMsgID.HOME_HEADER, false)) + " ";
        JLabel jLabel = new JLabel(string);
        Font font = new Font(jLabel.getFont().getFontName(), 1, 10);
        FontMetrics fontMetrics = ((Component)jLabel).getFontMetrics(font);
        int n = fontMetrics.stringWidth(this.m_strOracleHome);
        int n2 = fontMetrics.stringWidth(string);
        JComponent jComponent = null;
        jLabel.setFont(font);
        if (n2 + n <= 475) {
            jLabel.setText(String.valueOf(string) + this.m_strOracleHome);
            jComponent = jLabel;
        } else {
            JLabel jLabel2 = new JLabel(this.m_strOracleHome);
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jLabel2.setFont(font);
            jComponent = jPanel;
        }
        jComponent.setBorder(new EmptyBorder(5, 10, 0, 10));
        return jComponent;
    }

    private static int getNumNewLineChars(String string) {
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return stringTokenizer.countTokens();
    }

    private void load() {
        try {
            PageImpl.initialize();
            if (!this.loadAgreementDialog()) {
                this.destroy(0);
            }
            this.m_strOracleHome = System.getProperty("ORACLE_HOME");
            if (this.m_strOracleHome == null) {
                throw new RuntimeException(s_bundle.getMessage(UIMsgID.ORACLE_HOME_ERR, false));
            }
            this.genPage = new GeneralPage();
            this.connPage = new ConnectionPage();
        }
        catch (Exception exception) {
            EMCCRConfigAssistant.errorDialog((Window)this, exception);
            this.destroy(1);
        }
    }

    private boolean loadAgreementDialog() throws FileReadException {
        if (new AgreementImpl().isAccepted()) {
            return true;
        }
        new AgreementDialog(this);
        boolean bl = false;
        if (new AgreementImpl().isAccepted()) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            new EMCCRConfigAssistant();
        }
        catch (Throwable throwable) {
            System.err.println(s_bundle.getMessage(UIMsgID.ERROR_STR, false));
            String string = PageImpl.getErrorStr(throwable).toString().trim();
            if (string.length() == 0) {
                throwable.printStackTrace();
            }
            System.err.println(string);
        }
    }

    private void okPressed() {
        try {
            this.genPage.validateChanges();
            this.connPage.validateChanges();
            this.connPage.applyChanges();
            this.genPage.applyChanges();
            this.genPage.getPageImpl().save();
            this.destroy(0);
        }
        catch (PageException pageException) {
            Container container = pageException.getSource();
            if (container != null) {
                this.tabPanel.setSelectedComponent(container);
            }
            EMCCRConfigAssistant.errorDialog((Window)this, pageException);
        }
        catch (CommandException commandException) {
            EMCCRConfigAssistant.errorDialog((Window)this, commandException);
        }
        catch (FileWriteException fileWriteException) {
            EMCCRConfigAssistant.errorDialog((Window)this, fileWriteException);
        }
        catch (Exception exception) {
            EMCCRConfigAssistant.errorDialog((Window)this, exception);
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            EMCCRConfigAssistant.this.destroy(0);
        }
    }
}

