/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.RegisterCmdException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.GeneralPageImpl;
import oracle.sysman.ccr.impl.InvalValueException;
import oracle.sysman.ccr.impl.PageImpl;
import oracle.sysman.ccr.impl.SchedFrequency;
import oracle.sysman.ccr.impl.SchedImpl;
import oracle.sysman.ccr.ui.PageException;
import oracle.sysman.ccr.ui.UIMsgID;
import oracle.sysman.ccr.ui.border.CheckTitledPane;

public class GeneralPage
extends JPanel
implements SchedFrequency,
ItemListener {
    private static final int MONTH_DAYS = 31;
    private static final String SPACER = " ";
    private static final int MAX_HOURS = 12;
    private static final int MAX_MINUTES = 59;
    private static final EmptyBorder m_border5 = new EmptyBorder(5, 5, 5, 5);
    private MessageBundle m_bundle = MessageBundle.getInstance("oracle.sysman.ccr.ui.UI");
    private String[][] m_weekDays = new String[][]{{"SUN", this.m_bundle.getMessage(UIMsgID.SUNDAY, false)}, {"MON", this.m_bundle.getMessage(UIMsgID.MONDAY, false)}, {"TUE", this.m_bundle.getMessage(UIMsgID.TUESDAY, false)}, {"WED", this.m_bundle.getMessage(UIMsgID.WEDNESDAY, false)}, {"THU", this.m_bundle.getMessage(UIMsgID.THURSDAY, false)}, {"FRI", this.m_bundle.getMessage(UIMsgID.FRIDAY, false)}, {"SAT", this.m_bundle.getMessage(UIMsgID.SATURDAY, false)}};
    private String m_amStr = this.m_bundle.getMessage(UIMsgID.AM, false);
    private String m_pmStr = this.m_bundle.getMessage(UIMsgID.PM, false);
    private JTextField m_csiNumberField = new JTextField();
    private JComboBox m_countryCombo = new JComboBox();
    private JTextField m_metalinkField = new JTextField();
    private JCheckBox m_autoUploadChkbox = new JCheckBox(this.m_bundle.getMessage(UIMsgID.ENABLE_AUTOUPLOAD, false));
    private int[] m_frequencies;
    private JRadioButton[] m_freqChkboxes;
    private JCheckBox m_autoUpdateChkBox;
    private JLabel m_labelDay;
    private String m_weekStr;
    private String m_monthStr;
    private JComboBox m_dayCombo;
    private JLabel m_labelAt;
    private JLabel m_labelHour;
    private JLabel m_labelMin;
    private JComboBox m_hourCombo;
    private JComboBox m_minCombo;
    private JComboBox m_ampmCombo;
    private JPanel m_timePanel;
    private int m_hour;
    private int m_minute;
    private GeneralPageImpl m_genPageImpl;
    private SchedImpl m_schedImpl;

    public GeneralPage() throws CommandException, CountryCodeException {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.m_frequencies = nArray;
        this.m_freqChkboxes = new JRadioButton[this.m_frequencies.length];
        this.m_autoUpdateChkBox = new JCheckBox(this.m_bundle.getMessage(UIMsgID.ENABLE_AUTOUPDATE, false));
        this.m_labelDay = new JLabel();
        this.m_weekStr = this.m_bundle.getMessage(UIMsgID.WEEKDAY, false);
        this.m_monthStr = this.m_bundle.getMessage(UIMsgID.MONTHDAY, false);
        this.m_dayCombo = new JComboBox();
        this.m_labelAt = new JLabel(this.m_bundle.getMessage(UIMsgID.AT, false));
        this.m_labelHour = new JLabel(String.valueOf(this.m_bundle.getMessage(UIMsgID.HR, false)) + SPACER);
        this.m_labelMin = new JLabel(String.valueOf(this.m_bundle.getMessage(UIMsgID.MN, false)) + SPACER);
        this.m_hourCombo = new JComboBox();
        this.m_minCombo = new JComboBox();
        this.m_ampmCombo = new JComboBox();
        this.m_timePanel = new JPanel();
        this.m_hour = 0;
        this.m_minute = 0;
        this.m_genPageImpl = null;
        this.m_schedImpl = null;
        this.m_schedImpl = new SchedImpl();
        this.m_genPageImpl = new GeneralPageImpl();
        this.setLayout(new BorderLayout());
        this.initializeControls();
        Container container = new Container();
        container.setLayout(new BorderLayout(10, 10));
        container.add("North", this.customerDetailsPane());
        container.add("Center", this.schedulePane());
        container.add("South", this.m_autoUpdateChkBox);
        this.add("North", container);
    }

    public void applyChanges() throws PageException, CommandException {
        try {
            this.m_genPageImpl.applyChanges();
        }
        catch (RegisterCmdException registerCmdException) {
            this.m_csiNumberField.requestFocus();
            throw new PageException("", registerCmdException, this);
        }
        this.m_schedImpl.applyChanges();
    }

    private Container customerDetailsPane() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        EmptyBorder emptyBorder = new EmptyBorder(5, 10, 10, 20);
        jPanel2.setBorder(new TitledBorder(this.m_bundle.getMessage(UIMsgID.CUSTOMER_DETAILS, false)));
        jPanel2.setLayout(new BorderLayout());
        jPanel.setLayout(new GridLayout(3, 1, 0, 10));
        jPanel.setBorder(emptyBorder);
        jPanel3.setLayout(new GridLayout(3, 1, 0, 10));
        jPanel3.setBorder(emptyBorder);
        jPanel3.add(this.m_csiNumberField);
        jPanel3.add(this.m_countryCombo);
        jPanel3.add(this.m_metalinkField);
        jPanel.add(new JLabel(this.m_bundle.getMessage(UIMsgID.CSI, false)));
        jPanel.add(new JLabel(this.m_bundle.getMessage(UIMsgID.CCODE, false)));
        jPanel.add(new JLabel(this.m_bundle.getMessage(UIMsgID.METALINK, false)));
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)jPanel3, "Center");
        return jPanel2;
    }

    private void fillCountryCombo() {
        String string = this.m_genPageImpl.getCountryName();
        int n = -1;
        String[] stringArray = this.m_genPageImpl.getCountryNames();
        this.quickSort(stringArray, 0, stringArray.length - 1);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.m_countryCombo.addItem(stringArray[n2]);
            if (n == -1 && string.equalsIgnoreCase(stringArray[n2])) {
                n = n2;
            }
            ++n2;
        }
        if (n > 0) {
            this.m_countryCombo.setSelectedIndex(n);
        } else {
            this.m_countryCombo.insertItemAt("", 0);
            this.m_countryCombo.setSelectedIndex(0);
        }
    }

    private void fillDayCombo(int n) {
        this.m_dayCombo.removeAllItems();
        if (n == 0) {
            this.m_dayCombo.setVisible(false);
            this.m_labelDay.setVisible(false);
        } else {
            this.m_dayCombo.setVisible(true);
            this.m_labelDay.setVisible(true);
            if (n == 1) {
                this.m_labelDay.setText(this.m_weekStr);
                int n2 = 0;
                while (n2 < this.m_weekDays.length) {
                    this.m_dayCombo.addItem(this.m_weekDays[n2][1]);
                    ++n2;
                }
                String string = this.m_schedImpl.getWeekDay();
                if (string != null) {
                    this.m_dayCombo.setSelectedIndex(this.getWeekDayIndex(string));
                }
            } else if (n == 2) {
                this.m_labelDay.setText(this.m_monthStr);
                int n3 = 1;
                while (n3 <= 31) {
                    this.m_dayCombo.addItem(Integer.toString(n3));
                    ++n3;
                }
                String string = this.m_schedImpl.getMonthDay();
                if (string != null) {
                    this.m_dayCombo.setSelectedItem(string);
                }
            }
        }
    }

    private void fillUploadTimings() {
        int n = 1;
        while (n <= 12) {
            this.m_hourCombo.addItem(Integer.toString(n));
            ++n;
        }
        int n2 = 0;
        while (n2 <= 59) {
            this.m_minCombo.addItem(Integer.toString(n2));
            ++n2;
        }
        this.m_ampmCombo.addItem(this.m_amStr);
        this.m_ampmCombo.addItem(this.m_pmStr);
        int n3 = this.m_schedImpl.getHour();
        int n4 = this.m_schedImpl.getMinute();
        String string = this.m_amStr;
        if (n3 > 12) {
            n3 -= 12;
            string = this.m_pmStr;
        } else if (n3 == 12) {
            string = this.m_pmStr;
        } else if (n3 == 0) {
            n3 = 12;
        }
        this.m_hourCombo.setSelectedItem(Integer.toString(n3));
        this.m_minCombo.setSelectedItem(Integer.toString(n4));
        this.m_ampmCombo.setSelectedItem(string);
    }

    private Container frequencyPane() {
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this.m_freqChkboxes.length) {
            buttonGroup.add(this.m_freqChkboxes[n]);
            this.m_freqChkboxes[n].addItemListener(this);
            jPanel.add(this.m_freqChkboxes[n]);
            ++n;
        }
        jPanel.setBorder(new TitledBorder(this.m_bundle.getMessage(UIMsgID.FREQUENCY, false)));
        jPanel.setLayout(new GridLayout(this.m_freqChkboxes.length + 1, 1));
        return jPanel;
    }

    public PageImpl getPageImpl() {
        return this.m_genPageImpl;
    }

    private int getSelectedFreq() {
        int n = 0;
        while (n < this.m_freqChkboxes.length) {
            if (this.m_freqChkboxes[n].isSelected()) break;
            ++n;
        }
        return n;
    }

    private String getShortWeekDay(String string) {
        String string2 = "";
        int n = 0;
        while (n < this.m_weekDays.length) {
            if (string.equalsIgnoreCase(this.m_weekDays[n][1])) {
                string2 = this.m_weekDays[n][0];
                break;
            }
            ++n;
        }
        return string2;
    }

    private int getWeekDayIndex(String string) {
        int n = 0;
        while (n < this.m_weekDays.length) {
            if (string.equalsIgnoreCase(this.m_weekDays[n][0])) break;
            ++n;
        }
        return n;
    }

    private void initializeControls() {
        this.m_freqChkboxes[0] = new JRadioButton(this.m_bundle.getMessage(UIMsgID.DAILY, false));
        this.m_freqChkboxes[1] = new JRadioButton(this.m_bundle.getMessage(UIMsgID.WEEKLY, false));
        this.m_freqChkboxes[2] = new JRadioButton(String.valueOf(this.m_bundle.getMessage(UIMsgID.MONTHLY, false)) + SPACER);
        this.fillCountryCombo();
        this.setComboFont();
        this.m_csiNumberField.setText(this.m_genPageImpl.getCSI());
        this.m_metalinkField.setText(this.m_genPageImpl.getMetalinkID());
        this.m_autoUpdateChkBox.setSelected(this.m_genPageImpl.getAutoSoftwareUpdate());
        this.m_autoUploadChkbox.setSelected(this.m_schedImpl.getAutoUpload());
        this.m_freqChkboxes[this.m_schedImpl.getFrequency()].setSelected(true);
        this.fillDayCombo(1);
        this.fillDayCombo(this.m_schedImpl.getFrequency());
        this.fillUploadTimings();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        int n = 0;
        while (n < this.m_freqChkboxes.length) {
            if (itemSelectable == this.m_freqChkboxes[n]) {
                this.fillDayCombo(n);
                break;
            }
            ++n;
        }
    }

    private JPanel layTimeControls() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(this.m_hourCombo, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_labelHour, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_minCombo, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_labelMin, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_ampmCombo, gridBagConstraints);
        jPanel.add(this.m_hourCombo);
        jPanel.add(this.m_labelHour);
        jPanel.add(this.m_minCombo);
        jPanel.add(this.m_labelMin);
        jPanel.add(this.m_ampmCombo);
        return jPanel;
    }

    private void parseSelectedTime() {
        this.m_hour = Integer.parseInt((String)this.m_hourCombo.getSelectedItem());
        this.m_minute = Integer.parseInt((String)this.m_minCombo.getSelectedItem());
        if (this.m_pmStr.equalsIgnoreCase((String)this.m_ampmCombo.getSelectedItem())) {
            if (this.m_hour != 12) {
                this.m_hour += 12;
            }
        } else if (this.m_hour == 12) {
            this.m_hour = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(String[] var1_1, int var2_2, int var3_3) {
        block3: {
            if (var3_3 <= var2_2) break block3;
            var4_4 = var1_1[var2_2];
            var5_5 = var2_2;
            var6_6 = var3_3;
            ** GOTO lbl14
            {
                ++var5_5;
                do {
                    if (var4_4.compareTo(var1_1[var5_5]) >= 0 && var5_5 < var3_3) continue block0;
                    while (var4_4.compareTo(var1_1[var6_6]) <= 0 && var6_6 > var2_2) {
                        --var6_6;
                    }
                    if (var5_5 >= var6_6) continue;
                    this.swap(var1_1, var5_5, var6_6);
lbl14:
                    // 3 sources

                } while (var5_5 < var6_6);
            }
            this.swap(var1_1, var6_6, var2_2);
            this.quickSort(var1_1, var2_2, var6_6 - 1);
            this.quickSort(var1_1, var6_6 + 1, var3_3);
        }
    }

    private Container schedulePane() {
        CheckTitledPane checkTitledPane = new CheckTitledPane();
        checkTitledPane.setTitle(this.m_autoUploadChkbox);
        checkTitledPane.addListener(true);
        Container container = new Container();
        container.setLayout(new BorderLayout(5, 5));
        this.timingPane();
        container.add((Component)this.frequencyPane(), "West");
        container.add((Component)this.m_timePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(m_border5);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)container, "North");
        checkTitledPane.setContent(jPanel);
        return checkTitledPane;
    }

    private void setComboFont() {
        Font font = this.m_countryCombo.getFont();
        Font font2 = new Font(font.getName(), 0, font.getSize());
        this.m_countryCombo.setFont(font2);
        this.m_hourCombo.setFont(font2);
        this.m_minCombo.setFont(font2);
        this.m_ampmCombo.setFont(font2);
        this.m_dayCombo.setFont(font2);
    }

    private void swap(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }

    private void timingPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_timePanel.setBorder(new TitledBorder(this.m_bundle.getMessage(UIMsgID.WHEN, false)));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2, 0, 10));
        jPanel2.setLayout(new GridLayout(3, 2, 0, 10));
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        jPanel.add(this.m_labelDay);
        jPanel2.add(this.m_dayCombo);
        jPanel.add(this.m_labelAt);
        jPanel2.add(this.layTimeControls());
        this.m_timePanel.setLayout(new BorderLayout(0, 0));
        this.m_timePanel.add((Component)jPanel, "West");
        this.m_timePanel.add((Component)jPanel2, "Center");
    }

    public void validateChanges() throws PageException, CommandException {
        try {
            this.m_genPageImpl.setCSI(this.m_csiNumberField.getText());
        }
        catch (InvalValueException invalValueException) {
            this.m_csiNumberField.selectAll();
            this.m_csiNumberField.requestFocus();
            throw new PageException(invalValueException.getMessage(), this);
        }
        try {
            this.m_genPageImpl.setMetalinkID(this.m_metalinkField.getText());
        }
        catch (InvalValueException invalValueException) {
            this.m_metalinkField.selectAll();
            this.m_metalinkField.requestFocus();
            throw new PageException(invalValueException.getMessage(), this);
        }
        try {
            this.m_genPageImpl.setCountryName((String)this.m_countryCombo.getSelectedItem());
        }
        catch (InvalValueException invalValueException) {
            this.m_countryCombo.requestFocus();
            throw new PageException(invalValueException.getMessage(), this);
        }
        this.m_genPageImpl.setAutoSoftwareUpdate(this.m_autoUpdateChkBox.isSelected());
        this.validateSched();
    }

    private void validateSched() throws PageException, CommandException {
        int n = this.getSelectedFreq();
        this.m_schedImpl.setAutoUpload(this.m_autoUploadChkbox.isSelected());
        this.m_schedImpl.setFrequency(n);
        if (n == 1) {
            this.m_schedImpl.setWeekDay(this.getShortWeekDay((String)this.m_dayCombo.getSelectedItem()));
        } else if (n == 2) {
            this.m_schedImpl.setMonthDay((String)this.m_dayCombo.getSelectedItem());
        }
        this.parseSelectedTime();
        this.m_schedImpl.setHour(this.m_hour);
        this.m_schedImpl.setMinute(this.m_minute);
    }
}

