/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.sysman.ccr.ui.border.Layout;

public class CheckTitledPane
extends JComponent
implements ItemListener {
    private JCheckBox _title = null;
    private Component _content = null;
    private boolean addListener = false;
    private static final Border _sInnerBorder = new TitledBorder(null);
    private static final int _LABEL_INSET = 10;
    private static final int _COMPONENT_INSET = 5;

    public CheckTitledPane() {
        this(null, null);
    }

    public CheckTitledPane(JCheckBox jCheckBox, Component component) {
        this.setTitle(jCheckBox);
        this.setContent(component);
        super.setLayout(new Layout(this));
        this.setAlignmentX(0.0f);
    }

    Dimension __calculateSize(Dimension dimension, Dimension dimension2) {
        Insets insets = _sInnerBorder.getBorderInsets(this);
        return new Dimension(Math.max(dimension2.width, dimension.width + 30) + insets.left + insets.right, dimension.height + dimension2.height + insets.bottom);
    }

    void __doLayout() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this._getSize(this._title, true);
        Insets insets = _sInnerBorder.getBorderInsets(this);
        int n = dimension.width - 30;
        int n2 = dimension2.width;
        if (n < n2) {
            n2 = n;
        }
        int n3 = 15 + (int)((float)(n - n2) * this.getAlignmentX());
        if (this._title != null) {
            this._title.setBounds(n3, 0, n2, dimension2.height);
        }
        if (this._content != null) {
            this._content.setBounds(insets.left, dimension2.height, dimension.width - (insets.left + insets.right), dimension.height - (dimension2.height + insets.bottom));
        }
        super.setBorder(new CompoundBorder(new EmptyBorder(dimension2.height / 2, 0, 0, 0), _sInnerBorder));
    }

    Dimension _getSize(Component component, boolean bl) {
        if (component == null) {
            return new Dimension(0, 0);
        }
        return bl ? component.getPreferredSize() : component.getMinimumSize();
    }

    protected void addImpl(JCheckBox jCheckBox, Object object, int n) {
        if (jCheckBox != this._title && jCheckBox != this._content) {
            if (this._title == null) {
                this._title = jCheckBox;
            } else {
                Component component = this._content;
                if (component != null) {
                    this.remove(component);
                }
                this._content = jCheckBox;
            }
        }
        super.addImpl(jCheckBox, object, n);
    }

    public void addListener(boolean bl) {
        this.addListener = bl;
        if (this.addListener) {
            this._title.addItemListener(this);
            this.setContentEnableDisable();
        }
    }

    public Component getContent() {
        return this._content;
    }

    public boolean getListenerAdded() {
        return this.addListener;
    }

    public Component getTitle() {
        return this._title;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._title) {
            this.setContentEnableDisable();
        }
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        if (this._title != null) {
            Rectangle rectangle = this._title.getBounds();
            graphics.fillRect(rectangle.x - 5, rectangle.y, rectangle.width + 10, rectangle.height);
            graphics.setColor(color);
        }
    }

    public void setBorder(Border border) {
    }

    public static void setComponentEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                CheckTitledPane.setComponentEnabled(componentArray[n], bl);
                ++n;
            }
        }
    }

    public void setContent(Component component) {
        if (component != this._content) {
            if (this._content != null) {
                this.remove(this._content);
                this._content = null;
            }
            if (component != null) {
                this._content = component;
                this.add(component);
            }
        }
        this.setContentEnableDisable();
    }

    public void setContentEnableDisable() {
        if (this._title == null || this._content == null || !this.addListener) {
            return;
        }
        boolean bl = this._title.isSelected();
        this._content.setEnabled(bl);
        if (this._content instanceof Container) {
            Component[] componentArray = ((Container)this._content).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                CheckTitledPane.setComponentEnabled(componentArray[n], bl);
                ++n;
            }
        }
        this._content.invalidate();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void setTitle(JCheckBox jCheckBox) {
        if (jCheckBox != this._title) {
            if (this._title != null) {
                this.remove(this._title);
                this._title = null;
            }
            if (jCheckBox != null) {
                this._title = jCheckBox;
                this.add(jCheckBox);
            }
        }
        this.setContentEnableDisable();
    }
}

