/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.AgreementImpl;
import oracle.sysman.ccr.impl.InvalValueException;
import oracle.sysman.ccr.ui.EMCCRConfigAssistant;
import oracle.sysman.ccr.ui.dialog.DialogMsgID;

public class AgreementDialog
extends JDialog
implements ActionListener {
    private MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.ui.dialog.Dialog");
    private JTextArea licenseTerms = new JTextArea();
    private String m_title = this.s_bundle.getMessage(DialogMsgID.AGREEMENT_TITLE, false);
    private JButton okButton = new JButton(this.s_bundle.getMessage(DialogMsgID.OK, false));
    private JButton cancelButton = new JButton(this.s_bundle.getMessage(DialogMsgID.CANCEL, false));
    private JRadioButton m_accept = new JRadioButton(this.s_bundle.getMessage(DialogMsgID.ACCEPT, false));
    private EmptyBorder border10 = new EmptyBorder(10, 10, 10, 10);

    public AgreementDialog(Frame frame) throws FileReadException {
        super(frame, true);
        super.setTitle(this.m_title);
        try {
            this.showDialog();
        }
        catch (FileReadException fileReadException) {
            this.destroy();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            try {
                this.okPressed();
            }
            catch (InvalValueException invalValueException) {
                EMCCRConfigAssistant.errorDialog((Window)this, invalValueException);
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.destroy();
        }
    }

    private Container addInteractiveCtls() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        buttonGroup.add(this.m_accept);
        jPanel.add(this.m_accept);
        JRadioButton jRadioButton = new JRadioButton(this.s_bundle.getMessage(DialogMsgID.DECLINE, false));
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        this.m_accept.setSelected(true);
        return jPanel;
    }

    private Container addLicense() throws FileReadException {
        JLabel jLabel = new JLabel(this.s_bundle.getMessage(DialogMsgID.DESC_TEXT, false));
        this.addLicenseText();
        this.licenseTerms.setEditable(false);
        this.licenseTerms.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.licenseTerms);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 20));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void addLicenseText() throws FileReadException {
        Reader reader = AgreementImpl.getLicenseText();
        int n = 500;
        char[] cArray = new char[500];
        int n2 = 0;
        boolean bl = true;
        while (n2 != -1) {
            try {
                n2 = reader.read(cArray, 0, 500);
            }
            catch (IOException iOException) {
                n2 = -1;
            }
            if (n2 == -1) continue;
            this.licenseTerms.append(new String(cArray, 0, n2));
            bl = false;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        if (bl) {
            throw new FileReadException(this.s_bundle.getMessage(DialogMsgID.LICENSE_FILE_MISSING_ERR, false));
        }
    }

    private Container buttonBar() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void destroy() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void okPressed() throws InvalValueException {
        if (this.m_accept.isSelected()) {
            AgreementImpl agreementImpl = new AgreementImpl();
            agreementImpl.setAccepted(true);
            agreementImpl.applyChanges();
            try {
                agreementImpl.save();
            }
            catch (FileWriteException fileWriteException) {
                EMCCRConfigAssistant.errorDialog((Window)this, fileWriteException);
                agreementImpl.setAccepted(false);
                agreementImpl.applyChanges();
            }
        }
        this.destroy();
    }

    public void showDialog() throws FileReadException {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setBorder(this.border10);
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel2.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel2.add(this.addInteractiveCtls());
        jPanel2.add(this.buttonBar());
        jPanel.add((Component)this.addLicense(), "Center");
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        ((Component)this).setSize(620, 425);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.getRootPane().setDefaultButton(this.okButton);
        ((Component)this).setVisible(true);
    }
}

