/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.ui.EMCCRConfigAssistant;
import oracle.sysman.ccr.ui.dialog.DialogMsgID;

public class HelpDialog
extends JDialog {
    private MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.ui.dialog.Dialog");
    private HelpDialog me = null;
    private JButton m_okButton = new JButton(this.s_bundle.getMessage(DialogMsgID.OK, false));
    private JEditorPane m_contentPane = null;
    private Frame m_parent = null;
    private URL m_urlSrc = null;
    private String m_title = this.s_bundle.getMessage(DialogMsgID.HELP_TITLE, false);
    private Dimension dialogSize = new Dimension(500, 550);

    private HelpDialog(Frame frame, String string) {
        super(frame);
        this.m_parent = frame;
        if (string != null) {
            this.m_title = string;
        }
        this.setTitle(this.m_title);
        this.me = this;
    }

    public HelpDialog(Frame frame, String string, URL uRL) {
        this(frame, string);
        this.m_urlSrc = uRL;
        this.initialize();
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                block4: {
                    if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED || hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block4;
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HelpDialog.this.m_contentPane.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                    } else {
                        try {
                            HelpDialog.this.m_contentPane.setPage(hyperlinkEvent.getURL());
                        }
                        catch (IOException iOException) {
                            EMCCRConfigAssistant.errorDialog((Window)HelpDialog.this.me, HelpDialog.this.s_bundle.getMessage(DialogMsgID.URL_NOT_FOUND_ERR, false));
                        }
                    }
                }
            }
        };
    }

    private Container fillHelpContent() {
        this.m_contentPane = new JEditorPane();
        this.m_contentPane.setEditable(false);
        this.m_contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.m_contentPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.m_contentPane.addHyperlinkListener(this.createHyperLinkListener());
        return jScrollPane;
    }

    private void initialize() {
        JPanel jPanel = new JPanel();
        this.setProperties();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.m_okButton);
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)HelpDialog.this.me).setVisible(false);
                HelpDialog.this.me.dispose();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jPanel, "South");
        jPanel2.add((Component)this.fillHelpContent(), "Center");
        this.getContentPane().add(jPanel2);
        ((Component)this).setVisible(true);
        ((Component)this).setSize(this.dialogSize.width - 1, this.dialogSize.height);
        try {
            this.m_contentPane.setPage(this.m_urlSrc);
        }
        catch (IOException iOException) {
            EMCCRConfigAssistant.errorDialog((Window)this.me, this.s_bundle.getMessage(DialogMsgID.URL_NOT_FOUND_ERR, false));
        }
    }

    private void setProperties() {
        Dimension dimension = this.m_parent.getSize();
        double d = this.m_parent.getX() + 50;
        double d2 = (double)this.m_parent.getY() + (dimension.getHeight() - (double)this.dialogSize.height) / 2.0;
        ((Component)this).setSize(this.dialogSize);
        ((Component)this).setLocation((int)d, (int)d2);
    }
}

