/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.OCMProxySpecException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class OCMProxySpec {
    public static final int OCMPROXY_S_OK = 0;
    public static final int OCMPROXY_E_INVALID_SPEC = 1;
    public static final int OCMPROXY_E_UNKNOWNHOST = 2;
    public static final int OCMPROXY_E_INVALIDPORT = 3;
    public static final int OCMPROXY_E_PWD_MISSING = 4;
    public static final int OCMPROXY_E_CONNECT = 5;
    public static final int OCMPROXY_MAX_PORT_NUMBER = 65535;
    public static final int OCMPROXY_DEFAULT_PROXY_PORT = 80;
    public static final String OCMPROXY_NO_PROXY = "NONE";
    public static final String OCMPROXY_PROP_HOST = "http.proxyHost";
    public static final String OCMPROXY_PROP_PORT = "http.proxyPort";
    public static final String OCMPROXY_PROP_PASSWORD = "http.proxyPassword";
    public static final String OCMPROXY_PROP_USER = "http.proxyUser";
    public static final String OCMPROXY_PROP_PWDSEED = "ccr.proxypswd.seed";
    public static final String OCMPROXY_REGEXP = "^((.*?)@)?([^@:]+)(:(\\d+))?$";
    public static final int OCMPROXY_REGEXP_USER = 2;
    public static final int OCMPROXY_REGEXP_HOST = 3;
    public static final int OCMPROXY_REGEXP_PORT = 5;
    private static RE s_proxyRegExp = null;
    private boolean m_bProxyNONE = false;
    private String m_strHost = null;
    private int m_nPort = 80;
    private String m_strUsername = null;
    private int m_retCode = 0;
    private transient byte[] m_arrayChPwd = null;
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$util$OCMProxySpec != null ? class$oracle$sysman$ccr$util$OCMProxySpec : (class$oracle$sysman$ccr$util$OCMProxySpec = OCMProxySpec.class$("oracle.sysman.ccr.util.OCMProxySpec")));
    static /* synthetic */ Class class$oracle$sysman$ccr$util$OCMProxySpec;

    static {
        try {
            s_proxyRegExp = new RE(OCMPROXY_REGEXP);
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException(rESyntaxException.getMessage());
        }
    }

    public OCMProxySpec() {
        this.resetProxyInformation();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String getDisplayString(String string, boolean bl) {
        int n = 0;
        String string2 = string;
        if (bl && string != null && (n = string.length()) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append('*');
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public String getProxyHost() {
        return this.m_strHost;
    }

    public int getProxyPort() {
        return this.m_nPort;
    }

    public byte[] getProxyPwd() {
        return this.m_arrayChPwd;
    }

    public String getProxyUser() {
        return this.m_strUsername;
    }

    public int getRetCode() {
        return this.m_retCode;
    }

    public boolean isProxyNone() {
        return this.m_bProxyNONE;
    }

    public boolean isValid() {
        return this.m_retCode == 0;
    }

    private void parseCreds(String string) throws OCMProxySpecException {
        String string2 = "^(.*)/(.*)$";
        String string3 = null;
        this.m_arrayChPwd = null;
        if (string == null || string.length() == 0) {
            return;
        }
        RE rE = null;
        try {
            rE = new RE("^(.*)/(.*)$");
            if (rE.match(string)) {
                this.m_strUsername = rE.getParen(1);
                string3 = rE.getParen(2);
                if (string3 != null && string3.length() > 0) {
                    this.m_arrayChPwd = string3.getBytes();
                }
            }
            if (this.m_arrayChPwd == null) {
                throw new OCMProxySpecException(4, "Password missing");
            }
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException(rESyntaxException.getMessage());
        }
    }

    public boolean requiresProxyPwd() {
        boolean bl = false;
        if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0 && this.m_arrayChPwd == null) {
            bl = true;
        }
        return bl;
    }

    public void resetProxyInformation() {
        this.m_strHost = "";
        this.m_nPort = 80;
        this.m_strUsername = null;
        this.m_arrayChPwd = null;
        this.m_bProxyNONE = false;
        this.m_retCode = 0;
    }

    public void setNoProxy() {
        this.resetProxyInformation();
        this.m_bProxyNONE = true;
    }

    public void setProxyCreds(byte[] byArray) {
        this.m_bProxyNONE = false;
        this.m_arrayChPwd = byArray;
    }

    public int setProxyPort(int n) {
        if (n <= 0 || n > 65535) {
            return 3;
        }
        this.m_bProxyNONE = false;
        this.m_nPort = n;
        return 0;
    }

    public void validateAndParse(String string) throws OCMProxySpecException {
        this.validateAndParse(string, false);
    }

    public void validateAndParse(String string, boolean bl) throws OCMProxySpecException {
        if (!s_proxyRegExp.match(string = string.trim())) {
            s_logger.debug("About to throw an exception");
            this.m_retCode = 1;
            throw new OCMProxySpecException(1, this.getDisplayString(string, bl));
        }
        this.resetProxyInformation();
        if (string.trim().equals(OCMPROXY_NO_PROXY)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Proxy is a NO_PROXY type");
            }
            this.resetProxyInformation();
            this.m_bProxyNONE = true;
        } else {
            String string2;
            block23: {
                int n;
                Object object;
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Proxy specification given as: " + this.getDisplayString(string, bl));
                }
                string2 = s_proxyRegExp.getParen(3);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Hostname extracted is: " + string2);
                }
                try {
                    object = InetAddress.getAllByName(string2);
                    if (s_logger.isDebugEnabled()) {
                        if (object == null) {
                            s_logger.debug("Address translations result in: " + object);
                        } else {
                            s_logger.debug("[" + ((Object)object).length + "] Translations of " + string2 + ":");
                            n = 0;
                            while (n < ((Object)object).length) {
                                s_logger.debug("    " + object[n]);
                                ++n;
                            }
                        }
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.m_retCode = 2;
                    throw new OCMProxySpecException(2, string2);
                }
                if ((object = s_proxyRegExp.getParen(5)) != null && ((String)object).trim().length() != 0) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("Proxy port detected with value of: " + (String)object);
                    }
                    try {
                        n = Integer.parseInt((String)object);
                        if (this.setProxyPort(n) != 0) {
                            this.m_retCode = 3;
                            throw new OCMProxySpecException(3, (String)object);
                        }
                        break block23;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_retCode = 3;
                        throw new OCMProxySpecException(3, (String)object);
                    }
                }
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Using default port of: 80");
                }
                if (this.setProxyPort(80) != 0) {
                    this.m_retCode = 3;
                    throw new OCMProxySpecException(3, Integer.toString(80));
                }
            }
            this.m_strHost = string2;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Proxy host set to: " + this.m_strHost);
            }
            this.m_strUsername = s_proxyRegExp.getParen(2);
            if (this.m_strUsername != null) {
                this.m_strUsername = this.m_strUsername.trim();
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Proxy username specified with value of: " + this.getDisplayString(this.m_strUsername, bl));
                }
            }
            this.m_arrayChPwd = null;
            if (bl) {
                this.parseCreds(this.m_strUsername);
            }
            this.m_bProxyNONE = false;
        }
        this.m_retCode = 0;
    }
}

