/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.Process;

public class Process {
    private java.lang.Process m_process = null;
    static final int DEFAULT_PROCESS_TIMEOUT = 300;
    static final int DEFAULT_THREAD_JOIN_TIMEOUT = 5;
    static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$util$Process != null ? class$oracle$sysman$ccr$util$Process : (class$oracle$sysman$ccr$util$Process = Process.class$("oracle.sysman.ccr.util.Process")));
    static int s_nTimeoutValue = -1;
    static /* synthetic */ Class class$oracle$sysman$ccr$util$Process;

    static {
        Config config = UplinkHomeConfig.getInstance();
        s_nTimeoutValue = config.getProperty("ccr.process.timeout", 300);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Monitoring of child processes to " + s_nTimeoutValue + "s.");
        }
        s_nTimeoutValue *= 1000;
    }

    private Process(java.lang.Process process) {
        this.m_process = process;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void closeStdIn() throws IOException {
        if (this.m_process != null) {
            this.m_process.getOutputStream().close();
        }
    }

    public static Process exec(String[] stringArray, String[] stringArray2, String[] stringArray3) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = new Process(runtime.exec(stringArray, stringArray2));
        if (stringArray3 != null && stringArray3.length != 0) {
            process.writeStdInParams(stringArray3);
        }
        process.closeStdIn();
        return process;
    }

    public int waitFor(StringBuffer stringBuffer) throws IOException, InterruptedException {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_process.getInputStream(), "UTF-8"));
        final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.m_process.getErrorStream(), "UTF-8"));
        final StringBuffer stringBuffer2 = new StringBuffer();
        final StringBuffer stringBuffer3 = new StringBuffer();
        class Trouble {
            public IOException exception;

            Trouble() {
                this.exception = null;
            }
        }
        final Trouble trouble = new Trouble();
        Thread thread = new Thread(){
            {
            }

            public void run() {
                try {
                    try {
                        int n;
                        while ((n = bufferedReader.read()) != -1) {
                            stringBuffer2.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        trouble.exception = iOException;
                        m_process.destroy();
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        };
        Thread thread2 = new Thread(){
            {
            }

            public void run() {
                try {
                    try {
                        int n;
                        while ((n = bufferedReader2.read()) != -1) {
                            stringBuffer3.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        trouble.exception = iOException;
                        m_process.destroy();
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        bufferedReader2.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    bufferedReader2.close();
                }
                catch (IOException iOException) {}
            }
        };
        ProcessMonitor processMonitor = new ProcessMonitor(Thread.currentThread(), this);
        thread.setDaemon(true);
        thread2.setDaemon(true);
        this.waitForMonitorToStart(processMonitor);
        thread.start();
        thread2.start();
        int n = -1;
        boolean bl = false;
        try {
            n = this.m_process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            bl = true;
            this.m_process.destroy();
        }
        ProcessMonitor processMonitor2 = processMonitor;
        synchronized (processMonitor2) {
            processMonitor.stopMonitoring();
            processMonitor.notify();
        }
        try {
            thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            thread2.join(5000L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            thread.interrupt();
        }
        catch (SecurityException securityException) {}
        try {
            thread2.interrupt();
        }
        catch (SecurityException securityException) {}
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(stringBuffer3.toString());
        if (bl) {
            throw new InterruptedException("Process terminated - exceeded timeout.");
        }
        if (trouble.exception != null) {
            throw trouble.exception;
        }
        return n;
    }

    private void waitForMonitorToStart(ProcessMonitor processMonitor) throws InterruptedException {
        ProcessMonitor processMonitor2 = processMonitor;
        synchronized (processMonitor2) {
            long l = System.currentTimeMillis();
            long l2 = s_nTimeoutValue;
            processMonitor.start();
            while (!processMonitor.isMonitoring()) {
                try {
                    processMonitor.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    if (!processMonitor.isMonitoring()) {
                        long l3 = System.currentTimeMillis();
                        l2 = (long)s_nTimeoutValue - (l3 - l);
                    }
                    if (l2 > 0L) continue;
                    throw new InterruptedException("SubProcess Monitor thread failed to initialize");
                }
            }
        }
    }

    private void writeStdInParams(String[] stringArray) throws IOException {
        if (this.m_process != null) {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.m_process.getOutputStream()));
            int n = 0;
            while (n < stringArray.length) {
                bufferedWriter.write(stringArray[n]);
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.flush();
        }
    }

    class ProcessMonitor
    extends Thread {
        Thread m_parentThread = null;
        Process m_parentInstance = null;
        boolean m_bStopped = true;

        ProcessMonitor(Thread thread, Process process2) {
            this.stopMonitoring();
            this.setParent(thread, process2);
        }

        public boolean isMonitoring() {
            return this.m_bStopped ^ true;
        }

        public void run() {
            ProcessMonitor processMonitor = this;
            synchronized (processMonitor) {
                this.startMonitoring();
                this.notify();
                long l = System.currentTimeMillis();
                long l2 = s_nTimeoutValue;
                while (this.isMonitoring()) {
                    try {
                        this.wait(l2);
                        if (!this.isMonitoring()) continue;
                        this.stopMonitoring();
                        this.m_parentThread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        long l3 = System.currentTimeMillis();
                        l2 = (long)s_nTimeoutValue - (l3 - l);
                    }
                }
            }
        }

        private void setParent(Thread thread, Process process) {
            this.m_parentThread = thread;
            this.m_parentInstance = process;
        }

        public void startMonitoring() {
            this.m_bStopped = false;
        }

        public void stopMonitoring() {
            this.m_bStopped = true;
        }
    }
}

