/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Arrays;

public class SecurePrompter {
    private static final char[] checkBuffer(char[] cArray, int n) throws RuntimeException {
        char[] cArray2;
        if (cArray == null) {
            throw new RuntimeException("checkBuffer buffer is null");
        }
        if (n < 0) {
            throw new RuntimeException("checkBuffer offset is negative");
        }
        if (n < cArray.length) {
            return cArray;
        }
        try {
            char[] cArray3 = new char[n + 128];
            System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
            cArray2 = cArray3;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Arrays.fill(cArray, ' ');
            throw throwable;
        }
        Arrays.fill(cArray, ' ');
        return cArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final char[] readLineSecure(PushbackInputStream pushbackInputStream) throws RuntimeException {
        if (pushbackInputStream == null) {
            throw new RuntimeException("readLineSecure inStream is null");
        }
        try {
            char[] cArray;
            char[] cArray2 = null;
            try {
                cArray2 = new char[128];
                int n = 0;
                block8: while (true) {
                    int n2 = pushbackInputStream.read();
                    switch (n2) {
                        case 13: {
                            int n3 = pushbackInputStream.read();
                            if (n3 == 10 || n3 == -1) break block8;
                            pushbackInputStream.unread(n3);
                            break block8;
                        }
                        default: {
                            cArray2 = SecurePrompter.checkBuffer(cArray2, n);
                            cArray2[n++] = (char)n2;
                            continue block8;
                        }
                        case -1: 
                        case 10: 
                    }
                    break;
                }
                char[] cArray3 = new char[n];
                System.arraycopy(cArray2, 0, cArray3, 0, n);
                cArray = cArray3;
                Object var4_7 = null;
                if (cArray2 == null) return cArray;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (cArray2 == null) throw throwable;
                Arrays.fill(cArray2, ' ');
                throw throwable;
            }
            Arrays.fill(cArray2, ' ');
            return cArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error occurred when reading password");
        }
    }

    public static final char[] readResponse(String string) throws RuntimeException {
        try {
            StreamMasker streamMasker = new StreamMasker(System.out, string);
            Thread thread = new Thread(streamMasker);
            int n = -1;
            PushbackInputStream pushbackInputStream = null;
            try {
                thread.start();
                pushbackInputStream = new PushbackInputStream(System.in);
                n = pushbackInputStream.read();
            }
            finally {
                Object var6_5 = null;
                streamMasker.stopMasking();
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupt occurred when reading information");
            }
            if (n == -1) {
                throw new RuntimeException("Console input ended unexpectedly");
            }
            if (System.out.checkError()) {
                throw new RuntimeException("Console password prompt output error");
            }
            pushbackInputStream.unread(n);
            return SecurePrompter.readLineSecure(pushbackInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error occurred when reading console response.");
        }
    }

    private static final class StreamMasker
    extends Thread {
        private static final String BLANKS = StreamMasker.repeatChars(' ', 10);
        private String m_promptOverwrite;
        private String m_setCursorToStart;
        private PrintStream m_out;
        private volatile boolean m_doMasking;

        public StreamMasker(PrintStream printStream, String string) throws RuntimeException {
            if (printStream == null) {
                throw new RuntimeException("StreamMasker outPrint is null");
            }
            if (string == null) {
                throw new RuntimeException("StreamMasker prompt is null");
            }
            if (string.indexOf(13) != -1) {
                throw new RuntimeException("StreamMasker prompt contains a CR");
            }
            if (string.indexOf(10) != -1) {
                throw new RuntimeException("StreamMasker prompt contains a NL");
            }
            this.m_out = printStream;
            this.m_setCursorToStart = StreamMasker.repeatChars('\b', string.length() + BLANKS.length());
            this.m_promptOverwrite = String.valueOf(this.m_setCursorToStart) + string + BLANKS + this.m_setCursorToStart + string;
        }

        private static String repeatChars(char c, int n) throws RuntimeException {
            if (n < 0) {
                throw new RuntimeException("repeatChars length is negative");
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(c);
                ++n2;
            }
            return stringBuffer.toString();
        }

        public void run() throws RuntimeException {
            int n = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.m_doMasking = true;
                while (this.m_doMasking) {
                    this.m_out.print(this.m_promptOverwrite);
                    this.m_out.flush();
                    if (this.m_out.checkError()) {
                        throw new RuntimeException("Console output error writing prompt");
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        Object var3_2 = null;
                        Thread.currentThread().setPriority(n);
                        return;
                    }
                }
                this.m_out.print(this.m_setCursorToStart);
                this.m_out.flush();
            }
            finally {
                Object var3_3 = null;
                Thread.currentThread().setPriority(n);
            }
        }

        public void stopMasking() {
            this.m_doMasking = false;
        }
    }
}

