/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.TrustedKeystoreException;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.UtilMsgID;

public class TrustedKeystore {
    private static KeyStore s_keystore = null;
    private static final String CA_KEYSTORE = "certca";
    private static final MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.util.Util");
    private static final String KEYSTORE_RESOURCE = "admin/security/oracle/sysman/ccr/collector/certca";
    public static final String USE_KEYSTORE_RESOURCE_PROP = "ocm.keystore_resource";
    static /* synthetic */ Class class$oracle$sysman$ccr$util$TrustedKeystore;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore createKeyStore(String string) throws TrustedKeystoreException {
        KeyStore keyStore;
        InputStream inputStream = null;
        try {
            try {
                keyStore = KeyStore.getInstance("JKS");
                inputStream = TrustedKeystore.getKeystoreResource(string);
                keyStore.load(inputStream, null);
            }
            catch (KeyStoreException keyStoreException) {
                throw new TrustedKeystoreException("Requested Keystore type (JKS) is not available", keyStoreException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TrustedKeystoreException("Unable to locate Oracle Configuration Manager Trusted Keystore", fileNotFoundException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new TrustedKeystoreException("Unable to verify keystore integrity", noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw new TrustedKeystoreException("Unable to load a trusted certificate", certificateException);
            }
            catch (IOException iOException) {
                throw new TrustedKeystoreException("Error reading keystore file", iOException);
            }
            Object var4_8 = null;
            if (inputStream == null) return keyStore;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return keyStore;
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    public static final KeyStore getInstance() throws TrustedKeystoreException {
        if (s_keystore == null) {
            Class clazz = class$oracle$sysman$ccr$util$TrustedKeystore != null ? class$oracle$sysman$ccr$util$TrustedKeystore : (class$oracle$sysman$ccr$util$TrustedKeystore = TrustedKeystore.class$("oracle.sysman.ccr.util.TrustedKeystore"));
            synchronized (clazz) {
                if (s_keystore == null) {
                    s_keystore = TrustedKeystore.createKeyStore(null);
                }
            }
        }
        return s_keystore;
    }

    private static InputStream getKeystoreResource(String string) throws FileNotFoundException {
        InputStream inputStream = null;
        String string2 = System.getProperty(USE_KEYSTORE_RESOURCE_PROP);
        if (string != null) {
            inputStream = new FileInputStream(string);
            return inputStream;
        }
        if (string2 != null) {
            Class clazz = class$oracle$sysman$ccr$util$TrustedKeystore != null ? class$oracle$sysman$ccr$util$TrustedKeystore : (class$oracle$sysman$ccr$util$TrustedKeystore = TrustedKeystore.class$("oracle.sysman.ccr.util.TrustedKeystore"));
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if ((inputStream = classLoader.getResourceAsStream(KEYSTORE_RESOURCE)) == null) {
                throw new FileNotFoundException(s_msgBundle.getMessage(UtilMsgID.KEYSTORE_RESOURCE_NOTFOUND, false, (Object[])new String[]{string2}));
            }
        } else {
            String string3 = System.getProperty("ORACLE_HOME");
            String string4 = FileSpec.catfile(new String[]{string3, UplinkPath.SECURITY_PATH, CA_KEYSTORE});
            inputStream = new FileInputStream(string4);
        }
        return inputStream;
    }
}

