/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.PropConfig;
import oracle.sysman.util.crypt.Crypt;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Utils {
    static String oHome = System.getProperty("oracle.home");
    private static final Logger mLog = Logger.getInstance(class$oracle$sysman$ccr$util$Utils != null ? class$oracle$sysman$ccr$util$Utils : (class$oracle$sysman$ccr$util$Utils = Utils.class$("oracle.sysman.ccr.util.Utils")));
    private static RE s_patternCN = null;
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int MICRO = 2;
    public static final int ALL = 4;
    private static String s_digits;
    static /* synthetic */ Class class$oracle$sysman$ccr$util$Utils;

    static {
        try {
            s_patternCN = new RE("^CN=(.*?),\\s*(OU|O|L|S|C)=");
        }
        catch (RESyntaxException rESyntaxException) {}
        s_digits = "0123456789ABCDEF";
    }

    private Utils() {
    }

    public static byte[] asciiStringToByteArray(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n2 = 0;
        while (n2 < string.length() / 2) {
            byArray[n2] = Utils.nibblesToByte(string.charAt(n2 * 2), string.charAt(n2 * 2 + 1));
            ++n2;
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final int compareVersions(String string, String string2) throws NumberFormatException {
        return Utils.compareVersions(string, string2, 4);
    }

    /*
     * Unable to fully structure code
     */
    public static final int compareVersions(String var0, String var1_1, int var2_2) throws NumberFormatException {
        block11: {
            if (var0 == null || var0.length() < 1 || var1_1 == null || var1_1.length() < 1) {
                throw new NumberFormatException("Empty version string (" + var0 + "," + var1_1 + ")");
            }
            var3_3 = Utils.getVersions(var0);
            var4_4 = Utils.getVersions(var1_1);
            if (var3_3[0] == -1 || var4_4[0] == -1) {
                throw new NumberFormatException("Illegal version strings (" + var0 + "," + var1_1 + ")");
            }
            if (var2_2 < 0 || var2_2 > 4) {
                var2_2 = 2;
            }
            var5_5 = 0;
            var6_6 = 0;
            while (var5_5 <= var2_2) {
                if (var3_3[var5_5] == -1 || var4_4[var5_5] == -1) break;
                if (var3_3[var5_5] != var4_4[var5_5]) {
                    var6_6 = var3_3[var5_5] > var4_4[var5_5] ? 1 : -1;
                    break;
                }
                ++var5_5;
            }
            if (var6_6 != 0 || var5_5 > var2_2) break block11;
            if (var3_3[var5_5] == -1) ** GOTO lbl27
            while (var5_5 <= var2_2 && var3_3[var5_5] == 0) {
                ++var5_5;
            }
            if (var5_5 > var2_2 || var3_3[var5_5] <= 0) break block11;
            var6_6 = 1;
            break block11;
lbl-1000:
            // 1 sources

            {
                ++var5_5;
lbl27:
                // 2 sources

                ** while (var5_5 <= var2_2 && var4_4[var5_5] == 0)
            }
lbl28:
            // 1 sources

            if (var5_5 <= var2_2 && var4_4[var5_5] > 0) {
                var6_6 = -1;
            }
        }
        return var6_6;
    }

    public static void copyFile(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n = 1024;
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
            }
        }
        finally {
            Object var5_7 = null;
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static char[] decryptValue(String string, String string2) {
        Crypt crypt = new Crypt();
        byte[] byArray = Utils.asciiStringToByteArray(string);
        byte[] byArray2 = crypt.decryptAsByteArray(byArray, string2.getBytes());
        char[] cArray = new char[byArray2.length];
        int n = 0;
        while (n < byArray2.length) {
            cArray[n] = (char)byArray2[n];
            ++n;
        }
        return cArray;
    }

    public static String extractCName(String string) {
        String string2 = null;
        if (s_patternCN.match(string)) {
            string2 = s_patternCN.getParen(1);
        }
        return string2;
    }

    public static byte[] fromHex(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("HEX String doesn't have even number of characters: '" + string + "'");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2 / 2] = (byte)((Character.digit(string.charAt(n2), 16) << 4) + Character.digit(string.charAt(n2 + 1), 16));
            n2 += 2;
        }
        return byArray;
    }

    public static String generateGUID(String[] stringArray) throws Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append(":").append(stringArray[n]);
                ++n;
            }
            String string = stringBuffer.toString();
            if (mLog.isDebugEnabled()) {
                mLog.debug("Generate GUID for [" + string + "]");
            }
            byte[] byArray = messageDigest.digest(string.getBytes());
            stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = byArray[n2] & 0xFF;
                String string2 = Integer.toHexString(n3);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
                ++n2;
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("Unable to get MD5 GUID\n" + noSuchAlgorithmException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getCredInfo(String string) throws CredentialsNotFoundException {
        Properties properties;
        File file;
        block11: {
            if (string == null) {
                throw new CredentialsNotFoundException("Could not obtain path of credentials file.");
            }
            file = new File(string);
            FileInputStream fileInputStream = null;
            Properties properties2 = new Properties();
            try {
                try {
                    if (mLog.isDebugEnabled()) {
                        mLog.debug("Loading credentials information from " + file);
                    }
                    fileInputStream = new FileInputStream(file);
                    properties2.load(fileInputStream);
                    properties = properties2;
                    Object var6_5 = null;
                    if (fileInputStream == null) break block11;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new CredentialsNotFoundException("Could not access the credentials file.", fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new CredentialsNotFoundException("An error occurred while reading the credentails file.", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (file.delete()) throw throwable;
                file.deleteOnExit();
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
        }
        if (file.delete()) return properties;
        file.deleteOnExit();
        return properties;
    }

    public static String getDigest(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < byArray2.length) {
            int n3 = byArray2[n2] & 0xFF;
            String string = Integer.toHexString(n3);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getDigest(String string) throws NoSuchAlgorithmException, DigestException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        messageDigest.update(string.getBytes());
        byte[] byArray = new byte[20];
        messageDigest.digest(byArray, 0, 20);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            string = Integer.toHexString(0xFF & byArray[n]);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString().toUpperCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileContent(File file) throws FileNotFoundException, IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(1024);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            string = stringBuffer.toString();
            Object var5_6 = null;
            if (bufferedReader == null) return string;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return string;
    }

    public static String getPostDataFromMap(String string, Hashtable hashtable) {
        String[] stringArray = (String[])hashtable.get(string);
        return stringArray == null ? null : stringArray[0];
    }

    public static String getValFromMap(String string, Map map) {
        String[] stringArray = (String[])map.get(string);
        return stringArray == null ? null : stringArray[0];
    }

    private static int[] getVersions(String string) throws NumberFormatException {
        int[] nArray = new int[]{-1, -1, -1, -1, -1};
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (n < 5 && stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public static void initLogger(String string) {
        try {
            PropConfig propConfig = new PropConfig(string);
            Properties properties = propConfig.getProperties();
            Logger.init(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("defaulting to BasicConfigurator/INFO");
            mLog.setTraceLevel("INFO");
        }
        catch (IOException iOException) {
            System.out.println("defaulting to BasicConfigurator/INFO");
            mLog.setTraceLevel("INFO");
        }
    }

    public static boolean isNumeric(String string) {
        boolean bl;
        block2: {
            bl = false;
            if (string == null) break block2;
            try {
                Long.parseLong(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    public static byte nibblesToByte(char c, char c2) {
        return (byte)((byte)Character.digit(c, 16) << 4 | (byte)Character.digit(c2, 16) & 0xF);
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                        n += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(n);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) break;
                        ++n;
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Hashtable parsePostData(int n, InputStream inputStream) {
        if (n <= 0) {
            return new Hashtable();
        }
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n];
        try {
            int n2;
            int n3 = 0;
            do {
                if ((n2 = inputStream.read(byArray, n3, n - n3)) > 0) continue;
                throw new IllegalArgumentException("err.io.short_read");
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        try {
            String string = new String(byArray, 0, n, "8859_1");
            return Utils.parseQueryString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
    }

    public static Hashtable parseQueryString(String string) {
        Object object;
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n = ((String)object).indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string2 = Utils.parseName(((String)object).substring(0, n), stringBuffer);
            String string3 = Utils.parseName(((String)object).substring(n + 1, ((String)object).length()), stringBuffer);
            if (hashtable.containsKey(string2)) {
                String[] stringArray2 = (String[])hashtable.get(string2);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string3;
            } else {
                stringArray = new String[]{string3};
            }
            hashtable.put(string2, stringArray);
        }
        if (mLog.isDebugEnabled()) {
            mLog.debug("Query/post parameters follow:");
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string4 = (String)object.nextElement();
                mLog.debug("  key: " + string4 + " value: " + ((String[])hashtable.get(string4))[0]);
            }
        }
        return hashtable;
    }

    public static Properties readConfig(String string) {
        Properties properties = new Properties();
        try {
            PropConfig propConfig = new PropConfig(string);
            properties = propConfig.getProperties();
        }
        catch (IOException iOException) {}
        return properties;
    }

    public static Properties readProperties(File file) {
        Properties properties;
        block4: {
            properties = new Properties();
            if (mLog.isEnabledFor(Logger.DEBUG)) {
                mLog.debug("Reading properties from " + file.getAbsolutePath());
            }
            if (!file.exists()) break block4;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public static String toHex(byte[] byArray) {
        return Utils.toHex(byArray, 0, byArray.length);
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("data length (" + byArray.length + ") is smaller then offset (" + n + ") plus length (" + n2 + ")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            int n4 = byArray[n3] & 0xFF;
            stringBuffer.append(s_digits.charAt(n4 >> 4));
            stringBuffer.append(s_digits.charAt(n4 & 0xF));
            ++n3;
        }
        return stringBuffer.toString();
    }
}

