/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.util.crypt;

import oracle.sysman.util.crypt.CryptException;
import oracle.sysman.util.crypt.DES;
import oracle.sysman.util.crypt.DataHolder;

public class Crypt {
    private DES desEngine = new DES();
    private static final byte ZERO_PAD = 0;
    private static final byte SPACE_PAD = 32;

    public static byte[] asciiStringToByteArray(String string) {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        int n = string.length();
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = Crypt.nibblesToByte(cArray[n3 * 2], cArray[n3 * 2 + 1]);
            ++n3;
        }
        return byArray;
    }

    public static String byteArrayToAsciiString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Crypt.byteToAsciiHN(byArray[n]));
            stringBuffer.append(Crypt.byteToAsciiLN(byArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static char byteToAsciiHN(byte by) {
        return Character.forDigit(by >>> 4 & 0xF, 16);
    }

    private static char byteToAsciiLN(byte by) {
        return Character.forDigit(by & 0xF, 16);
    }

    public void close() {
        this.desEngine.nullKeys();
        this.desEngine = null;
    }

    public synchronized String decrypt(String string, String string2) {
        if (string == null || string.length() <= 0 || string2 == null) {
            return string;
        }
        byte[] byArray = Crypt.asciiStringToByteArray(string);
        String string3 = new String(this.decryptAsByteArray(byArray, string2.getBytes()));
        return string3;
    }

    public synchronized byte[] decryptAsByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return new byte[0];
        }
        if (byArray.length <= 0 || byArray2 == null) {
            return byArray;
        }
        byArray2 = this.padBytes(byArray2, (byte)32);
        int n = byArray.length;
        byte[] byArray3 = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        this.desEngine.setKeys(byArray3);
        DataHolder dataHolder = new DataHolder(byArray);
        int n3 = 0;
        while (n3 < n) {
            byte[] byArray4 = dataHolder.getSet();
            try {
                this.desEngine.desDecryption(byArray4, 1);
            }
            catch (CryptException cryptException) {
                System.out.println("Caught cryptException");
            }
            dataHolder.putSet(byArray4);
            n3 += 8;
        }
        this.desEngine.nullKeys();
        return this.stripPadBytes(dataHolder.getResult(), (byte)0);
    }

    public String encrypt(String string, String string2) {
        if (string == null || string.length() <= 0 || string2 == null) {
            return string;
        }
        byte[] byArray = this.encryptAsByteArray(string, string2);
        String string3 = Crypt.byteArrayToAsciiString(byArray);
        return string3;
    }

    public byte[] encryptAsByteArray(String string, String string2) {
        if (string == null) {
            return new byte[0];
        }
        if (string.length() <= 0 || string2 == null) {
            return string.getBytes();
        }
        return this.encryptAsByteArray(string.getBytes(), string2.getBytes());
    }

    public synchronized byte[] encryptAsByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return new byte[0];
        }
        if (byArray.length <= 0 || byArray2 == null) {
            return byArray;
        }
        byArray = this.padBytes(byArray, (byte)0);
        byArray2 = this.padBytes(byArray2, (byte)32);
        int n = byArray.length;
        byte[] byArray3 = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        this.desEngine.setKeys(byArray3);
        DataHolder dataHolder = new DataHolder(byArray);
        int n3 = 0;
        while (n3 < n) {
            byte[] byArray4 = dataHolder.getSet();
            try {
                this.desEngine.desEncryption(byArray4, 1);
            }
            catch (CryptException cryptException) {
                System.out.println("Caught cryptException");
            }
            dataHolder.putSet(byArray4);
            n3 += 8;
        }
        this.desEngine.nullKeys();
        return dataHolder.getResult();
    }

    private static byte nibblesToByte(char c, char c2) {
        return (byte)((byte)Character.digit(c, 16) << 4 | (byte)Character.digit(c2, 16) & 0xF);
    }

    private byte[] padBytes(byte[] byArray, byte by) {
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 < 8) {
            n = 8 - n3;
        } else {
            n2 = n3 % 8;
            if (n2 > 0) {
                n = 8 - n2;
            }
        }
        if (n == 0) {
            return byArray;
        }
        byArray2 = new byte[n3 + n];
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4] = byArray[n4];
            ++n4;
        }
        int n5 = n3 + n;
        int n6 = n3;
        while (n6 < n5) {
            byArray2[n6] = by;
            ++n6;
        }
        return byArray2;
    }

    private byte[] stripPadBytes(byte[] byArray, byte by) {
        int n = 0;
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            if (byArray[n2] != by) {
                n = n2 + 1;
                n2 = -1;
            }
            --n2;
        }
        if (n == byArray.length) {
            return byArray;
        }
        if (n == 0) {
            return new byte[n];
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }
}

