/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.util.XMLUtil;

public class XSDDataValue
implements XSDTypeConstants,
XSDConstantValues {
    protected boolean booleanValue;
    protected double doubleValue;
    protected int intValue;
    protected Object objValue;
    protected String lexicalValue;
    protected int basicType;
    static final String _true = "true";
    static final String _false = "false";
    static final int[] mDays = new int[]{31, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] minMonthDay = new int[]{0, 28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334, 365};
    static final int[] maxMonthDay = new int[]{0, 31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337, 366};
    static final double FLOATMAX = Math.pow(2.0, 24.0) * Math.pow(2.0, 104.0);
    static final double DOUBLEMAX = Math.pow(2.0, 53.0) * Math.pow(2.0, 970.0);
    public static final SimpleTimeZone UTC = new SimpleTimeZone(0, "UTC");

    public XSDDataValue() {
        this.basicType = 2;
        this.booleanValue = false;
    }

    public XSDDataValue(int n, String string) throws XSDException {
        this.setValue(n, string);
    }

    public void setValue(int n, String string) throws XSDException {
        this.lexicalValue = string.intern();
        this.basicType = n;
        this.booleanValue = false;
        this.doubleValue = 0.0;
        this.intValue = 0;
        String string2 = XSDTypeConstants.sTypes[this.basicType];
        try {
            switch (this.basicType) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    String string3 = this.lexicalValue;
                    if (string3 == _true || string3.equals("1")) {
                        this.booleanValue = true;
                        break;
                    }
                    if (string3 == _false || string3.equals("0")) {
                        this.booleanValue = false;
                        break;
                    }
                    throw new XSDException(24507, string, string2);
                }
                case 3: 
                case 4: {
                    if (string.equals("-INF")) {
                        this.doubleValue = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    if (string.equals("INF")) {
                        this.doubleValue = Double.POSITIVE_INFINITY;
                        break;
                    }
                    if (string.equals("NaN")) {
                        this.doubleValue = Double.NaN;
                        break;
                    }
                    if (this.basicType == 3) {
                        float f = Float.valueOf(string).floatValue();
                        if (f == Float.POSITIVE_INFINITY) {
                            this.doubleValue = Double.POSITIVE_INFINITY;
                            break;
                        }
                        if (f == Float.NEGATIVE_INFINITY) {
                            this.doubleValue = Double.NEGATIVE_INFINITY;
                            break;
                        }
                        this.doubleValue = f;
                        break;
                    }
                    this.doubleValue = Double.valueOf(string);
                    break;
                }
                case 5: {
                    this.booleanValue = false;
                    if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                        throw new XSDException(24507, string, string2);
                    }
                    int n2 = string.length();
                    if (string.charAt(0) == '+') {
                        this.lexicalValue = this.lexicalValue.substring(1, n2--).intern();
                    }
                    try {
                        this.intValue = Integer.parseInt(this.lexicalValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.lexicalValue.charAt(n2 - 1) == '.') {
                            this.lexicalValue = this.lexicalValue.substring(0, n2).intern();
                        }
                        this.objValue = new BigDecimal(this.lexicalValue);
                        this.booleanValue = true;
                    }
                    break;
                }
                case 6: {
                    this.parseTimeDuration(string);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    this.parseTimeInstant(string);
                    break;
                }
                case 15: {
                    this.lexicalValue = this.parseHexBinary(string).intern();
                    break;
                }
                case 16: {
                    this.lexicalValue = this.parseBase64Binary(string).intern();
                    break;
                }
                case 17: {
                    if (!XSDSimpleType.isURI(string)) {
                        throw new XSDException(24507, string, string2);
                    }
                    break;
                }
                case 18: 
                case 19: {
                    if (string == "") {
                        throw new XSDException(24507, string, string2);
                    }
                    XMLUtil.validateQualifiedName(string);
                    this.objValue = null;
                    break;
                }
                default: {
                    throw new XSDException(24507, string, string2);
                }
            }
        }
        catch (Exception exception) {
            throw new XSDException(24507, string, string2);
        }
    }

    public void setQNameValue(String string, String string2, String string3) {
        this.lexicalValue = string;
        this.objValue = new QName(string2, string3);
    }

    protected void copyDataValue(XSDDataValue xSDDataValue) {
        this.basicType = xSDDataValue.basicType;
        this.booleanValue = xSDDataValue.booleanValue;
        this.doubleValue = xSDDataValue.doubleValue;
        this.intValue = xSDDataValue.intValue;
        this.lexicalValue = xSDDataValue.lexicalValue;
        this.objValue = xSDDataValue.objValue;
    }

    private String parseHexBinary(String string) throws XSDException {
        int n = string.length();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
            if (c >= 'a' && c <= 'f') {
                cArray[i] = Character.toUpperCase(c);
                continue;
            }
            throw new XSDException();
        }
        return new String(cArray);
    }

    private String parseBase64Binary(String string) throws XSDException {
        int n = string.length();
        int n2 = 0;
        this.intValue = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isSpace(c)) continue;
            if (n2 == 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'z' || c == '/' || c == '+')) {
                ++this.intValue;
                continue;
            }
            if (n2 < 2 && c == '=') {
                ++this.intValue;
                ++n2;
                continue;
            }
            throw new XSDException();
        }
        if (this.intValue % 4 != 0) {
            throw new XSDException();
        }
        this.intValue = this.intValue * 3 / 4 - n2;
        return string;
    }

    int getBasicType() {
        return this.basicType;
    }

    public int getLength() throws XSDException {
        switch (this.basicType) {
            case 1: 
            case 18: {
                return this.lexicalValue.length();
            }
            case 15: {
                return this.lexicalValue.length() / 2;
            }
            case 16: {
                return this.intValue;
            }
            case 17: 
            case 19: {
                return this.lexicalValue.length();
            }
        }
        throw new XSDException(24000, "");
    }

    public int getPrecision() throws XSDException {
        if (this.basicType != 5) {
            throw new XSDException(24000, "");
        }
        int n = this.lexicalValue.length();
        if (this.lexicalValue.indexOf(45) >= 0) {
            --n;
        }
        if (this.lexicalValue.indexOf(46) >= 0) {
            --n;
        }
        return n;
    }

    public int getScale() throws XSDException {
        if (this.basicType != 5) {
            throw new XSDException(24000, "");
        }
        int n = this.lexicalValue.length();
        int n2 = this.lexicalValue.indexOf(46);
        if (n2 >= 0) {
            return n - n2 - 1;
        }
        return 0;
    }

    public String getEncoding() {
        return "";
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    String getCanonicalValue() {
        switch (this.basicType) {
            case 0: 
            case 1: {
                return this.lexicalValue;
            }
            case 2: {
                if (this.booleanValue) {
                    return _true;
                }
                return _false;
            }
            case 3: {
                return Float.toString((float)this.doubleValue);
            }
            case 4: {
                return Double.toString(this.doubleValue);
            }
            case 5: {
                if (this.booleanValue) {
                    int n;
                    String string = this.objValue.toString();
                    int n2 = string.indexOf(46);
                    if (n2 < 0) {
                        return string;
                    }
                    for (n = string.length() - 1; n > n2 && string.charAt(n) == '0'; --n) {
                    }
                    if (n == n2) {
                        --n;
                    }
                    if (n == string.length() - 1) {
                        return string;
                    }
                    return string.substring(0, n + 1);
                }
                return Integer.toString(this.intValue);
            }
        }
        return this.lexicalValue;
    }

    public int compareVal(XSDDataValue xSDDataValue, int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.lexicalValue.equals(xSDDataValue.lexicalValue)) {
                    return 0;
                }
                if (this.lexicalValue.compareTo(xSDDataValue.lexicalValue) > 0) {
                    return 1;
                }
                return -1;
            }
            case 2: {
                if (this.booleanValue == xSDDataValue.booleanValue) {
                    return 0;
                }
                if (!this.booleanValue && xSDDataValue.booleanValue) {
                    return -1;
                }
                return 1;
            }
            case 3: 
            case 4: {
                if (this.doubleValue > xSDDataValue.doubleValue) {
                    return 1;
                }
                if (this.doubleValue < xSDDataValue.doubleValue) {
                    return -1;
                }
                if (this.doubleValue == xSDDataValue.doubleValue) {
                    return 0;
                }
                return 2;
            }
            case 5: {
                if (!this.booleanValue) {
                    if (!xSDDataValue.booleanValue) {
                        if (this.intValue == xSDDataValue.intValue) {
                            return 0;
                        }
                        if (this.intValue > xSDDataValue.intValue) {
                            return 1;
                        }
                        return -1;
                    }
                    return new BigDecimal((double)this.intValue).compareTo((BigDecimal)xSDDataValue.objValue);
                }
                if (xSDDataValue.booleanValue) {
                    return ((BigDecimal)this.objValue).compareTo(xSDDataValue.objValue);
                }
                return ((BigDecimal)this.objValue).compareTo(new BigDecimal((double)xSDDataValue.intValue));
            }
            case 6: {
                if (this.intValue > xSDDataValue.intValue) {
                    if (this.doubleValue >= xSDDataValue.doubleValue) {
                        return 1;
                    }
                    return this.compareDuration(this.intValue - xSDDataValue.intValue, xSDDataValue.doubleValue - this.doubleValue);
                }
                if (this.intValue == xSDDataValue.intValue) {
                    if (this.doubleValue > xSDDataValue.doubleValue) {
                        return 1;
                    }
                    if (this.doubleValue == xSDDataValue.doubleValue) {
                        return 0;
                    }
                    return -1;
                }
                if (this.doubleValue <= xSDDataValue.doubleValue) {
                    return -1;
                }
                return -1 * this.compareDuration(xSDDataValue.intValue - this.intValue, this.doubleValue - xSDDataValue.doubleValue);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                GregorianCalendar gregorianCalendar2 = (GregorianCalendar)xSDDataValue.objValue;
                if (this.booleanValue != xSDDataValue.booleanValue) {
                    long l = gregorianCalendar.getTimeInMillis();
                    long l2 = gregorianCalendar2.getTimeInMillis();
                    if (this.booleanValue) {
                        if (l < l2 - 50400000L) {
                            return -1;
                        }
                        if (l > l2 + 50400000L) {
                            return 1;
                        }
                        return 2;
                    }
                    if (l + 50400000L < l2) {
                        return -1;
                    }
                    if (l - 50400000L > l2) {
                        return 1;
                    }
                    return 2;
                }
                if (gregorianCalendar.after(gregorianCalendar2)) {
                    return 1;
                }
                if (gregorianCalendar2.after(gregorianCalendar)) {
                    return -1;
                }
                return 0;
            }
            case 15: 
            case 16: 
            case 17: {
                if (this.lexicalValue == xSDDataValue.lexicalValue) {
                    return 0;
                }
                return 1;
            }
            case 18: 
            case 19: {
                if (this.objValue == null || xSDDataValue.objValue == null) {
                    return 2;
                }
                if (((QName)this.objValue).equals((QName)xSDDataValue.objValue)) {
                    return 0;
                }
                return -1;
            }
        }
        return 2;
    }

    public int compareTo(XSDDataValue xSDDataValue) throws XSDException {
        if (this.basicType != xSDDataValue.basicType) {
            throw new XSDException(24000, "01");
        }
        switch (this.basicType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return this.compareVal(xSDDataValue, this.basicType);
            }
        }
        throw new XSDException(24000, "01");
    }

    private void parseTimeInstant(String string) throws XSDException {
        int n;
        int n2;
        String string2;
        GregorianCalendar gregorianCalendar;
        int n3;
        int n4;
        int n5;
        block35: {
            block38: {
                block39: {
                    block37: {
                        block36: {
                            n5 = 0;
                            n4 = string.length();
                            n3 = 0;
                            gregorianCalendar = new GregorianCalendar(1972, 0, 1, 0, 0, 0);
                            this.objValue = gregorianCalendar;
                            gregorianCalendar.setLenient(false);
                            string2 = XSDTypeConstants.sTypes[this.basicType];
                            if (this.basicType == 8) break block35;
                            if (this.basicType != 9 && this.basicType != 7 && this.basicType != 11 && this.basicType != 10) break block36;
                            n3 = string.indexOf(45);
                            if (n3 == 0) {
                                gregorianCalendar.set(0, 0);
                                n5 = 1;
                            } else {
                                gregorianCalendar.set(0, 1);
                            }
                            n3 = string.indexOf(45, n5);
                            if (n3 < 0) {
                                n3 = string.indexOf(84);
                            }
                            if (n3 < 0) {
                                n3 = string.indexOf(90);
                            }
                            if (n3 < 0) {
                                n3 = string.indexOf(43);
                            }
                            if (n3 < 0) {
                                n3 = n4;
                            }
                            if ((n2 = Integer.parseInt(string.substring(n5, n3))) == 0 || n3 - n5 < 4) {
                                throw new XSDException(24507, string, string2);
                            }
                            gregorianCalendar.set(1, n2);
                            n5 = n3 + 1;
                            if (this.basicType != 11) break block37;
                            break block35;
                        }
                        if (string.charAt(0) != '-' || string.charAt(1) != '-') {
                            throw new XSDException(24507, string, string2);
                        }
                        n5 = this.basicType != 14 ? 2 : 3;
                    }
                    if (this.basicType == 14) break block38;
                    n3 = n5 + 2;
                    n2 = Integer.parseInt(string.substring(n5, n3));
                    if (n2 <= 0 || n2 > 12) {
                        throw new XSDException(24507, string, string2);
                    }
                    gregorianCalendar.set(2, n2 - 1);
                    n5 = n3 + 1;
                    if (this.basicType != 12) break block39;
                    if (string.charAt(n5++) != '-') {
                        throw new XSDException(24507, string, string2);
                    }
                    n3 = n5;
                    break block35;
                }
                if (this.basicType == 10) break block35;
            }
            if ((n2 = Integer.parseInt(string.substring(n5, n3 = n5 + 2))) < 1 || n2 > gregorianCalendar.getActualMaximum(5)) {
                throw new XSDException(24507, string, string2);
            }
            gregorianCalendar.set(5, n2);
            n5 = n3 + 1;
        }
        if (this.basicType == 8 || this.basicType == 7) {
            char c;
            if (this.basicType != 8 && string.charAt(n3) != 'T') {
                throw new XSDException(24507, string, string2);
            }
            n3 = n5 + 2;
            n2 = Integer.parseInt(string.substring(n5, n3));
            if (n2 < 0 || n2 > 23) {
                throw new XSDException(24507, string, string2);
            }
            gregorianCalendar.set(11, n2);
            n5 = n3 + 1;
            n3 = string.indexOf(58, n5);
            n2 = Integer.parseInt(string.substring(n5, n3));
            if (n3 - n5 != 2 || n2 < 0 || n2 > 59) {
                throw new XSDException(24507, string, string2);
            }
            gregorianCalendar.set(12, n2);
            n5 = n3 + 1;
            n3 = n5 + 2;
            n2 = Integer.parseInt(string.substring(n5, n3));
            if (n3 < n4 && (c = string.charAt(n3)) != '.' && c != 'Z' && c != '+' && c != '-') {
                throw new XSDException(24507, string, string2);
            }
            n3 = string.indexOf(90, n5);
            if (n3 < 0) {
                n3 = string.indexOf(45, n5);
            }
            if (n3 < 0) {
                n3 = string.indexOf(43, n5);
            }
            if (n3 < 0) {
                n3 = n4;
            }
            BigDecimal bigDecimal = new BigDecimal(string.substring(n5, n3));
            gregorianCalendar.set(13, bigDecimal.intValue());
            n = bigDecimal.movePointRight(3).intValue();
            if (n < 0 || n > 60000) {
                throw new XSDException(24507, string, string2);
            }
            gregorianCalendar.set(14, n % 1000);
        }
        if (n3 < n4) {
            char c = string.charAt(n3);
            ++n3;
            this.booleanValue = true;
            if (c != 'Z') {
                n = 0;
                if (c == '+') {
                    n = 1;
                } else if (c != '-') {
                    throw new XSDException(24507, string, string2);
                }
                n5 = n3;
                n3 = n5 + 2;
                int n6 = Integer.parseInt(string.substring(n5, n3));
                if (string.charAt(n3) != ':') {
                    throw new XSDException(24507, string, string2);
                }
                n5 = n3 + 1;
                n3 = n5 + 2;
                int n7 = Integer.parseInt(string.substring(n5, n3));
                if (n3 < n4) {
                    throw new XSDException(24507, string, string2);
                }
                if ((double)n6 + (double)n7 / 60.0 > 14.0 || (double)n6 - (double)n7 / 60.0 < -14.0) {
                    throw new XSDException(24507, string, string2);
                }
                if (n7 < 0 || n7 > 59) {
                    throw new XSDException(24507, string, string2);
                }
                SimpleTimeZone simpleTimeZone = n != 0 ? new SimpleTimeZone(n7 * 60000, "") : new SimpleTimeZone((n7 += n6 * 60) * -60000, "");
                gregorianCalendar.setTimeZone(simpleTimeZone);
            } else {
                if (n3 < n4) {
                    throw new XSDException(24507, string, string2);
                }
                gregorianCalendar.setTimeZone(UTC);
            }
        } else {
            gregorianCalendar.setTimeZone(UTC);
        }
        gregorianCalendar.getTime();
    }

    private void parseTimeDuration(String string) throws XSDException {
        int n = 0;
        float f = 0.0f;
        int n2 = 1;
        String string2 = XSDTypeConstants.sTypes[this.basicType];
        if (string.charAt(n) == '-') {
            n2 = -1;
        }
        int n3 = ++n;
        ++n;
        if (string.charAt(n3) != 'P') {
            throw new XSDException(24507, string, string2);
        }
        int n4 = string.indexOf(89, n);
        if (n4 >= 0) {
            if (string.charAt(n) == '-') {
                throw new XSDException(24507, string, string2);
            }
            this.intValue = Integer.parseInt(string.substring(n, n4)) * 12;
            n = n4 + 1;
        }
        n4 = string.indexOf(77, n);
        int n5 = string.indexOf(84, n);
        if (n5 > 0 && n4 > n5) {
            n4 = -1;
        }
        n5 = string.length();
        if (n4 >= 0 && f == 0.0f) {
            this.intValue += Integer.parseInt(string.substring(n, n4));
            if (string.charAt(n) == '-') {
                throw new XSDException(24507, string, string2);
            }
            n = n4 + 1;
        }
        if ((n4 = string.indexOf(68, n)) >= 0 && f == 0.0f) {
            if (string.charAt(n) == '-') {
                throw new XSDException(24507, string, string2);
            }
            this.doubleValue = Integer.parseInt(string.substring(n, n4)) * 24 * 3600;
            n = n4 + 1;
        }
        if (n < n5 && string.charAt(n) == 'T' && f == 0.0f) {
            if ((n4 = string.indexOf(72, ++n)) >= 0) {
                if (string.charAt(n) == '-') {
                    throw new XSDException(24507, string, string2);
                }
                this.doubleValue += (double)(Integer.parseInt(string.substring(n, n4)) * 3600);
                n = n4 + 1;
            }
            if ((n4 = string.indexOf(77, n)) > 0) {
                if (string.charAt(n) == '-') {
                    throw new XSDException(24507, string, string2);
                }
                this.doubleValue += (double)(Integer.parseInt(string.substring(n, n4)) * 60);
                n = n4 + 1;
            }
            if ((n4 = string.indexOf(83, n)) > 0 && f == 0.0f) {
                this.doubleValue += Double.parseDouble(string.substring(n, n4));
                n = n4 + 1;
            }
        }
        if (n != n5) {
            throw new XSDException(24507, string, string2);
        }
        this.doubleValue *= (double)n2;
        this.intValue *= n2;
    }

    private int compareDuration(int n, double d) {
        int n2 = n / 12;
        int n3 = n2 * 365;
        int n4 = n2 * 366;
        if ((double)((n3 += minMonthDay[n % 12]) * 24 * 3600) > d) {
            return 1;
        }
        if ((double)((n4 += maxMonthDay[n % 12]) * 24 * 3600) < d) {
            return -1;
        }
        if (n3 == n4) {
            return 0;
        }
        return 2;
    }

    public Calendar getGregorianCalendar() {
        return (Calendar)((Calendar)this.objValue).clone();
    }

    public static void normalizeCalendar(GregorianCalendar gregorianCalendar, int n) {
        switch (n) {
            case 9: {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                break;
            }
            case 8: {
                gregorianCalendar.set(0, 0);
                gregorianCalendar.set(1, 1972);
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(5, 0);
            }
        }
    }
}

