/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.util.FastVector;

public class XSDElement
extends XSDNode
implements XSDParticleNode,
XSDTypeConstants {
    int qualified;
    XSDSimpleType simpleType;
    XSDComplexType complexType;
    int type;
    String refNamespace;
    String refLocalname;
    int refState;
    String defaultVal;
    String fixedVal;
    int minOccurs;
    int maxOccurs;
    BitSet properties;
    boolean bNillable;
    Vector equivClass;
    String equivRefNamespace;
    String equivRefLocalname;
    int equivRefState;
    Vector identities;
    String expandedName;
    FastVector ptable;
    boolean seenType;
    static int[][] pathSet = new int[1024][];

    XSDElement() {
        this.init();
    }

    XSDElement(String string, String string2) {
        super(string, string2);
        this.init();
    }

    XSDElement(int n) {
        this.init();
        this.nodeType = n;
    }

    XSDElement(XSDAttribute xSDAttribute) {
        this(4);
        this.simpleType = xSDAttribute.simpleType;
        this.complexType = null;
        this.type = 2;
        this.minOccurs = xSDAttribute.minOccurs;
        this.maxOccurs = 1;
        this.name = xSDAttribute.name;
        this.qualified = xSDAttribute.qualified;
        this.defaultVal = xSDAttribute.defaultVal;
        this.fixedVal = xSDAttribute.fixedVal;
        this.parent = xSDAttribute.parent;
        this.refLocalname = xSDAttribute.refLocalname;
        this.refNamespace = xSDAttribute.refNamespace;
        this.refState = xSDAttribute.refState;
    }

    void addIdentity(XSDIdentity xSDIdentity) {
        if (this.identities == null) {
            this.identities = new Vector(10);
        }
        this.identities.addElement(xSDIdentity);
    }

    boolean hasIdentityContraints() {
        return this.identities == null || this.identities.isEmpty();
    }

    public XSDIdentity[] getIdentities() {
        if (this.identities == null) {
            return null;
        }
        Object[] objectArray = new XSDIdentity[this.identities.size()];
        this.identities.copyInto(objectArray);
        return objectArray;
    }

    public XSDAttribute getAttributeDeclaration(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            return null;
        }
        if (this.type == 1) {
            return this.complexType.getAttrGroup().getAttributeDeclaration(string, string2);
        }
        return null;
    }

    public XSDAttribute[] getAttributeDeclarations() {
        if (this.type == 1) {
            return this.complexType.getAttributeDeclarations();
        }
        return null;
    }

    public boolean validateAttr(String string, String string2, String string3) throws XSDException {
        XSDAttribute xSDAttribute = this.getAttributeDeclaration(string, string2);
        if (xSDAttribute == null) {
            return false;
        }
        return xSDAttribute.validateValue(string3);
    }

    public XSDNode[] getChildElements() {
        if (this.type == 1) {
            FastVector fastVector = this.complexType.getGroup().elemList;
            int n = fastVector.size();
            XSDNode[] xSDNodeArray = new XSDNode[n];
            for (int i = 0; i < n; ++i) {
                xSDNodeArray[i] = (XSDNode)fastVector.elementAt(i);
            }
            return xSDNodeArray;
        }
        return null;
    }

    int getNIdentities() {
        if (this.identities == null) {
            return 0;
        }
        return this.identities.size();
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 1;
    }

    void setTypeRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 3;
    }

    void setEquivClassRef(String string, String string2) {
        this.equivRefLocalname = string2.intern();
        this.equivRefNamespace = string.intern();
        this.equivRefState = 5;
    }

    public String getEquivClassRef() {
        return this.equivRefLocalname;
    }

    int resolveEquivClass() {
        XMLSchema xMLSchema = this.getOwnerSchema();
        XSDElement xSDElement = xMLSchema.getElement(this.equivRefNamespace, this.equivRefLocalname);
        XSDNode xSDNode = this.getType();
        if (xSDElement != null) {
            this.equivRefState = 4;
            XSDNode xSDNode2 = xSDElement.getType();
            BitSet bitSet = xSDElement.getProperties();
            if (!this.seenType) {
                this.setType(xSDNode2);
                xSDNode = xSDNode2;
            } else if (!xSDNode.isSubstitutableFor(xSDNode2, bitSet.get(4), bitSet.get(3))) {
                return 24541;
            }
            if (this.isAbstract()) {
                return 0;
            }
            while (xSDElement != null) {
                if (xSDElement == this) {
                    return 24297;
                }
                bitSet = xSDElement.getProperties();
                if (!bitSet.get(0) && xSDNode.isDerivedFrom(xSDNode2 = xSDElement.getType(), bitSet)) {
                    xSDElement.addToEquivClass(this);
                }
                if (xSDElement.equivRefLocalname != null) {
                    xSDElement = xMLSchema.getElement(xSDElement.equivRefNamespace, xSDElement.equivRefLocalname);
                    continue;
                }
                xSDElement = null;
            }
        }
        return 0;
    }

    void addToEquivClass(XSDParticleNode xSDParticleNode) {
        this.equivClass.addElement(xSDParticleNode);
    }

    public int getRefState() {
        return this.refState;
    }

    public Vector getSubstitutionGroup() {
        return this.equivClass;
    }

    public XSDElement findEquivClass(String string, String string2) {
        String string3 = this.getTargetNS();
        String string4 = this.getName();
        if (string3.equals(string) && string4.equals(string2)) {
            return this;
        }
        int n = this.equivClass.size();
        for (int i = 0; i < n; ++i) {
            XSDElement xSDElement = ((XSDElement)this.equivClass.elementAt(i)).findEquivClass(string, string2);
            if (xSDElement == null) continue;
            return xSDElement;
        }
        return null;
    }

    void setForm(String string) {
        this.qualified = string.equals("qualified") ? 1 : 0;
    }

    void setNillable(boolean bl) {
        this.bNillable = bl;
    }

    public boolean isNullable() {
        return this.bNillable;
    }

    public boolean isNillable() {
        return this.bNillable;
    }

    void setAbstract(boolean bl) {
        if (bl) {
            this.properties.set(7);
        }
    }

    public boolean isAbstract() {
        return this.properties.get(7);
    }

    BitSet getProperties() {
        return this.properties;
    }

    void setDefault(String string) {
        this.defaultVal = string.intern();
    }

    public String getDefaultVal() {
        return this.defaultVal;
    }

    public String getFixedVal() {
        return this.fixedVal;
    }

    public String getName() {
        if (this.refState == 0 && this.refLocalname != null) {
            return this.refLocalname;
        }
        return this.name;
    }

    public String getRefNamespace() {
        return this.refNamespace;
    }

    public String getRefLocalname() {
        return this.refLocalname;
    }

    int getForm() {
        return this.qualified;
    }

    public String getTargetNS() {
        if (this.refState == 0 && this.refNamespace != null) {
            return this.refNamespace;
        }
        if (this.qualified == 1) {
            return this.parent.getTargetNS();
        }
        return "";
    }

    XSDNode getMatchingNode(XMLSchema xMLSchema, String string, String string2) {
        return this.findEquivClass(string, string2);
    }

    boolean isTypeAbstract() throws XSDException {
        if (this.type == 1) {
            return this.complexType.isAbstract();
        }
        if (this.type == 2) {
            return this.simpleType.isAbstract();
        }
        throw new XSDException();
    }

    void setFixed(String string) {
        this.fixedVal = string;
    }

    public int getContent() {
        if (this.type == 1) {
            return this.complexType.content;
        }
        return 11;
    }

    public boolean isElementGlobal() {
        return this.isTopLevel() || this.refLocalname != null;
    }

    public short getContentType() {
        if (this.type == 2) {
            return 5;
        }
        if (this.complexType == XSDComplexType.urType) {
            return 2;
        }
        if (this.complexType.getContent() == 10) {
            return 1;
        }
        if (this.complexType.getContent() == 12) {
            return 4;
        }
        return 3;
    }

    public XSDNode getType() {
        if (this.type == 1) {
            return this.complexType;
        }
        return this.simpleType;
    }

    void setType(XSDNode xSDNode) {
        if (xSDNode.isNodeType(1)) {
            this.setComplexType((XSDComplexType)xSDNode);
        } else {
            this.setSimpleType((XSDSimpleType)xSDNode);
        }
    }

    void setComplexType(XSDComplexType xSDComplexType) {
        this.complexType = xSDComplexType;
        this.simpleType = null;
        this.type = 1;
    }

    void setSimpleType(XSDSimpleType xSDSimpleType) {
        this.simpleType = xSDSimpleType;
        this.complexType = null;
        this.type = 2;
    }

    void resolveTypeReference(XMLSchema xMLSchema) {
        XSDNode xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 1);
        if (xSDNode == null) {
            xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 2);
        }
        if (xSDNode != null) {
            if (xSDNode.isNodeType(2)) {
                this.setSimpleType((XSDSimpleType)xSDNode);
            } else {
                this.setComplexType((XSDComplexType)xSDNode);
            }
            this.refState = 2;
        }
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDElement xSDElement = (XSDElement)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDElement != null) {
            if (xSDElement.refState == 3) {
                xSDElement.resolveTypeReference(xMLSchema);
            }
            if (xSDElement.refState == 3) {
                return;
            }
            this.setType(xSDElement.getType());
            this.name = xSDElement.name;
            this.bNillable = xSDElement.bNillable;
            this.defaultVal = xSDElement.defaultVal;
            this.fixedVal = xSDElement.fixedVal;
            this.properties = xSDElement.properties;
            if (this.identities == null) {
                this.identities = xSDElement.identities;
            }
            this.equivClass = xSDElement.equivClass;
            this.refState = 0;
            this.annotation = xSDElement.annotation;
        }
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) throws Exception {
        if (this.maxOccurs == 0) {
            return false;
        }
        if (fastVector != null) {
            byArray[fastVector.size()] = (byte)(n + 1);
            fastVector.addElement(this);
        }
        if (!this.isClean) {
            XSDGroup xSDGroup;
            this.isClean = true;
            this.domNode = null;
            XSDNode xSDNode = this.getType();
            if (xSDNode.isNodeType(1) && (xSDGroup = ((XSDComplexType)xSDNode).getGroup()) != null) {
                xSDGroup.buildPathTable(null, null, 0);
            }
        }
        return true;
    }

    int getWidth() {
        if (this.maxOccurs == 0) {
            return 0;
        }
        return 1;
    }

    void buildPaths(Hashtable hashtable, int n) {
        XSDElement.addPath(hashtable, this, n);
        if (this.equivClass != null) {
            int n2 = this.equivClass.size();
            for (int i = 0; i < n2; ++i) {
                XSDNode xSDNode = (XSDNode)this.equivClass.elementAt(i);
                if (xSDNode == this) continue;
                XSDElement.addPath(hashtable, xSDNode, n);
            }
        }
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        int n;
        if (this.equivRefState == 5 && (n = this.resolveEquivClass()) > 0) {
            throw new XSDException(n, this.name, this.domNode);
        }
        if (this.maxOccurs == 0) {
            return 0;
        }
        if (this.isClean) {
            this.targetNS = this.getTargetNS();
        }
        if (!this.isTopLevel()) {
            XSDElement xSDElement = (XSDElement)hashtable.get(this.getQName());
            if (xSDElement != null && xSDElement != this) {
                if (this.type == 1 && this.complexType != xSDElement.complexType || this.type == 2 && this.simpleType != xSDElement.simpleType) {
                    throw new XSDException(24509, this.name, this.domNode);
                }
            } else {
                hashtable.put(this.getQName(), this);
            }
        }
        if (!this.isClean) {
            return 1;
        }
        this.isClean = false;
        XSDNode xSDNode = this.getType();
        if (xSDNode.isNodeType(1)) {
            fastVector.addElement(this);
        }
        return 1;
    }

    String getExpandedName() {
        if (this.expandedName == null) {
            this.expandedName = this.getTargetNS() + ":" + this.getName();
        }
        return this.expandedName;
    }

    String getBlockString() {
        if (this.properties.get(0)) {
            if (this.properties.get(1)) {
                if (this.properties.get(2)) {
                    return "#all";
                }
                return "substitution extension";
            }
            if (this.properties.get(2)) {
                return "substitution restriction";
            }
            return "substitution";
        }
        if (this.properties.get(1)) {
            if (this.properties.get(2)) {
                return "extension restriction";
            }
            return "extension";
        }
        if (this.properties.get(2)) {
            return "restriction";
        }
        return "";
    }

    String getFinalString() {
        if (this.properties.get(3)) {
            if (this.properties.get(4)) {
                return "extension restriction";
            }
            return "extension";
        }
        if (this.properties.get(4)) {
            return "restriction";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isValidDecl() {
        String string = null;
        if (this.defaultVal != null) {
            if (this.fixedVal != null) return false;
            string = this.defaultVal;
        } else if (this.fixedVal != null) {
            string = this.fixedVal;
        }
        if (this.getContent() != 11) return this.name != null && this.name != "xmlns";
        XSDSimpleType xSDSimpleType = this.simpleType;
        if (xSDSimpleType == null) {
            xSDSimpleType = this.complexType.simpleType;
        }
        if (xSDSimpleType == null) {
            return true;
        }
        if (string == null) return this.name != null && this.name != "xmlns";
        if (xSDSimpleType.hasFlag(8)) {
            return false;
        }
        if (this.maxOccurs == 0) {
            return false;
        }
        try {
            xSDSimpleType.validateValue(string);
            return this.name != null && this.name != "xmlns";
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void init() {
        this.nodeType = 3;
        this.minOccurs = 1;
        this.maxOccurs = 1;
        this.defaultVal = null;
        this.fixedVal = null;
        this.complexType = XSDComplexType.urType;
        this.simpleType = null;
        this.qualified = 1;
        this.type = 1;
        this.refState = 2;
        this.equivRefState = 4;
        this.equivClass = new Vector(10);
        this.properties = new BitSet(8);
        this.seenType = false;
    }

    void print(int n) {
        int n2;
        boolean bl = false;
        this.printSTag(n);
        if (this.isAbstract()) {
            System.out.println(XSDElement.indent(n) + "abstract = true");
        } else {
            System.out.println(XSDElement.indent(n) + "abstract = false");
        }
        String string = this.getBlockString();
        if (!string.equals("")) {
            System.out.println(XSDElement.indent(n) + "block =" + string);
        }
        if (!(string = this.getFinalString()).equals("")) {
            System.out.println(XSDElement.indent(n) + "final = " + string);
        }
        if (this.defaultVal != null) {
            System.out.println(XSDElement.indent(n) + "default =" + this.defaultVal);
        }
        if (this.fixedVal != null) {
            System.out.println(XSDElement.indent(n) + "fixed = " + this.fixedVal);
        }
        switch (this.qualified) {
            case 0: {
                System.out.println(XSDElement.indent(n) + "form = " + "unqualified");
                break;
            }
            case 1: {
                System.out.println(XSDElement.indent(n) + "form = " + "qualified");
                break;
            }
        }
        System.out.println(XSDElement.indent(n) + "minOccurs = " + this.minOccurs);
        System.out.println(XSDElement.indent(n) + "maxOccurs = " + this.maxOccurs);
        if (this.isNillable()) {
            System.out.println(XSDElement.indent(n) + "nullable = true");
        } else {
            System.out.println(XSDElement.indent(n) + "nullable = false");
        }
        switch (this.refState) {
            case 2: 
            case 3: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(XSDElement.indent(n) + "type = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
            case 0: 
            case 1: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(XSDElement.indent(n) + "ref = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
        }
        if (this.equivRefLocalname != null) {
            System.out.print(XSDElement.indent(n) + "equivClass = " + this.equivRefNamespace);
            System.out.println(":" + this.equivRefLocalname);
        }
        int n3 = 0;
        if (this.equivClass != null) {
            n3 = this.equivClass.size();
        }
        if (n3 != 0) {
            System.out.println(XSDElement.indent(n) + "equivClassSize = " + n3);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.println(XSDElement.indent(n) + "equivClassName = " + ((XSDNode)this.equivClass.elementAt(n2)).getTargetNS() + ":" + ((XSDNode)this.equivClass.elementAt(n2)).getName());
        }
        this.printSTagEnd(n);
        switch (this.type) {
            case 1: {
                if (bl) break;
                this.complexType.print(n + 3);
                break;
            }
            case 2: {
                if (bl) break;
                this.simpleType.print(n + 3);
                break;
            }
        }
        if (this.identities != null) {
            for (n2 = 0; n2 < this.identities.size(); ++n2) {
                ((XSDIdentity)this.identities.elementAt(n2)).print(n + 3);
            }
        }
        this.printETag(n);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    static void addPath(Hashtable hashtable, XSDNode xSDNode, int n) {
        int[] nArray;
        QName qName = xSDNode.getQName();
        int[] nArray2 = (int[])hashtable.get(qName);
        if (nArray2 != null) {
            int n2 = nArray2.length;
            nArray = new int[n2 + 1];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
            nArray[n2] = n;
        } else if (n < 1024) {
            nArray = pathSet[n];
            if (nArray == null) {
                nArray = new int[]{n};
                XSDElement.pathSet[n] = nArray;
            }
        } else {
            nArray = new int[]{n};
        }
        hashtable.put(qName, nArray);
    }

    public XSDElement[] getAllowedFirstChildElements() {
        if (this.type == 1 && !this.complexType.isSimpleContent()) {
            XSDGroup xSDGroup = this.complexType.getGroup();
            return xSDGroup.getVisible();
        }
        return null;
    }

    public XSDElement[] getAllowedPreviousSiblings(String string, String string2) {
        if (this.type == 1 && !this.complexType.isSimpleContent()) {
            XSDGroup xSDGroup = this.complexType.getGroup();
            return xSDGroup.getVisible(true, string, string2);
        }
        return null;
    }

    public XSDElement[] getAllowedNextSiblings(String string, String string2) {
        if (this.type == 1 && !this.complexType.isSimpleContent()) {
            XSDGroup xSDGroup = this.complexType.getGroup();
            return xSDGroup.getVisible(false, string, string2);
        }
        return null;
    }

    public XSDElement[] getAllowedParents() {
        int n;
        XMLSchema xMLSchema = this.getOwnerSchema();
        Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().elements();
        Vector<XSDElement> vector = new Vector<XSDElement>();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
            if (xSDNodeArray == null) continue;
            for (n = 0; n < xSDNodeArray.length; ++n) {
                XSDElement xSDElement = (XSDElement)xSDNodeArray[n];
                if (!xSDElement.isParentOf(this)) continue;
                vector.addElement(xSDElement);
            }
        }
        if (vector.size() > 0) {
            n = vector.size();
            XSDElement[] xSDElementArray = new XSDElement[n];
            for (int i = 0; i < n; ++i) {
                xSDElementArray[i] = (XSDElement)vector.elementAt(i);
            }
            return xSDElementArray;
        }
        return null;
    }

    boolean isParentOf(XSDElement xSDElement) {
        XSDNode[] xSDNodeArray = this.getChildElements();
        if (xSDNodeArray == null) {
            return false;
        }
        String string = xSDElement.getTargetNS();
        String string2 = xSDElement.getName();
        for (int i = 0; i < xSDNodeArray.length; ++i) {
            XSDNode xSDNode = xSDNodeArray[i];
            if (!string.equals(xSDNode.getTargetNS()) || !string2.equals(xSDNode.getName())) continue;
            return true;
        }
        return false;
    }

    public Vector getEnumeratedValues() {
        XSDSimpleType xSDSimpleType;
        if (this.type == 1) {
            if (!this.complexType.isSimpleContent()) {
                return null;
            }
            xSDSimpleType = this.complexType.simpleType;
        } else {
            xSDSimpleType = this.simpleType;
        }
        return xSDSimpleType.getEnumeration();
    }
}

