/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDCharClass;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDRegexProgram;

class XSDRegexCompiler
implements XSDConstantValues {
    int[] brans;
    char[] program;
    XSDCharClass[] chClass;
    int patLen;
    int progLen;
    int pos;
    String pattern;
    int branch;
    int piece;
    int atom;
    int[] exprs;
    int minOccr;
    int maxOccr;
    int psize = 128;
    char[] bufAtom;
    int bufLen;
    int bsize;
    int chSize;
    static final char BRANCH = '|';
    static final char CHARS = 'A';
    static final char CHARCLASS = '[';
    static final char STARTEXPR = '(';
    static final char ENDEXPR = ')';
    static final char GOTO = 'G';
    static final char NULL = 'N';
    static final char END = 'E';
    static final char ESCAPE = '\\';
    static final char CATEGORY = 'p';
    static final char NCATEGORY = 'P';
    static final char BLOCK = 'B';
    static final char WILDCARD = '.';
    static final String REGEX_ERROR = "Invalid Regular Expression";
    static final int iUPPERCASE = 2;
    static final int iLOWERCASE = 4;
    static final int iTITLECASE = 8;
    static final int iMODIFIER = 16;
    static final int iOTHERL = 32;
    static final int iLETTERS = 62;
    static final int iNON_SPACING = 64;
    static final int iCOMBINING_SPACING = 256;
    static final int iENCLOSING = 128;
    static final int iMARKS = 448;
    static final int iDECIMAL_DIGIT = 512;
    static final int iLETTER_NUMBER = 1024;
    static final int iOTHERN = 2048;
    static final int iNUMBERS = 3584;
    static final int iCONNECTOR = 0x800000;
    static final int iDASH = 0x100000;
    static final int iSTART = 0x200000;
    static final int iEND = 0x400000;
    static final int iINITIAL_QUOTE = 0x20000000;
    static final int iFINAL_QUOTE = 0x40000000;
    static final int iOTHERP = 0x1000000;
    static final int iPUNCTUATIONS = 1643118592;
    static final int iSPACE = 4096;
    static final int iLINE = 8192;
    static final int iPARAGRAPH = 16384;
    static final int iSEPARATORS = 28672;
    static final int iMATH = 0x2000000;
    static final int iCURRENCY = 0x4000000;
    static final int iMODIFIERS = 0x8000000;
    static final int iOTHERS = 0x10000000;
    static final int iSYMBOLS = 0x16000010;
    static final int iCONTROL = 32768;
    static final int iFORMAT = 65536;
    static final int iPRIVATE_USE = 262144;
    static final int iUNASSIGNED = 1;
    static final int iOTHERC = 360449;

    XSDRegexCompiler() {
    }

    int instruction(char c, int n) {
        if (this.psize <= this.progLen + 3) {
            this.increase(this.progLen + 3);
        }
        this.program[this.progLen++] = c;
        this.program[this.progLen++] = (char)n;
        ++this.progLen;
        return this.progLen - 3;
    }

    private void error(int n, String string) throws XSDException {
        throw new XSDException(n, string);
    }

    void increase(int n) {
        char[] cArray = new char[n + this.psize];
        System.arraycopy(this.program, 0, cArray, 0, this.psize);
        this.program = cArray;
        this.psize += n;
    }

    XSDRegexProgram compile(String string) throws XSDException {
        this.pattern = string;
        this.minOccr = 0;
        this.maxOccr = 0;
        this.brans = new int[16];
        this.exprs = new int[16];
        int n = 0;
        this.patLen = this.pattern.length();
        this.program = new char[this.psize];
        this.pos = 0;
        this.progLen = 0;
        boolean bl = true;
        this.atom = -1;
        this.piece = -1;
        this.branch = this.instruction('|', 0);
        int n2 = -1;
        block18: while (this.pos < this.patLen) {
            char c = this.pattern.charAt(this.pos++);
            switch (c) {
                case '|': {
                    if (this.piece < 0 && this.atom < 0) {
                        this.error(24501, "Empty branch");
                    }
                    this.piece = -1;
                    this.atom = -1;
                    bl = true;
                    n2 = this.instruction('|', 0);
                    this.connect(this.branch, n2);
                    this.branch = n2;
                    continue block18;
                }
                case '(': {
                    if (n >= 10) {
                        this.error(24501, "Too many levels of sub-expression");
                    }
                    ++n;
                    n2 = this.instruction('(', 0);
                    if (this.atom >= 0) {
                        this.piece = this.atom;
                    }
                    this.connect(this.piece, n2);
                    this.exprs[n] = n2;
                    this.brans[n] = this.branch;
                    this.branch = this.instruction('|', n);
                    this.connect(n2, this.branch);
                    this.atom = -1;
                    this.piece = -1;
                    bl = true;
                    continue block18;
                }
                case ')': {
                    if (n == 0) {
                        this.error(24501, "unmatched bracket");
                    }
                    bl = true;
                    n2 = this.instruction(')', n);
                    this.connect(this.piece, n2);
                    this.connect(this.branch, n2);
                    this.linkBranch(this.exprs[n], n2);
                    this.atom = this.exprs[n];
                    this.piece = -1;
                    this.branch = this.brans[n];
                    --n;
                    continue block18;
                }
                case '[': {
                    if (this.atom >= 0) {
                        this.piece = this.atom;
                    }
                    this.atom = this.instruction('[', 0);
                    this.connect(this.piece, this.atom);
                    if (this.progLen + 4 > this.psize) {
                        this.increase(this.progLen + 4);
                    }
                    this.program[this.atom + 1] = '\u0001';
                    this.program[this.progLen++] = (char)this.addCharClass(this.parseCharExpr());
                    continue block18;
                }
                case ']': {
                    bl = true;
                    continue block18;
                }
                case '*': {
                    if (this.atom < 0) {
                        this.error(24501, "Quantifier without atom");
                    }
                    this.insert('|', 0, this.atom);
                    this.connect(this.atom + 3, this.instruction('|', 0));
                    this.connect(this.atom + 3, this.instruction('G', 0));
                    this.connect(this.atom + 3, this.atom);
                    this.connect(this.atom, this.instruction('|', 0));
                    this.connect(this.atom, this.instruction('N', 0));
                    bl = true;
                    this.piece = this.atom;
                    this.atom = -1;
                    continue block18;
                }
                case '+': {
                    if (this.atom < 0) {
                        this.error(24501, "Quantifier without atom");
                    }
                    int n3 = this.instruction('|', 0);
                    this.connect(this.atom, n3);
                    this.connect(this.instruction('G', 0), this.atom);
                    this.connect(n3, this.instruction('|', 0));
                    this.connect(this.atom, this.instruction('N', 0));
                    bl = true;
                    this.piece = this.atom;
                    this.atom = -1;
                    continue block18;
                }
                case '?': {
                    if (this.atom < 0) {
                        this.error(24501, "Quantifier without atom");
                    }
                    this.insert('|', 0, this.atom);
                    this.connect(this.atom, this.instruction('|', 0));
                    int n4 = this.instruction('N', 0);
                    this.connect(this.atom, n4);
                    this.connect(this.atom + 3, n4);
                    this.piece = this.atom;
                    this.atom = -1;
                    bl = true;
                    continue block18;
                }
                case '{': {
                    int n3;
                    if (this.atom < 0) {
                        this.error(24501, "Quantifier without atom");
                    }
                    this.minMaxOccr();
                    int n5 = this.maxOccr - this.minOccr;
                    this.saveAtom(this.atom);
                    int n6 = n3 = n5 == 0 ? this.minOccr - 1 : this.minOccr;
                    while (n3 > 0) {
                        n2 = this.progLen;
                        this.copyAtom();
                        this.connect(this.atom, n2);
                        this.atom = n2;
                        --n3;
                    }
                    for (n3 = n5; n3 > 0; --n3) {
                        this.insert('|', 0, this.atom);
                        this.connect(this.atom, this.instruction('|', 0));
                        n2 = this.instruction('N', 0);
                        this.connect(this.atom, n2);
                        this.connect(this.atom + 3, n2);
                        if (n3 <= 1) continue;
                        this.atom = this.progLen;
                        this.copyAtom();
                        this.connect(n2, this.atom);
                    }
                    if (this.maxOccr < 0) {
                        this.insert('|', 0, this.atom);
                        this.connect(this.atom + 3, this.instruction('|', 0));
                        this.connect(this.atom + 3, this.instruction('G', 0));
                        this.connect(this.atom + 3, this.atom);
                        this.connect(this.atom, this.instruction('|', 0));
                        this.connect(this.atom, this.instruction('N', 0));
                    }
                    bl = true;
                    this.piece = this.atom;
                    continue block18;
                }
                case '}': {
                    this.error(24501, "Unexpected character");
                    return null;
                }
                case '.': {
                    this.piece = this.atom;
                    this.atom = this.instruction('.', 0);
                    this.connect(this.piece, this.atom);
                    this.program[this.atom + 1] = 46;
                    bl = true;
                    continue block18;
                }
                case '\\': {
                    if (this.pos >= this.patLen) {
                        this.error(24501, "Unecpected pattern end");
                    }
                    char c2 = this.pattern.charAt(this.pos);
                    c = this.escape();
                    switch (c) {
                        case '\ufffd': {
                            if (this.atom >= 0) {
                                this.piece = this.atom;
                            }
                            this.atom = this.instruction('\\', 0);
                            this.connect(this.piece, this.atom);
                            XSDCharClass xSDCharClass = XSDCharClass.createEscClass(c2);
                            this.program[this.atom + 1] = (char)this.addCharClass(xSDCharClass);
                            bl = true;
                            continue block18;
                        }
                        case '\uffff': {
                            if (this.atom >= 0) {
                                this.piece = this.atom;
                            }
                            this.atom = this.instruction(c2, 0);
                            this.connect(this.piece, this.atom);
                            bl = true;
                            XSDCharClass xSDCharClass = this.category(c2 == 'P');
                            this.program[this.atom + 1] = (char)this.addCharClass(xSDCharClass);
                            if (this.pattern.charAt(this.pos) != '}') continue block18;
                            ++this.pos;
                            continue block18;
                        }
                    }
                    if (this.pos < this.patLen && this.quantifier(c2)) {
                        bl = true;
                    }
                    if (bl) {
                        if (this.atom >= 0) {
                            this.piece = this.atom;
                        }
                        this.atom = this.instruction('A', 0);
                        this.connect(this.piece, this.atom);
                        bl = false;
                    }
                    this.program[this.progLen++] = c;
                    int n7 = this.atom + 1;
                    this.program[n7] = (char)(this.program[n7] + '\u0001');
                    continue block18;
                }
            }
            if (this.pos < this.patLen && this.quantifier(this.pattern.charAt(this.pos))) {
                bl = true;
            }
            if (bl) {
                if (this.atom >= 0) {
                    this.piece = this.atom;
                }
                this.atom = this.instruction('A', 0);
                this.connect(this.piece, this.atom);
                bl = false;
            }
            if (this.psize <= this.progLen) {
                this.increase(this.psize);
            }
            this.program[this.progLen++] = c;
            int n8 = this.atom + 1;
            this.program[n8] = (char)(this.program[n8] + '\u0001');
        }
        n2 = this.instruction('E', 0);
        if (this.atom >= 0) {
            this.piece = this.atom;
        }
        this.connect(this.piece, n2);
        this.connect(this.branch, n2);
        this.linkBranch(0, n2);
        if (n == 0) {
            return new XSDRegexProgram(this.program, this.progLen, this.chClass);
        }
        this.error(24501, "Unmatched parenthesis");
        return null;
    }

    private XSDCharClass category(boolean bl) throws XSDException {
        char c;
        char c2 = this.pattern.charAt(this.pos++);
        if (this.pos >= this.patLen) {
            this.error(24501, REGEX_ERROR);
        }
        if ((c = this.pattern.charAt(this.pos)) != '}') {
            ++this.pos;
        }
        int n = 0;
        block0 : switch (c2) {
            case 'L': {
                switch (c) {
                    case '}': {
                        n = 62;
                        break block0;
                    }
                    case 'u': {
                        n = 2;
                        break block0;
                    }
                    case 'l': {
                        n = 4;
                        break block0;
                    }
                    case 't': {
                        n = 8;
                        break block0;
                    }
                    case 'm': {
                        n = 16;
                        break block0;
                    }
                    case 'o': {
                        n = 32;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'M': {
                switch (c) {
                    case '}': {
                        n = 448;
                        break block0;
                    }
                    case 'n': {
                        n = 64;
                        break block0;
                    }
                    case 'c': {
                        n = 256;
                        break block0;
                    }
                    case 'e': {
                        n = 128;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'N': {
                switch (c) {
                    case '}': {
                        n = 3584;
                        break block0;
                    }
                    case 'd': {
                        n = 512;
                        break block0;
                    }
                    case 'l': {
                        n = 1024;
                        break block0;
                    }
                    case 'o': {
                        n = 2048;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'P': {
                switch (c) {
                    case '}': {
                        n = 1643118592;
                        break block0;
                    }
                    case 'c': {
                        n = 0x800000;
                        break block0;
                    }
                    case 'd': {
                        n = 0x100000;
                        break block0;
                    }
                    case 's': {
                        n = 0x200000;
                        break block0;
                    }
                    case 'e': {
                        n = 0x400000;
                        break block0;
                    }
                    case 'i': {
                        n = 0x20000000;
                        break block0;
                    }
                    case 'f': {
                        n = 0x40000000;
                        break block0;
                    }
                    case 'o': {
                        n = 0x1000000;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'Z': {
                switch (c) {
                    case '}': {
                        n = 28672;
                        break block0;
                    }
                    case 's': {
                        n = 4096;
                        break block0;
                    }
                    case 'l': {
                        n = 8192;
                        break block0;
                    }
                    case 'p': {
                        n = 16384;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'S': {
                switch (c) {
                    case '}': {
                        n = 0x16000010;
                        break block0;
                    }
                    case 'm': {
                        n = 0x2000000;
                        break block0;
                    }
                    case 'c': {
                        n = 0x4000000;
                        break block0;
                    }
                    case 'k': {
                        n = 0x8000000;
                        break block0;
                    }
                    case 'o': {
                        n = 0x10000000;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'C': {
                switch (c) {
                    case '}': {
                        n = 360449;
                        break block0;
                    }
                    case 'c': {
                        n = 32768;
                        break block0;
                    }
                    case 'f': {
                        n = 65536;
                        break block0;
                    }
                    case 'o': {
                        n = 262144;
                        break block0;
                    }
                    case 'n': {
                        n = 1;
                        break block0;
                    }
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            case 'I': {
                if (c == 's') {
                    return this.unicodeBlock(bl);
                }
                this.error(24501, REGEX_ERROR);
                break;
            }
            default: {
                this.error(24501, REGEX_ERROR);
            }
        }
        if (this.pattern.charAt(this.pos) != '}') {
            this.error(24501, REGEX_ERROR);
        }
        return XSDCharClass.createCatClass(bl, n);
    }

    private XSDCharClass unicodeBlock(boolean bl) throws XSDException {
        int n = this.pattern.indexOf(125, this.pos);
        if (n < 0) {
            this.error(24501, REGEX_ERROR);
            return null;
        }
        XSDCharClass xSDCharClass = null;
        String string = this.pattern.substring(this.pos, n);
        this.pos = n;
        if (string.equals("BasicLatin")) {
            xSDCharClass = XSDCharClass.createRange(0, 127);
        } else if (string.equals("Latin-1Supplement")) {
            xSDCharClass = XSDCharClass.createRange(128, 255);
        } else if (string.equals("LatinExtended-A")) {
            xSDCharClass = XSDCharClass.createRange(256, 383);
        } else if (string.equals("LatinExtended-B")) {
            xSDCharClass = XSDCharClass.createRange(384, 591);
        } else if (string.equals("IPAExtensions")) {
            xSDCharClass = XSDCharClass.createRange(592, 687);
        } else if (string.equals("SpacingModifierLetters")) {
            xSDCharClass = XSDCharClass.createRange(688, 767);
        } else if (string.equals("CombiningDiacriticalMarks")) {
            xSDCharClass = XSDCharClass.createRange(768, 879);
        } else if (string.equals("Greek")) {
            xSDCharClass = XSDCharClass.createRange(880, 1023);
        } else if (string.equals("Cyrillic")) {
            xSDCharClass = XSDCharClass.createRange(1024, 1279);
        } else if (string.equals("Amenian")) {
            xSDCharClass = XSDCharClass.createRange(1328, 1423);
        } else if (string.equals("Hebrew")) {
            xSDCharClass = XSDCharClass.createRange(1424, 1535);
        } else if (string.equals("Arabic")) {
            xSDCharClass = XSDCharClass.createRange(1536, 1791);
        } else if (string.equals("Syriac")) {
            xSDCharClass = XSDCharClass.createRange(1792, 1871);
        } else if (string.equals("Thaana")) {
            xSDCharClass = XSDCharClass.createRange(1920, 1935);
        } else if (string.equals("Devanagari")) {
            xSDCharClass = XSDCharClass.createRange(2304, 2431);
        } else if (string.equals("Bengali")) {
            xSDCharClass = XSDCharClass.createRange(2432, 2559);
        } else if (string.equals("Gurmukhi")) {
            xSDCharClass = XSDCharClass.createRange(2560, 2687);
        } else if (string.equals("Gujarati")) {
            xSDCharClass = XSDCharClass.createRange(2688, 2815);
        } else if (string.equals("Oriya")) {
            xSDCharClass = XSDCharClass.createRange(2816, 2943);
        } else if (string.equals("Tamil")) {
            xSDCharClass = XSDCharClass.createRange(2944, 3071);
        } else if (string.equals("Telugu")) {
            xSDCharClass = XSDCharClass.createRange(3072, 3199);
        } else if (string.equals("Kannada")) {
            xSDCharClass = XSDCharClass.createRange(3200, 3327);
        } else if (string.equals("Malayalam")) {
            xSDCharClass = XSDCharClass.createRange(3328, 3455);
        } else if (string.equals("Sinhala")) {
            xSDCharClass = XSDCharClass.createRange(3456, 3583);
        } else if (string.equals("Thai")) {
            xSDCharClass = XSDCharClass.createRange(3584, 3711);
        } else if (string.equals("Lao")) {
            xSDCharClass = XSDCharClass.createRange(3712, 3839);
        } else if (string.equals("Tibetan")) {
            xSDCharClass = XSDCharClass.createRange(3840, 4095);
        } else if (string.equals("Myanmar")) {
            xSDCharClass = XSDCharClass.createRange(4096, 4255);
        } else if (string.equals("Georgian")) {
            xSDCharClass = XSDCharClass.createRange(4256, 4351);
        } else if (string.equals("HangulJamo")) {
            xSDCharClass = XSDCharClass.createRange(4352, 4607);
        } else if (string.equals("Ethiopic")) {
            xSDCharClass = XSDCharClass.createRange(4608, 4991);
        } else if (string.equals("Cherokee")) {
            xSDCharClass = XSDCharClass.createRange(5024, 5119);
        } else if (string.equals("UnifiedCanadianAboriginalSyllabics")) {
            xSDCharClass = XSDCharClass.createRange(5120, 5759);
        } else if (string.equals("Ogham")) {
            xSDCharClass = XSDCharClass.createRange(5760, 5791);
        } else if (string.equals("Runic")) {
            xSDCharClass = XSDCharClass.createRange(5792, 5887);
        } else if (string.equals("Khmer")) {
            xSDCharClass = XSDCharClass.createRange(6016, 6143);
        } else if (string.equals("Mongolian")) {
            xSDCharClass = XSDCharClass.createRange(6144, 6319);
        } else if (string.equals("LatinExtendedAdditional")) {
            xSDCharClass = XSDCharClass.createRange(7680, 7935);
        } else if (string.equals("GreekExtended")) {
            xSDCharClass = XSDCharClass.createRange(7936, 8191);
        } else if (string.equals("GeneralPunctuation")) {
            xSDCharClass = XSDCharClass.createRange(8192, 8303);
        } else if (string.equals("SuperscriptsandSubscripts")) {
            xSDCharClass = XSDCharClass.createRange(8304, 8351);
        } else if (string.equals("CurrencySymbols")) {
            xSDCharClass = XSDCharClass.createRange(8352, 8399);
        } else if (string.equals("CombiningMarksforSymbols")) {
            xSDCharClass = XSDCharClass.createRange(8400, 8447);
        } else if (string.equals("LetterlikeSymbols")) {
            xSDCharClass = XSDCharClass.createRange(8448, 8527);
        } else if (string.equals("NumberForms")) {
            xSDCharClass = XSDCharClass.createRange(8528, 8591);
        } else if (string.equals("Arrows")) {
            xSDCharClass = XSDCharClass.createRange(8592, 8703);
        } else if (string.equals("MathematicalOperators")) {
            xSDCharClass = XSDCharClass.createRange(8704, 8959);
        } else if (string.equals("MiscellaneousTechnical")) {
            xSDCharClass = XSDCharClass.createRange(8960, 9215);
        } else if (string.equals("ControlPictures")) {
            xSDCharClass = XSDCharClass.createRange(9216, 9279);
        } else if (string.equals("OpticalCharacterRecognition")) {
            xSDCharClass = XSDCharClass.createRange(9280, 9311);
        } else if (string.equals("EnclosedAlphanumerics")) {
            xSDCharClass = XSDCharClass.createRange(9312, 9471);
        } else if (string.equals("BoxDrowing")) {
            xSDCharClass = XSDCharClass.createRange(9472, 9599);
        } else if (string.equals("BlockElements")) {
            xSDCharClass = XSDCharClass.createRange(9600, 9631);
        } else if (string.equals("GeometricShapes")) {
            xSDCharClass = XSDCharClass.createRange(9632, 9727);
        } else if (string.equals("MiscellaneousSymbols")) {
            xSDCharClass = XSDCharClass.createRange(9728, 9983);
        } else if (string.equals("Dingbats")) {
            xSDCharClass = XSDCharClass.createRange(9984, 10175);
        } else if (string.equals("BraillePatterns")) {
            xSDCharClass = XSDCharClass.createRange(10240, 10495);
        } else if (string.equals("CJKRadicalsSupplement")) {
            xSDCharClass = XSDCharClass.createRange(11904, 12031);
        } else if (string.equals("KangxiRadicals")) {
            xSDCharClass = XSDCharClass.createRange(12032, 12255);
        } else if (string.equals("IdeographicDescriptionCharacters")) {
            xSDCharClass = XSDCharClass.createRange(12272, 12287);
        } else if (string.equals("CJKSymbolsandPunctuation")) {
            xSDCharClass = XSDCharClass.createRange(12288, 12351);
        } else if (string.equals("Hiragana")) {
            xSDCharClass = XSDCharClass.createRange(12352, 12447);
        } else if (string.equals("Katakana")) {
            xSDCharClass = XSDCharClass.createRange(12448, 12543);
        } else if (string.equals("Bopomofo")) {
            xSDCharClass = XSDCharClass.createRange(12544, 12591);
        } else if (string.equals("HanguComopatibilityJamo")) {
            xSDCharClass = XSDCharClass.createRange(12592, 12687);
        } else if (string.equals("Kanbun")) {
            xSDCharClass = XSDCharClass.createRange(12688, 12703);
        } else if (string.equals("BopomofoExtended")) {
            xSDCharClass = XSDCharClass.createRange(12704, 12735);
        } else if (string.equals("EnclosedCJKLettersandMonths")) {
            xSDCharClass = XSDCharClass.createRange(12800, 13055);
        } else if (string.equals("CJKCompatibility")) {
            xSDCharClass = XSDCharClass.createRange(13056, 13311);
        } else if (string.equals("CJKUnifiedIdeographsExtensionA")) {
            xSDCharClass = XSDCharClass.createRange(13312, 19903);
        } else if (string.equals("CJKUnifiedIdeographs")) {
            xSDCharClass = XSDCharClass.createRange(19968, 40959);
        } else if (string.equals("YiSyllables")) {
            xSDCharClass = XSDCharClass.createRange(40960, 42127);
        } else if (string.equals("YiRadicals")) {
            xSDCharClass = XSDCharClass.createRange(42128, 42191);
        } else if (string.equals("HangulSyllables")) {
            xSDCharClass = XSDCharClass.createRange(44032, 55203);
        } else if (string.equals("PrivateUse")) {
            xSDCharClass = XSDCharClass.createRange(57344, 63743);
        } else if (string.equals("CJKCompatibilityIdeographs")) {
            xSDCharClass = XSDCharClass.createRange(63744, 64255);
        } else if (string.equals("AlphabeticPresentationForms")) {
            xSDCharClass = XSDCharClass.createRange(64256, 64335);
        } else if (string.equals("ArabicPresentationForms-A")) {
            xSDCharClass = XSDCharClass.createRange(64336, 65023);
        } else if (string.equals("CombiningHalfMarks")) {
            xSDCharClass = XSDCharClass.createRange(65056, 65071);
        } else if (string.equals("CJKCompatibilityForms")) {
            xSDCharClass = XSDCharClass.createRange(65072, 65103);
        } else if (string.equals("SmallFormVariants")) {
            xSDCharClass = XSDCharClass.createRange(65104, 65135);
        } else if (string.equals("ArabicPresentationForms-B")) {
            xSDCharClass = XSDCharClass.createRange(65136, 65278);
        } else if (string.equals("Specials")) {
            xSDCharClass = XSDCharClass.createRange(65279, 65279);
            xSDCharClass.appendClass(XSDCharClass.createRange(65520, 65533));
        } else if (string.equals("HalfwidthandFullwidthForms")) {
            xSDCharClass = XSDCharClass.createRange(65280, 65533);
        } else {
            this.error(24501, REGEX_ERROR);
        }
        if (bl) {
            xSDCharClass = XSDCharClass.createNegClass(xSDCharClass);
        }
        return xSDCharClass;
    }

    boolean quantifier(char c) {
        switch (c) {
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    void insert(char c, int n, int n2) {
        if (this.psize < this.progLen + 3) {
            this.increase(this.progLen + 3);
        }
        System.arraycopy(this.program, n2, this.program, n2 + 3, this.progLen - n2);
        this.program[n2] = c;
        this.program[n2 + 1] = (char)n;
        this.program[n2 + 2] = '\u0000';
        this.progLen += 3;
    }

    void linkBranch(int n, int n2) {
        int n3 = 65535;
        int n4 = n;
        while (n3 != 0) {
            if (this.program[n4] == '|') {
                this.connect(n4 + 3, n2);
            }
            n3 = this.program[n4 + 2];
            n4 += n3;
        }
    }

    void connect(int n, int n2) {
        char c;
        if (n < 0 || n2 < 0) {
            return;
        }
        while ((c = this.program[n + 2]) != '\u0000') {
            n += c;
        }
        this.program[n + 2] = (char)(n2 - n);
    }

    void saveAtom(int n) {
        this.bufLen = this.progLen - n;
        if (this.bufAtom == null || this.bsize < this.bufLen) {
            this.bufAtom = new char[this.bufLen];
            this.bsize = this.bufLen;
        }
        System.arraycopy(this.program, n, this.bufAtom, 0, this.bufLen);
    }

    void copyAtom() {
        if (this.psize < this.progLen + this.bufLen) {
            this.increase(this.progLen + this.bufLen);
        }
        System.arraycopy(this.bufAtom, 0, this.program, this.progLen, this.bufLen);
        this.progLen += this.bufLen;
    }

    void minMaxOccr() throws XSDException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pos < this.patLen && Character.isDigit(this.pattern.charAt(this.pos))) {
            stringBuffer.append(this.pattern.charAt(this.pos++));
        }
        try {
            this.minOccr = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.error(24501, "Minimal occurance not a number");
        }
        if (this.pos < this.patLen && this.pattern.charAt(this.pos) == '}') {
            ++this.pos;
            this.maxOccr = this.minOccr;
            return;
        }
        if (this.pos >= this.patLen || this.pattern.charAt(this.pos++) != ',') {
            this.error(24501, "Expected a comma.");
        }
        if (this.pos >= this.patLen) {
            this.error(24501, "Expected a digit or }.");
        }
        if (this.pattern.charAt(this.pos) == '}') {
            ++this.pos;
            this.maxOccr = -1;
            return;
        }
        stringBuffer.setLength(0);
        while (this.pos < this.patLen && Character.isDigit(this.pattern.charAt(this.pos))) {
            stringBuffer.append(this.pattern.charAt(this.pos++));
        }
        try {
            this.maxOccr = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.error(24501, "Not a valid number.");
        }
        if (this.minOccr > this.maxOccr) {
            this.error(24501, "Bad Range of occurance.");
        }
        if (this.pos >= this.patLen || this.pattern.charAt(this.pos++) != '}') {
            this.error(24501, "Expected a closing brace.");
        }
    }

    char escape() throws XSDException {
        if (this.pos >= this.patLen) {
            this.error(24501, "Invalid character escape");
        }
        char c = this.pattern.charAt(this.pos++);
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return c;
            }
            case 'C': 
            case 'D': 
            case 'I': 
            case 'S': 
            case 'W': 
            case 'c': 
            case 'd': 
            case 'i': 
            case 's': 
            case 'w': {
                return '\ufffd';
            }
            case 'P': 
            case 'p': {
                if (this.pos >= this.patLen || this.pattern.charAt(this.pos++) != '{') {
                    this.error(24501, REGEX_ERROR);
                }
                return '\uffff';
            }
        }
        this.error(24501, REGEX_ERROR);
        return c;
    }

    private XSDCharClass parseCharRanges() throws XSDException {
        XSDCharClass xSDCharClass = null;
        XSDCharClass xSDCharClass2 = null;
        XSDCharClass xSDCharClass3 = null;
        boolean bl = false;
        char c = this.pattern.charAt(this.pos);
        if (c == '^') {
            bl = true;
            ++this.pos;
        }
        while (this.pos < this.patLen) {
            c = this.pattern.charAt(this.pos);
            switch (c) {
                case '-': 
                case '[': 
                case ']': {
                    if (bl) {
                        return XSDCharClass.createNegClass(xSDCharClass);
                    }
                    return xSDCharClass;
                }
                case '\\': {
                    ++this.pos;
                    char c2 = this.pattern.charAt(this.pos);
                    char c3 = this.escape();
                    block4 : switch (c3) {
                        case '\ufffd': {
                            switch (c2) {
                                case 'C': 
                                case 'D': 
                                case 'I': 
                                case 'S': 
                                case 'W': 
                                case 'c': 
                                case 'd': 
                                case 'i': 
                                case 's': 
                                case 'w': {
                                    xSDCharClass3 = XSDCharClass.createEscClass(c2);
                                    break block4;
                                }
                            }
                            this.error(24501, REGEX_ERROR);
                            break;
                        }
                        case '\uffff': {
                            xSDCharClass3 = this.category(c2 == 'P');
                            break;
                        }
                        default: {
                            c = c3;
                            --this.pos;
                        }
                    }
                    if (xSDCharClass3 != null) break;
                }
                default: {
                    char c3;
                    if (this.pos < this.patLen + 2 && this.pattern.charAt(this.pos + 1) == '-' && (c3 = this.pattern.charAt(this.pos + 2)) != '[') {
                        this.pos += 2;
                        if (c3 == '\\') {
                            c3 = this.escape();
                        } else {
                            ++this.pos;
                        }
                        if (c3 == '\ufffd' || c3 == '\uffff') {
                            this.error(24501, REGEX_ERROR);
                        }
                        xSDCharClass3 = XSDCharClass.createRange(c, c3);
                        break;
                    }
                    xSDCharClass3 = XSDCharClass.createRange(c, c);
                    ++this.pos;
                }
            }
            if (xSDCharClass == null) {
                xSDCharClass = xSDCharClass3;
            }
            if (xSDCharClass2 != null) {
                xSDCharClass2.appendClass(xSDCharClass3);
            }
            xSDCharClass2 = xSDCharClass3;
            xSDCharClass3 = null;
        }
        this.error(24501, REGEX_ERROR);
        return xSDCharClass;
    }

    XSDCharClass parseCharExpr() throws XSDException {
        XSDCharClass xSDCharClass = this.parseCharRanges();
        if (xSDCharClass == null) {
            this.error(24501, "empty charactor class");
            return xSDCharClass;
        }
        if (this.pos == this.patLen) {
            this.error(24501, "char class not finish");
            return xSDCharClass;
        }
        char c = this.pattern.charAt(this.pos);
        if (c == ']') {
            return xSDCharClass;
        }
        if (c == '-') {
            ++this.pos;
            if (this.pos < this.patLen && (c = this.pattern.charAt(this.pos)) == '[') {
                ++this.pos;
                XSDCharClass xSDCharClass2 = this.parseCharExpr();
                xSDCharClass = XSDCharClass.createSubtractionClass(xSDCharClass, xSDCharClass2);
                if (this.pattern.charAt(this.pos) != ']' || this.pos == this.patLen) {
                    this.error(24501, REGEX_ERROR);
                }
                ++this.pos;
            } else {
                this.error(24501, REGEX_ERROR);
            }
        } else {
            this.error(24501, REGEX_ERROR);
        }
        return xSDCharClass;
    }

    int addCharClass(XSDCharClass xSDCharClass) {
        if (this.chClass == null) {
            this.chClass = new XSDCharClass[5];
        } else if (this.chSize == this.chClass.length) {
            int n = this.chClass.length;
            XSDCharClass[] xSDCharClassArray = new XSDCharClass[n + 5];
            System.arraycopy(this.chClass, 0, xSDCharClassArray, 0, this.chSize);
            this.chClass = xSDCharClassArray;
        }
        this.chClass[this.chSize] = xSDCharClass;
        ++this.chSize;
        return this.chSize - 1;
    }
}

