/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.xml.parser.v2.PageManager;

public class FilePageManager
implements PageManager {
    static final int TABLE_DEFAULT = 100;
    RandomAccessFile file;
    String fileName;
    int currentPage;
    int lastPage;
    long currentOffset;
    long lastOffset;
    long[] pageOffset;
    int[] pageLength;
    int tableSize;
    boolean modified;

    public FilePageManager(String string, String string2) {
        if (string2.equals("new")) {
            this.create(string);
        } else {
            this.open(string, string2);
        }
        this.modified = false;
    }

    public PageManager.PageId writePage(byte[] byArray, int n, int n2) {
        int n3 = this.lastPage;
        if (this.file == null) {
            return null;
        }
        if (n2 == 0) {
            return null;
        }
        try {
            if (this.currentOffset != this.lastOffset) {
                this.file.seek(this.lastOffset);
                this.currentOffset = this.lastOffset;
                this.currentPage = this.lastPage;
            }
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.currentPage >= this.tableSize) {
            this.appendPageTable();
        }
        this.pageOffset[this.currentPage] = this.currentOffset;
        this.pageLength[this.currentPage] = n2;
        ++this.currentPage;
        this.currentOffset += (long)n2;
        this.lastPage = this.currentPage;
        this.lastOffset = this.currentOffset;
        this.modified = true;
        return new PageId(n3);
    }

    public PageManager.PageId writePage(PageManager.PageId pageId, byte[] byArray, int n, int n2) {
        PageId pageId2 = (PageId)pageId;
        int n3 = pageId2.getId();
        long l = this.pageOffset(pageId2);
        int n4 = this.pageLength(pageId2);
        if (this.file == null) {
            return null;
        }
        try {
            if (n4 != n2) {
                long l2;
                long l3 = l + (long)n4;
                long l4 = this.lastOffset;
                int n5 = 4096;
                byte[] byArray2 = new byte[n5];
                long l5 = n2 - n4;
                if (l5 > 0L) {
                    l2 = l4;
                    while (l2 > l3) {
                        if (l2 - (long)n5 < l3) {
                            n5 = (int)(l2 - l3);
                            l2 = l3;
                        } else {
                            l2 -= (long)n5;
                        }
                        this.file.seek(l2);
                        this.file.read(byArray2, 0, n5);
                        this.file.seek(l2 + l5);
                        this.file.write(byArray2, 0, n5);
                    }
                } else if (l5 < 0L) {
                    for (l2 = l3; l2 < l4; l2 += (long)n5) {
                        if (l2 + (long)n5 > l4) {
                            n5 = (int)(l4 - l2);
                        }
                        this.file.seek(l2);
                        this.file.read(byArray2, 0, n5);
                        this.file.seek(l2 + l5);
                        this.file.write(byArray2, 0, n5);
                    }
                }
                int n6 = n3 + 1;
                while (n6 < this.lastPage) {
                    int n7 = n6++;
                    this.pageOffset[n7] = this.pageOffset[n7] + l5;
                }
                this.lastOffset += l5;
            }
            if (this.currentOffset != l) {
                this.currentOffset = l;
                this.currentPage = n3;
            }
            this.file.seek(l);
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        this.pageLength[this.currentPage] = n2;
        ++this.currentPage;
        this.currentOffset += (long)n2;
        this.modified = true;
        return new PageId(n3);
    }

    public int readPage(PageManager.PageId pageId, byte[] byArray, int n) {
        int n2 = 0;
        if (this.file == null) {
            return 0;
        }
        try {
            PageId pageId2 = (PageId)pageId;
            int n3 = pageId2.getId();
            long l = this.pageOffset(pageId2);
            if (this.currentOffset != l) {
                this.currentOffset = l;
                this.currentPage = n3;
                this.file.seek(this.currentOffset);
            }
            n2 = this.file.read(byArray, n, this.pageLength(pageId2));
            this.currentOffset += (long)n2;
            ++this.currentPage;
        }
        catch (IOException iOException) {
            n2 = 0;
        }
        return n2;
    }

    public PageManager.PageId nextPageId() {
        try {
            int n = this.currentPage;
            return new PageId(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int pageLength(PageManager.PageId pageId) {
        PageId pageId2 = (PageId)pageId;
        int n = pageId2.getId();
        try {
            return this.pageLength[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public byte pageIdToBytes(PageManager.PageId pageId, byte[] byArray, int n) {
        int n2 = ((PageId)pageId).getId();
        if (n + 4 > byArray.length) {
            return -1;
        }
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 0 & 0xFF);
        return 4;
    }

    public PageManager.PageId pageIdFromBytes(byte[] byArray, int n) {
        if (n + 4 > byArray.length) {
            return null;
        }
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n++] & 0xFF;
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        return new PageId(n6);
    }

    private long pageOffset(PageManager.PageId pageId) {
        PageId pageId2 = (PageId)pageId;
        int n = pageId2.getId();
        try {
            return this.pageOffset[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
    }

    public void close() {
        if (this.file == null) {
            return;
        }
        try {
            if (this.modified && this.lastPage > 0) {
                this.file.seek(this.lastOffset);
                for (int i = 0; i < this.lastPage; ++i) {
                    this.file.writeLong(this.pageOffset[i]);
                    this.file.writeInt(this.pageLength[i]);
                }
                this.file.seek(0L);
                this.file.writeLong(this.lastOffset);
                this.file.writeInt(this.lastPage);
            }
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void open(String string, String string2) {
        try {
            this.fileName = string;
            this.file = new RandomAccessFile(this.fileName, "rw");
            this.lastOffset = this.file.readLong();
            this.lastPage = this.file.readInt();
            this.currentOffset = this.file.getFilePointer();
            this.currentPage = 0;
            this.pageOffset = new long[this.lastPage];
            this.pageLength = new int[this.lastPage];
            this.tableSize = this.lastPage;
            this.file.seek(this.lastOffset);
            for (int i = 0; i < this.lastPage; ++i) {
                this.pageOffset[i] = this.file.readLong();
                this.pageLength[i] = this.file.readInt();
            }
            this.file.seek(this.currentOffset);
        }
        catch (IOException iOException) {
            this.init();
            return;
        }
    }

    private void create(String string) {
        try {
            this.fileName = string;
            this.file = new RandomAccessFile(this.fileName, "rw");
            this.file.writeLong(0L);
            this.file.writeInt(0);
            this.currentOffset = this.file.getFilePointer();
            this.currentPage = 0;
            this.tableSize = 100;
            this.pageOffset = new long[this.tableSize];
            this.pageLength = new int[this.tableSize];
            this.lastPage = this.currentPage;
            this.lastOffset = this.currentOffset;
        }
        catch (IOException iOException) {
            this.init();
            return;
        }
    }

    private void appendPageTable() {
        long[] lArray = this.pageOffset;
        this.pageOffset = new long[this.tableSize + 100];
        System.arraycopy(lArray, 0, this.pageOffset, 0, this.tableSize);
        int[] nArray = this.pageLength;
        this.pageLength = new int[this.tableSize + 100];
        System.arraycopy(nArray, 0, this.pageLength, 0, this.tableSize);
        this.tableSize += 100;
    }

    private void init() {
        this.fileName = null;
        this.currentPage = 0;
        this.currentOffset = 0L;
        this.file = null;
        this.tableSize = 0;
    }

    class PageId
    implements PageManager.PageId {
        int id;

        PageId(int n) {
            this.id = n;
        }

        int getId() {
            return this.id;
        }

        public String toString() {
            return "ID" + this.id;
        }

        public int compareTo(Object object) {
            PageId pageId = (PageId)object;
            return this.id - pageId.id;
        }

        public boolean equals(Object object) {
            if (object instanceof PageId) {
                return ((PageId)object).id == this.id;
            }
            return false;
        }
    }
}

