/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.ls.LSSerializerFilter;

public class XMLPrintDriver
implements PrintDriver {
    protected XMLOutputStream out;
    private Vector prefixVector;
    private Vector nsVector;
    private int prevSize;
    private int prefixCount;
    private Hashtable nsDeclToPrint;
    private boolean formatPrettyPrint = false;
    private boolean xmlDeclaration = true;
    private LSSerializerFilter filter = null;
    static int NSDECL_FOUND = 1;
    static int NSDECL_MISMATCH = 0;
    static int NSDECL_NOTFOUND = -1;
    static final String FORMAT_PRETTY_PRINT = "format-pretty-print";
    static final String XML_DECLARATION = "xml-declaration";

    XMLPrintDriver(XMLOutputStream xMLOutputStream) {
        this.out = xMLOutputStream;
        this.prefixVector = new Vector(10);
        this.nsVector = new Vector(10);
        this.nsDeclToPrint = new Hashtable(20);
    }

    public XMLPrintDriver(Writer writer) {
        this.out = new XMLOutputStream(writer);
        this.prefixVector = new Vector(10);
        this.nsVector = new Vector(10);
        this.nsDeclToPrint = new Hashtable(20);
    }

    public XMLPrintDriver(PrintWriter printWriter) {
        this.out = new XMLOutputStream(printWriter);
        this.prefixVector = new Vector(10);
        this.nsVector = new Vector(10);
        this.nsDeclToPrint = new Hashtable(20);
    }

    public XMLPrintDriver(OutputStream outputStream) {
        this.out = new XMLOutputStream(outputStream);
        this.prefixVector = new Vector(10);
        this.nsVector = new Vector(10);
        this.nsDeclToPrint = new Hashtable(20);
    }

    public void setEncoding(String string) throws IOException {
        this.out.setEncoding(string, true, true);
    }

    public void setEOLChars(String string) {
        this.out.setEOLChars(string);
    }

    public void setFormatPrettyPrint(boolean bl) {
        if (bl) {
            this.out.setOutputStyle(1);
        } else {
            this.out.setOutputStyle(0);
        }
    }

    public void setConfig(DOMConfiguration dOMConfiguration) throws IOException {
        this.formatPrettyPrint = (Boolean)dOMConfiguration.getParameter(FORMAT_PRETTY_PRINT);
        this.xmlDeclaration = (Boolean)dOMConfiguration.getParameter(XML_DECLARATION);
        if (this.formatPrettyPrint) {
            this.out.setOutputStyle(1);
        } else {
            this.out.setOutputStyle(0);
        }
    }

    void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.filter = lSSerializerFilter;
    }

    public void printDoctype(DTD dTD) throws IOException {
        dTD.print(this.out, false);
    }

    public void printDocument(XMLDocument xMLDocument) throws IOException {
        this.setEncoding(xMLDocument.getEncoding());
        this.printXMLDecl(xMLDocument);
        this.printChildNodes(xMLDocument);
    }

    public void printElement(XMLElement xMLElement) throws IOException {
        boolean bl = true;
        boolean bl2 = this.out.mixed;
        int n = this.out.getOutputStyle();
        int n2 = this.nsVector.size();
        int n3 = this.prefixCount;
        this.prevSize = n2;
        this.nsDeclToPrint.clear();
        this.out.writeIndent();
        this.out.writeChars("<");
        this.out.writeChars(xMLElement.getNodeName());
        this.normalizeNS(xMLElement, true);
        if (xMLElement.hasAttributes()) {
            this.printAttributeNodes(xMLElement);
        }
        this.printNsDecls(xMLElement);
        if (xMLElement.hasChildNodes()) {
            this.out.writeChars(">");
            bl = false;
            if (xMLElement.isNodeFlag(65536)) {
                this.out.mixed = true;
            } else if (!xMLElement.isNodeFlag(131072)) {
                for (XMLNode xMLNode = (XMLNode)xMLElement.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                    short s = xMLNode.getNodeType();
                    if (s != 3 && s != 5) continue;
                    this.out.mixed = true;
                    break;
                }
            }
            this.out.writeNewLine();
            this.out.addIndent(1);
            this.printChildNodes(xMLElement);
            this.out.addIndent(-1);
            this.out.writeIndent();
            this.out.mixed = bl2;
        }
        this.printEndTag(xMLElement, bl);
        this.out.writeNewLine();
        this.out.setOutputStyle(n);
        this.out.flush();
        this.prefixCount = n3;
        this.nsVector.setSize(n2);
        this.prefixVector.setSize(n2);
    }

    void printEndTag(XMLElement xMLElement, boolean bl) throws IOException {
        if (bl) {
            this.out.writeChars("/>");
        } else {
            this.out.writeChars("</" + xMLElement.getNodeName() + ">");
        }
    }

    public void printDocumentFragment(XMLDocumentFragment xMLDocumentFragment) throws IOException {
        this.printChildNodes(xMLDocumentFragment);
    }

    public void printTextNode(XMLText xMLText) throws IOException {
        xMLText.print(this.out, false);
    }

    public void printComment(XMLComment xMLComment) throws IOException {
        xMLComment.print(this.out, false);
    }

    public void printCDATASection(XMLCDATA xMLCDATA) throws IOException {
        xMLCDATA.print(this.out, false);
    }

    public void printProcessingInstruction(XMLPI xMLPI) throws IOException {
        xMLPI.print(this.out, false);
    }

    public void printAttribute(XMLAttr xMLAttr) throws IOException {
        xMLAttr.print(this.out, false);
    }

    public void printEntityReference(XMLEntityReference xMLEntityReference) throws IOException {
        xMLEntityReference.print(this.out, false);
    }

    public final void printChildNodes(XMLNode xMLNode) throws IOException {
        block10: for (XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild(); xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
            switch (xMLNode2.getNodeType()) {
                case 10: {
                    if (!this.xmlDeclaration) continue block10;
                    this.printDoctype((DTD)xMLNode2);
                    continue block10;
                }
                case 1: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printElement((XMLElement)xMLNode2);
                    continue block10;
                }
                case 11: {
                    this.printDocumentFragment((XMLDocumentFragment)xMLNode2);
                    continue block10;
                }
                case 3: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printTextNode((XMLText)xMLNode2);
                    continue block10;
                }
                case 8: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printComment((XMLComment)xMLNode2);
                    continue block10;
                }
                case 4: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printCDATASection((XMLCDATA)xMLNode2);
                    continue block10;
                }
                case 7: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1 || !this.xmlDeclaration) continue block10;
                    this.printProcessingInstruction((XMLPI)xMLNode2);
                    continue block10;
                }
                case 5: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printEntityReference((XMLEntityReference)xMLNode2);
                    continue block10;
                }
            }
        }
    }

    private boolean callPrinterFilter(XMLNode xMLNode) {
        if (this.filter == null) {
            return true;
        }
        return (1 << xMLNode.getNodeType() - 1 & this.filter.getWhatToShow()) != 0;
    }

    public final void printAttributeNodes(XMLElement xMLElement) throws IOException {
        XMLAttrList xMLAttrList = (XMLAttrList)xMLElement.getAttributes();
        int n = xMLAttrList.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)xMLAttrList.item(i);
            if (!xMLAttr.isNodeFlag(262144)) {
                if (xMLAttr.isNodeFlag(65536)) {
                    this.normalizeNS(xMLAttr, false);
                }
            } else {
                String string = xMLAttr.getNodePrefix();
                String string2 = xMLAttr.getLocalName();
                if ("xmlns".equals(string)) {
                    this.addNsDeclPrinted(string2, xMLAttr.getNodeValue());
                } else if ("xmlns".equals(string2)) {
                    this.addNsDeclPrinted("", xMLAttr.getNodeValue());
                }
            }
            this.printAttribute(xMLAttr);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void printXMLDecl(XMLDocument xMLDocument) throws IOException {
        if (xMLDocument.version != null) {
            XMLDeclPI.printXMLDecl(this.out, xMLDocument.version, xMLDocument.encoding, xMLDocument.standalone);
        }
    }

    private void normalizeNS(XMLNSNode xMLNSNode, boolean bl) throws IOException {
        String string = xMLNSNode.getNodePrefix();
        String string2 = xMLNSNode.getNamespace();
        if ("xml".equals(string)) {
            return;
        }
        if (string != null && !string.equals("")) {
            if (this.checkNsDecl(string, string2) != NSDECL_FOUND) {
                this.nsDeclToPrint.put(string, string2);
            }
        } else if (bl) {
            int n = this.checkNsDecl(string, string2);
            if (n == NSDECL_MISMATCH || !string2.equals("") && n != NSDECL_FOUND) {
                this.nsDeclToPrint.put(string, string2);
            }
        } else if (string2 != "") {
            String string3 = this.resolvePrefix((XMLAttr)xMLNSNode, string2);
            xMLNSNode.setPrefix(string3);
        }
    }

    private void addNsDeclPrinted(String string, String string2) {
        this.prefixVector.addElement(string);
        this.nsVector.addElement(string2);
    }

    private int checkNsDecl(String string, String string2) throws IOException {
        int n;
        int n2 = this.prefixVector.size();
        int n3 = NSDECL_NOTFOUND;
        for (n = n2 - 1; n >= 0; --n) {
            if (!string.equals(this.prefixVector.elementAt(n))) continue;
            if (string2.equals(this.nsVector.elementAt(n))) {
                this.addNsDeclPrinted(string, string2);
                n3 = NSDECL_FOUND;
                break;
            }
            n3 = NSDECL_MISMATCH;
            break;
        }
        String string3 = (String)this.nsDeclToPrint.get(string);
        if (n3 == NSDECL_MISMATCH && n >= this.prevSize || string3 != null && !string3.equals(string2)) {
            if (string3 == null) {
                string3 = (String)this.nsVector.elementAt(n);
            }
            String string4 = XMLDocument.defErr.getMessage3(21018, string3, string2, string);
            throw new IOException(string4);
        }
        return n3;
    }

    private String resolvePrefix(XMLAttr xMLAttr, String string) {
        String string2;
        int n = this.nsVector.size();
        for (int i = n - 1; i >= 0; --i) {
            if (!string.equals(this.nsVector.elementAt(i)) || (string2 = (String)this.prefixVector.elementAt(i)) == "") continue;
            return string2;
        }
        Enumeration enumeration = this.nsDeclToPrint.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.equals(this.nsDeclToPrint.get(string2))) continue;
            return string2;
        }
        XMLElement xMLElement = (XMLElement)xMLAttr.getOwnerElement();
        string2 = xMLElement.getNamespacePrefix(string);
        if ("#default".equals(string2) || string2 == null) {
            string2 = "ns" + this.prefixCount++;
        }
        this.nsDeclToPrint.put(string2, string);
        return string2;
    }

    private void printNsDecls(XMLElement xMLElement) throws IOException {
        Enumeration enumeration = this.nsDeclToPrint.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            int n = this.checkNsDecl(string2, string = (String)this.nsDeclToPrint.get(string2));
            if (n == NSDECL_FOUND) continue;
            XMLAttr xMLAttr = null;
            XMLDocument xMLDocument = (XMLDocument)xMLElement.getOwnerDocument();
            if (string2 == null || string2.equals("")) {
                if (string != "" || n == NSDECL_MISMATCH) {
                    xMLAttr = (XMLAttr)xMLDocument.createAttribute("http://www.w3.org/2000/xmlns/", "xmlns", string);
                }
            } else if (!"xmlns".equals(string2)) {
                xMLAttr = (XMLAttr)xMLDocument.createAttribute("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string);
            }
            if (xMLAttr == null) continue;
            this.addNsDeclPrinted(string2, string);
            xMLAttr.setNodeFlag(65536);
            this.printAttribute(xMLAttr);
        }
    }
}

