/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSAXSerializer
extends DefaultHandler
implements XMLConstants,
LexicalHandler {
    public static final String ENCODING = "oracle.xml.parser.v2.XMLSAXSerializer.encoding";
    public static final String INDENT = "oracle.xml.parser.v2.XMLSAXSerializer.indent";
    public static final String OMIT_XML_DECL = "oracle.xml.parser.v2.XMLSAXSerializer.omit-xml-decl";
    boolean elemEmpty = true;
    boolean textPrinted = false;
    boolean firstElement = true;
    boolean printXMLDecl = false;
    boolean inCDATA = false;
    int entityDepth = 0;
    String encoding = null;
    XMLOutputStream out;

    public XMLSAXSerializer(PrintWriter printWriter) {
        this.out = new XMLOutputStream(printWriter);
    }

    public XMLSAXSerializer(OutputStream outputStream) {
        this.out = new XMLOutputStream(outputStream);
    }

    public void setProperty(String string, Object object) {
        if (ENCODING.equals(string)) {
            try {
                this.out.setEncoding((String)object, true, true);
                this.encoding = (String)object;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else if (INDENT.equals(string)) {
            if (Boolean.TRUE.equals(object)) {
                this.out.setOutputStyle(1);
            } else {
                this.out.setOutputStyle(2);
            }
        } else if (OMIT_XML_DECL.equals(string)) {
            this.printXMLDecl = !Boolean.TRUE.equals(object);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    public void startDocument() throws SAXException {
        try {
            if (this.printXMLDecl) {
                this.out.writeChars("<?xml version = '1.0'");
                if (this.encoding != null) {
                    this.out.writeChars(" encoding = '" + this.encoding + "'");
                }
                this.out.writeChars("?>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = true;
            this.textPrinted = false;
            this.out.writeChars("<");
            this.out.writeChars(string3);
            this.printAttributes(string2, attributes);
            this.out.writeChars(">");
            this.out.addIndent(1);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.out.addIndent(-1);
            if (this.elemEmpty) {
                this.out.pop(1);
                this.out.writeChars("/>");
            } else {
                if (!this.textPrinted) {
                    this.out.writeNewLine();
                    this.out.writeIndent();
                }
                this.out.writeChars("</" + string3 + ">");
            }
            this.elemEmpty = false;
            this.textPrinted = false;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<?");
            this.out.writeChars(string + " " + string2);
            this.out.writeChars("?>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        this.elemEmpty = false;
        this.textPrinted = true;
        try {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                if (!this.inCDATA && cArray[i] == '&') {
                    this.out.writeChars("&amp;");
                    continue;
                }
                if (!this.inCDATA && cArray[i] == '<') {
                    this.out.writeChars("&lt;");
                    continue;
                }
                this.out.write(cArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        try {
            this.out.writeChars("<!DOCTYPE ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        if (this.entityDepth == 0) {
            try {
                this.out.writeChars("&" + string + ";");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage());
            }
        }
        ++this.entityDepth;
    }

    public void endEntity(String string) throws SAXException {
        --this.entityDepth;
    }

    public void startCDATA() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.inCDATA = true;
            this.out.writeChars("<![CDATA[");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endCDATA() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.inCDATA = false;
            this.out.writeChars("]]>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<!--");
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.out.write(cArray[i]);
            }
            this.out.writeChars("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    private void printAttributes(String string, Attributes attributes) throws SAXException, IOException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.out.writeChars(" ");
            this.out.writeChars(attributes.getQName(i));
            String string2 = attributes.getValue(i);
            this.out.writeChars("=");
            this.out.write(34);
            int n2 = string2.length();
            char[] cArray = new char[n2];
            string2.getChars(0, n2, cArray, 0);
            for (int j = 0; j < n2; ++j) {
                if (cArray[j] == '&') {
                    this.out.writeChars("&amp;");
                    continue;
                }
                if (cArray[j] == '<') {
                    this.out.writeChars("&lt;");
                    continue;
                }
                if (cArray[j] == '\"') {
                    this.out.writeChars("&quot;");
                    continue;
                }
                this.out.write(cArray[j]);
            }
            this.out.write(34);
        }
    }
}

