/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.AdditiveExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class RangeExpr
extends XSLExprBase {
    RangeExpr() {
        super.setExprType(34603064);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = AdditiveExpr.parse(xSLParseString);
        if (xSLParseString.peekToken(106)) {
            RangeExpr rangeExpr = new RangeExpr();
            rangeExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            rangeExpr.leftExpr = xSLExprBase;
            rangeExpr.rightExpr = AdditiveExpr.parse(xSLParseString);
            if (xSLParseString.isCachingExpr() && !((XSLExprBase)rangeExpr).canCacheExpr()) {
                ((XSLExprBase)rangeExpr).cacheSubExpr();
            }
            xSLExprBase = rangeExpr;
        }
        return xSLExprBase;
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(106);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN() || this.rightExpr.checkPosLastFN();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        int n;
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        double d = this.leftExpr.getNumberValue(xSLTContext);
        double d2 = this.rightExpr.getNumberValue(xSLTContext);
        int n2 = new Double(d).intValue();
        int n3 = new Double(d2).intValue();
        if ((double)n2 != d && !Double.isNaN(d)) {
            throw new XPathException(1055, new Double(d).toString());
        }
        if ((double)n3 != d2) {
            throw new XPathException(1055, new Double(d2).toString());
        }
        OXMLSequence oXMLSequence = xSLTContext.pushExprValue();
        int n4 = n = n2 > n3 ? -1 : 1;
        if (n == 1) {
            for (int i = n2; i <= n3; ++i) {
                XPathItem xPathItem = xSLTContext.allocItem();
                xPathItem.setInt(OXMLSequenceType.TINTEGER, i);
                oXMLSequence.appendItem(xPathItem);
            }
        } else {
            for (int i = n2; i >= n3; --i) {
                XPathItem xPathItem = xSLTContext.allocItem();
                xPathItem.setInt(OXMLSequenceType.TINTEGER, i);
                oXMLSequence.appendItem(xPathItem);
            }
        }
    }
}

