/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.CastableAsExpr;
import oracle.xml.xpath.ComparisonExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSeqType;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class TreatExpr
extends XSLExprBase {
    private XPathSeqType seqType;

    TreatExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = XSLExpr.isXPath20Compatible(xSLParseString) ? CastableAsExpr.parse(xSLParseString) : ComparisonExpr.parse(xSLParseString);
        if (xSLParseString.peekToken(23)) {
            TreatExpr treatExpr = new TreatExpr();
            treatExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            treatExpr.leftExpr = xSLExprBase;
            treatExpr.seqType = XPathSeqType.parse(xSLParseString);
            return treatExpr;
        }
        return xSLExprBase;
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(23);
        stringBuffer.append(this.seqType.getNormalizedExpr());
        stringBuffer.append(this.leftExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xSLTContext);
        OXMLSequence oXMLSequence = xSLTContext.peekExprValue();
        OXMLSequenceType oXMLSequenceType = this.seqType.getSequenceType();
        if (!oXMLSequence.isOfType(oXMLSequenceType)) {
            throw new XPathException(1036, XPathSequence.getTypeString(oXMLSequence), this.seqType.getAtomicType().getName());
        }
    }
}

