/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

class XPathStep
extends XSLExprBase {
    int nodeTestType;
    int nodeType;
    String name;
    String nameSpace;
    XPathAxis axisClass = null;
    int prevSeparator;
    boolean found = true;
    boolean anyNode = false;
    boolean isPattern;
    boolean lazyLoad;
    boolean firstNodeOnly;

    XPathStep(XSLParseString xSLParseString, int n) throws XSLException, XQException {
        this.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        this.isPattern = xSLParseString.isPattern();
        this.prevSeparator = n;
        super.setExprType(0x2200000);
        this.nodeType = 1;
        int n2 = xSLParseString.peekToken();
        if (!(this.isPattern || n2 != 3 && n2 != 4)) {
            xSLParseString.nextToken();
            this.nodeTestType = 403;
            this.anyNode = true;
            this.axisClass = n2 == 3 ? XPathAxis.getInstance(11) : XPathAxis.getInstance(8);
            this.setNodeType();
            return;
        }
        if (n2 == 111 && xSLParseString.getAxisType() == 503) {
            xSLParseString.nextToken();
            if (xSLParseString.nextToken() != 110) {
                return;
            }
            this.axisClass = XPathAxis.getInstance(2);
            this.nodeType = 2;
            this.name = xSLParseString.getLocalName();
            this.nameSpace = xSLParseString.getNamespace();
            this.nodeTestType = xSLParseString.getNodeTestKind();
            this.priority = this.nodeTestType == 451 ? 0.0f : (this.nodeTestType == 450 ? -0.5f : -0.25f);
        } else if (n2 == 111 || n2 == 110) {
            xSLParseString.nextToken();
            if (this.tryAxis(xSLParseString.getAxisType())) {
                XSLStylesheet xSLStylesheet;
                int n3 = this.axisClass.getAxisType();
                if ((n3 == 9 || n3 == 10) && (xSLStylesheet = xSLParseString.getStylesheet()) != null) {
                    xSLStylesheet.setPrecedingAxis(true);
                }
                if (this.isPattern && this.axisClass.getAxisType() != 3) {
                    throw new XPathException(1013, new String(xSLParseString.getExprString()));
                }
                xSLParseString.nextToken();
            } else {
                this.axisClass = XPathAxis.getInstance(3);
            }
            this.nodeTestType = xSLParseString.getNodeTestKind();
            switch (this.nodeTestType) {
                case 400: {
                    this.nodeType = 7;
                    n2 = xSLParseString.nextToken();
                    if (n2 == 109) {
                        this.name = xSLParseString.getLiteralValue();
                        this.priority = 0.0f;
                        n2 = xSLParseString.nextToken();
                    } else {
                        this.priority = -0.5f;
                        this.name = "*";
                    }
                    if (n2 == 26) break;
                    throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                }
                case 402: {
                    this.nodeType = 3;
                    this.priority = -0.5f;
                    if (xSLParseString.nextToken() == 26) break;
                    throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                }
                case 401: {
                    this.nodeType = 8;
                    this.priority = -0.5f;
                    if (xSLParseString.nextToken() == 26) break;
                    throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                }
                case 403: {
                    this.priority = -0.5f;
                    if (xSLParseString.nextToken() != 26) {
                        throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                    }
                    this.anyNode = true;
                    break;
                }
                case 451: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = 0.0f;
                    break;
                }
                case 450: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = -0.5f;
                    break;
                }
                case 453: {
                    this.name = xSLParseString.getLocalName();
                    this.nameSpace = xSLParseString.getNamespace();
                    this.priority = -0.25f;
                }
            }
        } else {
            this.found = false;
            return;
        }
        if (xSLParseString.peekToken() == 27) {
            this.predicates = new XPathPredicate(xSLParseString);
            this.priority = 0.5f;
        }
        this.setNodeType();
    }

    public int getAnchorType() {
        if (!this.anyNode) {
            return this.nodeType;
        }
        return -1;
    }

    public void getAnchorName(String[] stringArray) {
        if (this.nodeTestType == 451) {
            stringArray[0] = this.nameSpace.intern();
            stringArray[1] = this.name.intern();
        }
    }

    private boolean tryAxis(int n) throws XSLException {
        switch (n) {
            case 508: {
                this.axisClass = XPathAxis.getInstance(0);
                break;
            }
            case 513: {
                this.axisClass = XPathAxis.getInstance(1);
                break;
            }
            case 503: {
                this.axisClass = XPathAxis.getInstance(2);
                this.nodeType = 2;
                break;
            }
            case 501: {
                this.axisClass = XPathAxis.getInstance(3);
                break;
            }
            case 502: {
                this.axisClass = XPathAxis.getInstance(4);
                break;
            }
            case 510: {
                this.axisClass = XPathAxis.getInstance(5);
                break;
            }
            case 505: {
                this.axisClass = XPathAxis.getInstance(6);
                break;
            }
            case 511: {
                this.axisClass = XPathAxis.getInstance(7);
                break;
            }
            case 507: {
                this.axisClass = XPathAxis.getInstance(8);
                break;
            }
            case 509: {
                this.axisClass = XPathAxis.getInstance(9);
                break;
            }
            case 512: {
                this.axisClass = XPathAxis.getInstance(10);
                break;
            }
            case 504: {
                this.axisClass = XPathAxis.getInstance(11);
                break;
            }
            case 506: {
                this.axisClass = XPathAxis.getInstance(12);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setNodeType() throws XSLException, XQException {
        if (!this.found || this.axisClass == null) {
            return;
        }
        this.nameSpace = this.nameSpace == null || this.nameSpace.equals("*") ? null : this.nameSpace.intern();
        String string = this.name = this.name == null || this.name.equals("*") ? null : this.name.intern();
        if (this.predicates != null) {
            if (this.prevSeparator == 6 || this.isPattern) {
                this.predicates.isSimpleContext();
            }
            this.predicates.getPositionTest();
        }
    }

    public void setEvaluationHints(String string, Object object) {
        if (this.predicates == null && Boolean.TRUE.equals(object)) {
            if ("value-of".equals(string)) {
                this.firstNodeOnly = true;
            } else if ("for-each".equals(string) && this.nodeTestType == 451) {
                this.lazyLoad = true;
            }
        }
    }

    void cacheSubExpr() {
    }

    boolean canCacheExpr() {
        return true;
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.prevSeparator == 5) {
            stringBuffer.append("/");
        } else {
            stringBuffer.append("//");
        }
        stringBuffer.append(this.axisClass.axisType);
        stringBuffer.append(this.nodeTestType);
        stringBuffer.append(this.nameSpace);
        stringBuffer.append(":");
        stringBuffer.append(this.name);
        if (this.predicates != null) {
            stringBuffer.append(this.predicates.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return false;
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        if (this.prevSeparator == 6) {
            if ((this.predicates == null || this.predicates.isSimpleContext()) && this.axisClass.getAxisType() == 3) {
                XPathAxis xPathAxis = XPathAxis.getInstance(4);
                xPathAxis.getNodeList(this, xSLTContext);
            } else {
                XPathAxis.getDescNodeList(this, xSLTContext);
            }
        } else {
            this.axisClass.getNodeList(this, xSLTContext);
        }
    }

    XMLNode matchPattern(XSLTContext xSLTContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XSLException, XQException {
        OXMLSequence oXMLSequence3 = xSLTContext.pushExprValue();
        while (oXMLSequence.next()) {
            XMLNode xMLNode = XPathSequence.nextNode(oXMLSequence);
            if (!this.anyNode && !xMLNode.checkTypeNSName(this.nodeType, this.nameSpace, this.name)) continue;
            XPathSequence.addNode(oXMLSequence3, xMLNode);
        }
        if (this.predicates != null) {
            if (this.predicates.isSimpleContext()) {
                this.predicates.filter(oXMLSequence3, xSLTContext);
            } else {
                OXMLSequence oXMLSequence4 = xSLTContext.pushExprValue();
                XPathSequence.getParentList(oXMLSequence3, oXMLSequence4);
                this.axisClass.getNodeList(this, xSLTContext);
                XPathSequence.intersectSequence(oXMLSequence3, oXMLSequence4);
                xSLTContext.popExprValue();
            }
        }
        if (oXMLSequence3.getItemOccurrence() != 0) {
            if (this.prevSeparator == 5) {
                XPathSequence.getParentList(oXMLSequence3, oXMLSequence2);
            } else {
                XPathAxis.getAncestor(oXMLSequence3, oXMLSequence2, xSLTContext);
            }
        }
        xSLTContext.popExprValue();
        if (oXMLSequence2.getItemOccurrence() == 1) {
            oXMLSequence2.next();
            return XPathSequence.nextNode(oXMLSequence2);
        }
        return null;
    }

    XMLNode matchPattern(XSLTContext xSLTContext, XMLNode xMLNode, OXMLSequence oXMLSequence) throws XSLException, XQException {
        if (!this.anyNode && !xMLNode.checkTypeNSName(this.nodeType, this.nameSpace, this.name)) {
            return null;
        }
        XMLNode xMLNode2 = xMLNode.getNodeType() == 2 ? (XMLNode)((Object)((XMLAttr)xMLNode).getOwnerElement()) : (XMLNode)xMLNode.getParentNode();
        if (this.predicates != null) {
            if (!this.predicates.isSimpleContext()) {
                OXMLSequence oXMLSequence2 = xSLTContext.pushExprValue();
                XPathSequence.addNode(oXMLSequence2, xMLNode2);
                this.axisClass.getNodeList(this, xSLTContext);
                if (XPathSequence.contains(oXMLSequence2, xMLNode)) {
                    if (this.prevSeparator == 5) {
                        xSLTContext.popExprValue();
                        return xMLNode2;
                    }
                    XPathAxis.getAncestor(xMLNode, oXMLSequence);
                }
                xSLTContext.popExprValue();
                return null;
            }
            if (!this.predicates.filterNode(xMLNode, xSLTContext)) {
                return null;
            }
        }
        if (this.prevSeparator == 5) {
            return xMLNode2;
        }
        XPathAxis.getAncestor(xMLNode, oXMLSequence);
        return null;
    }
}

