/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.NSName;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class XPathVarReference
extends XSLExprBase {
    private NSName nsname;
    private int varIdx = -1;

    XPathVarReference() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException {
        if (xSLParseString.isVarRestricted()) {
            throw new XPathException(1013, xSLParseString.getExprString());
        }
        if (xSLParseString.peekToken() != 7) {
            return null;
        }
        xSLParseString.nextToken();
        if (xSLParseString.nextToken() != 112) {
            throw new XPathException(1019, "QNAME", xSLParseString.getCurrentToken());
        }
        XPathVarReference xPathVarReference = new XPathVarReference();
        xPathVarReference.nsname = new NSNameImpl("", xSLParseString.getLocalName(), xSLParseString.getNamespace());
        if (xSLParseString.xss != null) {
            xPathVarReference.varIdx = xSLParseString.xss.getVariableIndex(xPathVarReference.nsname);
        }
        xPathVarReference.setExprType(0x2200000);
        return xPathVarReference;
    }

    void cacheSubExpr() {
    }

    boolean canCacheExpr() {
        return false;
    }

    String getNormalizedExpr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(7);
        stringBuffer.append(this.nsname.getNamespace());
        stringBuffer.append(":");
        stringBuffer.append(this.nsname.getLocalName());
        return stringBuffer.toString();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence = xSLTContext.pushExprValue();
        OXMLSequence oXMLSequence2 = xSLTContext.getVariable(this.nsname, this.varIdx);
        if (oXMLSequence2 == null) {
            throw new XPathException(1031, this.nsname.getQualifiedName());
        }
        XPathSequence.concatSequence(oXMLSequence, (OXMLSequence)oXMLSequence2.clone());
        if (this.predicates != null) {
            this.filterPredicates(xSLTContext);
        }
    }

    boolean checkPosLastFN() {
        return false;
    }
}

