/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.CachedExpr;
import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathFunctionCall;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public abstract class XSLExprBase
implements XSLExprConstants {
    XSLExprBase leftExpr;
    XSLExprBase rightExpr;
    int exprType;
    XPathPredicate predicates;
    int operator;
    float priority;
    int version;
    boolean bkwdCompFlag;
    boolean fwdCompFlag;

    public static XSLExprBase createExpression(String string, NSResolver nSResolver, XSLStylesheet xSLStylesheet) throws XSLException, XQException {
        Object object;
        if (string == "") {
            throw new XPathException(1025);
        }
        XSLParseString xSLParseString = new XSLParseString(string, nSResolver, xSLStylesheet);
        if (nSResolver instanceof XSLNode) {
            object = (XSLNode)nSResolver;
            xSLParseString.setCompatibilityFlags(((XSLNode)object).getXSLTVersion(), ((XSLNode)object).isBackwardCompatibilityMode(), ((XSLNode)object).isForwardCompatibilityMode());
        } else {
            xSLParseString.setCompatibilityFlags(10, false, false);
        }
        object = XSLExpr.parse(xSLParseString);
        ((XSLExprBase)object).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        if (xSLParseString.nextToken() != -1) {
            throw new XPathException(1026, new String(xSLParseString.getExprString()));
        }
        if (xSLParseString.isCachingExpr() && ((XSLExprBase)object).canCacheExpr()) {
            object = ((XSLExprBase)object).createCachedExpr();
        }
        return object;
    }

    public static XSLExprBase createPattern(String string, NSResolver nSResolver, boolean bl, XSLStylesheet xSLStylesheet) throws XSLException, XQException {
        Object object;
        if (string == "") {
            throw new XPathException(1025);
        }
        XSLParseString xSLParseString = new XSLParseString(string, nSResolver, xSLStylesheet);
        if (nSResolver instanceof XSLNode) {
            object = (XSLNode)nSResolver;
            xSLParseString.setCompatibilityFlags(((XSLNode)object).getXSLTVersion(), ((XSLNode)object).isBackwardCompatibilityMode(), ((XSLNode)object).isForwardCompatibilityMode());
        } else {
            xSLParseString.setCompatibilityFlags(10, false, false);
        }
        xSLParseString.setVarRestricted(bl);
        xSLParseString.setPattern(true);
        object = XSLNodeSetExpr.parse(xSLParseString);
        ((XSLExprBase)object).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        if (xSLParseString.nextToken() != -1) {
            throw new XPathException(1026, new String(xSLParseString.getExprString()));
        }
        return object;
    }

    public void setEvaluationHints(String string, Object object) {
    }

    void setExprType(int n) {
        this.exprType = n;
    }

    int getExprType() {
        return this.exprType;
    }

    boolean isExprType(int n) {
        return (this.exprType & n & 0xFFFFFE) != 0;
    }

    XSLExprBase createCachedExpr() throws XQException {
        return new CachedExpr(this, this.getNormalizedExpr());
    }

    abstract void cacheSubExpr() throws XQException;

    abstract boolean canCacheExpr();

    abstract String getNormalizedExpr() throws XQException;

    abstract boolean checkPosLastFN();

    public abstract void evaluate(XSLTContext var1) throws XSLException, XQException;

    public OXMLSequence getValue(XSLTContext xSLTContext) throws XSLException, XQException {
        this.evaluate(xSLTContext);
        XPathSequence xPathSequence = new XPathSequence(xSLTContext);
        XPathSequence.concatSequence(xPathSequence, xSLTContext.popExprValue());
        return xPathSequence;
    }

    public boolean testBooleanExpr(XSLTContext xSLTContext) throws XSLException, XQException {
        this.evaluate(xSLTContext);
        return XPathSequence.getBooleanValue(xSLTContext.popExprValue());
    }

    public String getStringValue(XSLTContext xSLTContext) throws XSLException, XQException {
        this.evaluate(xSLTContext);
        return XPathSequence.getStringValue(xSLTContext.popExprValue());
    }

    public double getNumberValue(XSLTContext xSLTContext) throws XSLException, XQException {
        this.evaluate(xSLTContext);
        return XPathSequence.getNumberValue(xSLTContext.popExprValue());
    }

    XMLDocumentFragment getResultTree(XSLTContext xSLTContext) throws XSLException, XQException {
        this.evaluate(xSLTContext);
        return XPathSequence.getResultTreeValue(xSLTContext.popExprValue());
    }

    Object getExtensionValue(XSLTContext xSLTContext) throws XSLException, XQException {
        this.evaluate(xSLTContext);
        return XPathSequence.getExtensionValue(xSLTContext.popExprValue());
    }

    final int getPositionTest() throws XPathException, XSLException, XQException {
        if (this.operator >= 210 && this.operator <= 221) {
            XPathConstantExpr xPathConstantExpr;
            XPathFunctionCall xPathFunctionCall;
            if (this.operator == 211 || this.operator == 217) {
                return 0;
            }
            if (this.leftExpr instanceof XPathConstantExpr && this.rightExpr instanceof XPathFunctionCall && (this.operator == 210 || this.operator == 216 || this.operator == 214 || this.operator == 220 || this.operator == 215 || this.operator == 221)) {
                xPathFunctionCall = (XPathFunctionCall)this.rightExpr;
                xPathConstantExpr = (XPathConstantExpr)this.leftExpr;
                if (xPathFunctionCall.func.getFunctionName().equals("position")) {
                    return xPathConstantExpr.getPositionValue();
                }
            }
            if (this.leftExpr instanceof XPathFunctionCall && this.rightExpr instanceof XPathConstantExpr && (this.operator == 210 || this.operator == 216 || this.operator == 212 || this.operator == 218 || this.operator == 213 || this.operator == 219)) {
                xPathFunctionCall = (XPathFunctionCall)this.leftExpr;
                xPathConstantExpr = (XPathConstantExpr)this.rightExpr;
                if (xPathFunctionCall.func.getFunctionName().equals("position")) {
                    return xPathConstantExpr.getPositionValue();
                }
            }
        } else if (this.operator == 107) {
            int n = this.leftExpr.getPositionTest();
            int n2 = this.rightExpr.getPositionTest();
            if (n == 0 || n2 <= n) {
                return n2;
            }
            if (n2 == 0 || n <= n2) {
                return n;
            }
        }
        return 0;
    }

    protected void filterPredicates(XSLTContext xSLTContext) throws XPathException, XSLException, XQException {
        OXMLSequence oXMLSequence = xSLTContext.peekExprValue();
        if (!oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_MORE)) {
            throw new XPathException(1022);
        }
        this.predicates.filter(oXMLSequence, xSLTContext);
    }

    public XSLExprBase matchPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        return null;
    }

    boolean matchNodeList(XMLNode xMLNode, OXMLSequence oXMLSequence, XSLTContext xSLTContext) throws XSLException, XQException {
        return false;
    }

    public float getPriority() throws XSLException {
        return this.priority;
    }

    public void setPriority(float f) throws XSLException {
        this.priority = f;
    }

    public int getAnchorType() throws XSLException {
        return -1;
    }

    public void getAnchorName(String[] stringArray) throws XSLException {
    }

    void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    int getXSLTVersion() {
        return this.version;
    }

    boolean isBackwardCompatibilityMode() {
        return this.bkwdCompFlag;
    }

    boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }
}

