/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.datamodel;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import javax.xml.namespace.QName;
import oracle.i18n.text.OraCollator;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLConstants;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xml.xslt.XSLNamespace;

public abstract class OXMLItem
extends XSDDataValue
implements XMLItem,
OXMLConstants {
    protected XMLNode nodeValue;
    protected OXMLSequenceType stype;
    static final int MAX_OP = 6;
    static final int NUM_PRIMITIVE_TYPES = 22;
    static boolean[][] castTable;
    static final int[][] opComb;
    static final int[][] opTable;
    static final boolean[][] compTable;

    public int getPrimitiveType() {
        if (this.stype.isNode()) {
            return 90;
        }
        return this.stype.getPrimitiveId();
    }

    public OXMLSequenceType getItemType() {
        return this.stype;
    }

    public abstract void atomize(OXMLSequence var1) throws XQException;

    public abstract OXMLSequence atomize() throws XQException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (this.stype == oXMLSequenceType) {
            return;
        }
        if (this.stype.isOfType(oXMLSequenceType)) {
            this.setType(oXMLSequenceType);
            return;
        }
        int n = oXMLSequenceType.getPrimitiveId();
        OXMLSequenceType oXMLSequenceType2 = OXMLSequenceType.getConstantType(1, n);
        int n2 = this.stype.getPrimitiveId();
        int n3 = n2 = n2 == 22 ? 5 : n2;
        if (n == 22) {
            if (!castTable[n2][5]) throw new XQException("type error");
            this.convert2Integer();
        } else {
            if (!castTable[n2][n]) throw new XQException("type error");
            switch (n) {
                case 3: {
                    this.convert2Float();
                    break;
                }
                case 4: {
                    this.convert2Double();
                    break;
                }
                case 5: {
                    this.convert2Decimal();
                    break;
                }
                case 2: {
                    this.convert2Boolean();
                    break;
                }
                case 15: 
                case 16: {
                    this.setString(oXMLSequenceType2, this.getLexicalValue());
                    break;
                }
                case 17: {
                    this.convert2URI();
                    break;
                }
                case 18: {
                    this.convert2QName();
                    break;
                }
                case 1: {
                    this.setString(OXMLSequenceType.TSTRING, this.getLexicalValue());
                    break;
                }
                case 0: {
                    this.setUntypedLexical(this.getLexicalValue());
                    break;
                }
                case 20: 
                case 21: {
                    if (n2 == 6) {
                        if (n == 21) {
                            this.intValue = 0;
                        } else {
                            this.doubleValue = 0.0;
                        }
                        this.lexicalValue = null;
                    } else {
                        this.parseLexical(6);
                        try {
                            oXMLSequenceType2.getDataType().validateValue(this.lexicalValue);
                        }
                        catch (Exception exception) {
                            throw new XQException("invalid value for cast");
                        }
                    }
                    this.nodeValue = null;
                    this.objValue = null;
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 6: {
                    if (n2 == 1 || n2 == 0) {
                        this.parseLexical(6);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 7: {
                    if (n2 == 9) {
                        GregorianCalendar gregorianCalendar = this.getContext().getDateTime();
                        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)this.objValue;
                        gregorianCalendar2.set(11, gregorianCalendar.get(11));
                        gregorianCalendar2.set(12, gregorianCalendar.get(12));
                        gregorianCalendar2.set(13, gregorianCalendar.get(13));
                        gregorianCalendar2.set(14, gregorianCalendar.get(14));
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else if (n2 == 8) {
                        GregorianCalendar gregorianCalendar = this.getContext().getDateTime();
                        GregorianCalendar gregorianCalendar3 = (GregorianCalendar)this.objValue;
                        gregorianCalendar3.set(1, gregorianCalendar.get(1));
                        gregorianCalendar3.set(2, gregorianCalendar.get(2));
                        gregorianCalendar3.set(5, gregorianCalendar.get(5));
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 9: {
                    if (n2 == 7) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 8: {
                    if (n2 == 7) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 1971);
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(5, 1);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 10: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 11: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 12: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 1971);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 13: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 1971);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 14: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 1971);
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                }
            }
        }
        if (oXMLSequenceType.exactlyMatches(oXMLSequenceType2)) return;
        try {
            oXMLSequenceType.getDataType().validateValue(this.getLexicalValue());
            this.setType(oXMLSequenceType);
            return;
        }
        catch (Exception exception) {
            throw new XQException("invalid value for cast");
        }
    }

    protected OXMLFunctionContext getContext() throws XQException {
        throw new XQException("undefined context item");
    }

    private void parseLexical(int n) {
        this.getLexicalValue();
        try {
            this.setValue(n, this.lexicalValue);
        }
        catch (XSDException xSDException) {
            throw new XQException("type error");
        }
        this.nodeValue = null;
    }

    private void convert2Float() throws XQException {
        int n = this.stype.getPrimitiveId();
        double d = -1.0;
        switch (n) {
            case 3: {
                return;
            }
            case 5: 
            case 22: {
                d = this.booleanValue ? (double)((BigDecimal)this.objValue).floatValue() : (double)this.intValue;
                break;
            }
            case 4: {
                if (this.doubleValue > 3.4028234663852886E38) {
                    d = Double.POSITIVE_INFINITY;
                    break;
                }
                if (this.doubleValue < -3.4028234663852886E38) {
                    d = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (Math.abs(this.doubleValue) < (double)1.4E-45f) {
                    d = 0.0;
                    break;
                }
                d = this.doubleValue;
                break;
            }
            case 2: {
                d = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("INF")) {
                    d = Double.POSITIVE_INFINITY;
                    break;
                }
                if (string.equals("-INF")) {
                    d = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (string.equals("Infinity") || string.equals("-Infinity")) {
                    throw new XQException("invalid value for cast");
                }
                try {
                    d = Float.parseFloat(this.getLexicalValue().trim());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XQException("invalid value for cast");
                }
            }
        }
        this.setDouble(OXMLSequenceType.TFLOAT, d);
    }

    protected void convert2Double() throws XQException {
        int n = this.stype.getPrimitiveId();
        double d = -1.0;
        switch (n) {
            case 4: {
                return;
            }
            case 5: 
            case 22: {
                d = this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
                break;
            }
            case 3: {
                d = this.doubleValue;
                break;
            }
            case 2: {
                d = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("INF")) {
                    d = Double.POSITIVE_INFINITY;
                    break;
                }
                if (string.equals("-INF")) {
                    d = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (string.equals("Infinity") || string.equals("-Infinity")) {
                    throw new XQException("invalid value for cast");
                }
                try {
                    d = Double.parseDouble(this.getLexicalValue().trim());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XQException("invalid value for cast");
                }
            }
        }
        this.setDouble(OXMLSequenceType.TDOUBLE, d);
    }

    private void convert2Decimal() throws XQException {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 5: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isInfinite(this.doubleValue) || Double.isNaN(this.doubleValue)) {
                    throw new XQException("error in casting to decimal");
                }
                this.setDecimal(OXMLSequenceType.TDECIMAL, new BigDecimal(this.doubleValue));
                break;
            }
            case 2: {
                int n2 = this.booleanValue ? 1 : 0;
                this.setInt(OXMLSequenceType.TDECIMAL, n2);
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.length() == 0) {
                    throw new XQException("invalid value for cast");
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                    throw new XQException("invalid value for cast");
                }
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                int n3 = string.length() - 1;
                try {
                    int n4 = Integer.parseInt(this.lexicalValue);
                    this.setInt(OXMLSequenceType.TDECIMAL, n4);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.charAt(n3) == '.') {
                        string = string.substring(0, n3);
                    }
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new XQException("invalid value for cast");
                    }
                }
            }
        }
    }

    private void convert2Integer() throws XQException {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 22: {
                return;
            }
            case 5: {
                if (this.booleanValue) {
                    BigDecimal bigDecimal = ((BigDecimal)this.objValue).setScale(0, 1);
                    this.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    break;
                }
                this.setInt(OXMLSequenceType.TINTEGER, this.intValue);
                break;
            }
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue) || Double.isInfinite(this.doubleValue)) {
                    throw new XQException("error in casting to integer");
                }
                double d = Math.floor(this.doubleValue);
                double d2 = d = d < 0.0 ? d + 1.0 : d;
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    this.setDecimal(OXMLSequenceType.TINTEGER, new BigDecimal(d));
                    break;
                }
                this.setInt(OXMLSequenceType.TINTEGER, (int)d);
                break;
            }
            case 2: {
                int n2 = this.booleanValue ? 1 : 0;
                this.setInt(OXMLSequenceType.TINTEGER, n2);
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.length() == 0) {
                    throw new XQException("invalid value for cast");
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0 || string.indexOf(46) >= 0) {
                    throw new XQException("invalid value for cast");
                }
                int n3 = string.length() - 1;
                if (n3 >= 0 && string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                try {
                    int n4 = Integer.parseInt(this.lexicalValue);
                    this.setInt(OXMLSequenceType.TINTEGER, n4);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new XQException("invalid value for cast");
                    }
                }
            }
        }
    }

    protected void convert2Boolean() throws XQException {
        int n = this.stype.getPrimitiveId();
        boolean bl = false;
        switch (n) {
            case 2: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue) || this.doubleValue == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    bl = ((BigDecimal)this.objValue).intValue() != 0;
                    break;
                }
                bl = this.intValue != 0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim().toLowerCase();
                if (string.equals("true") || string.equals("1")) {
                    bl = true;
                    break;
                }
                if (string.equals("false") || string.equals("0")) {
                    bl = false;
                    break;
                }
                throw new XQException("invalid value for cast");
            }
        }
        this.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    private void convert2URI() throws XQException {
        int n = this.stype.getPrimitiveId();
        Object var2_2 = null;
        switch (n) {
            case 17: {
                return;
            }
        }
        this.setString(OXMLSequenceType.TANYURI, this.lexicalValue);
    }

    protected abstract void convert2QName() throws XQException;

    public boolean matchesType(OXMLSequenceType oXMLSequenceType) throws XQException {
        return this.stype.isOfTypeIgnoreOccurence(oXMLSequenceType);
    }

    public boolean isCastable(OXMLSequenceType oXMLSequenceType) throws XQException {
        int n = oXMLSequenceType.getPrimitiveId();
        int n2 = this.stype.getPrimitiveId();
        if (n >= 22 || n2 >= 22) {
            return false;
        }
        if (castTable[n2][n]) {
            try {
                this.getLexicalValue();
                oXMLSequenceType.getDataType().validateValue(this.lexicalValue);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void compareValue(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2) throws XQException {
        OraCollator oraCollator = null;
        OXMLFunctionContext oXMLFunctionContext = null;
        try {
            oXMLFunctionContext = this.getContext();
        }
        catch (XQException xQException) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2003/11/xpath-functions/collation/codepoint", null);
            this.compareValue(oXMLItem, n, oXMLItem2, oraCollator);
            return;
        }
        if (oXMLFunctionContext == null) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2003/11/xpath-functions/collation/codepoint", null);
        } else {
            String string = oXMLFunctionContext.getDefaultCollation();
            oraCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        }
        this.compareValue(oXMLItem, n, oXMLItem2, oraCollator);
    }

    public void compareValue(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2, OraCollator oraCollator) throws XQException {
        switch (n) {
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                switch (this.basicType) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        throw new XQException("items not comparable");
                    }
                }
            }
        }
        int n2 = this.compareValue(oXMLItem, oraCollator);
        if (n2 == -2) {
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, false);
        } else {
            if (n2 > 1 || n2 < -1 || n < 210 || n > 215) {
                throw new XQException("items not comparable");
            }
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, compTable[n2 + 1][n - 210]);
        }
    }

    public int compareValue(OXMLItem oXMLItem) throws XQException {
        OraCollator oraCollator = null;
        OXMLFunctionContext oXMLFunctionContext = null;
        try {
            oXMLFunctionContext = this.getContext();
        }
        catch (XQException xQException) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2003/11/xpath-functions/collation/codepoint", null);
            return this.compareValue(oXMLItem, oraCollator);
        }
        if (oXMLFunctionContext == null) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2003/11/xpath-functions/collation/codepoint", null);
        } else {
            String string = oXMLFunctionContext.getDefaultCollation();
            oraCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        }
        return this.compareValue(oXMLItem, oraCollator);
    }

    public int compareValue(OXMLItem oXMLItem, OraCollator oraCollator) throws XQException {
        int n = this.stype.getPrimitiveId();
        n = n == 0 ? 1 : n;
        int n2 = oXMLItem.stype.getPrimitiveId();
        n2 = n2 == 0 ? 1 : n2;
        switch (this.getComp(n, n2)) {
            case 2: {
                if (this.booleanValue == oXMLItem.booleanValue) {
                    return 0;
                }
                if (this.booleanValue) {
                    return 1;
                }
                return -1;
            }
            case 3: 
            case 4: {
                double d = this.doubleValue() - oXMLItem.doubleValue();
                if (d > 0.0) {
                    return 1;
                }
                if (d < 0.0) {
                    return -1;
                }
                if (d == 0.0) {
                    return 0;
                }
                return -2;
            }
            case 5: 
            case 22: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    return this.getDecimal().compareTo(oXMLItem.getDecimal());
                }
                if (this.intValue > oXMLItem.intValue) {
                    return 1;
                }
                if (this.intValue < oXMLItem.intValue) {
                    return -1;
                }
                return 0;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                GregorianCalendar gregorianCalendar2 = (GregorianCalendar)oXMLItem.objValue;
                if (gregorianCalendar.after(gregorianCalendar2)) {
                    return 1;
                }
                if (gregorianCalendar2.after(gregorianCalendar)) {
                    return -1;
                }
                return 0;
            }
            case 6: 
            case 20: 
            case 21: {
                return this.compareVal(oXMLItem, 6);
            }
            case 1: {
                int n3 = oraCollator.compare(this.getString(), oXMLItem.getString());
                n3 = n3 > 0 ? 1 : (n3 < 0 ? -1 : 0);
                return n3;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                boolean bl = this.getString().equals(oXMLItem.getString());
                int n4 = bl ? 0 : -1;
                return n4;
            }
            case 18: {
                boolean bl = this.getQName().equals(oXMLItem.getQName());
                int n5 = bl ? 0 : -1;
                return n5;
            }
        }
        throw new XQException("items not comparable");
    }

    private int getComp(int n, int n2) throws XQException {
        if (n == n2) {
            return n;
        }
        if (n > n2) {
            if ((n <= 5 || n == 22) && n2 >= 3) {
                return n2;
            }
        } else if ((n2 <= 5 || n2 == 22) && n >= 3) {
            return n;
        }
        throw new XQException("items not comparable");
    }

    private double doubleValue() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 3 || n == 4) {
            return this.doubleValue;
        }
        if (n == 5 || n == 22) {
            return this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
        }
        throw new XQException("items not comparable");
    }

    private float floatValue() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 3) {
            return (float)this.doubleValue;
        }
        if (n == 5 || n == 22) {
            return this.booleanValue ? ((BigDecimal)this.objValue).floatValue() : (float)this.intValue;
        }
        throw new XQException("items not comparable");
    }

    private BigDecimal decimalValue() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 5 || n == 22) {
            return this.booleanValue ? (BigDecimal)this.objValue : BigDecimal.valueOf(this.intValue);
        }
        throw new XQException("items not comparable");
    }

    private void setDecimal(OXMLSequenceType oXMLSequenceType, long l) throws XQException {
        this.booleanValue = false;
        if ((long)((int)l) == l) {
            this.setInt(oXMLSequenceType, (int)l);
        } else {
            this.setDecimal(oXMLSequenceType, new BigDecimal((double)l));
        }
    }

    public void compareNodes(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2) throws XQException {
        int n2 = FNUtil.compareNodeOrder(this.nodeValue, oXMLItem.nodeValue);
        boolean bl = false;
        switch (n) {
            case 208: {
                bl = n2 == 0;
                break;
            }
            case 223: {
                bl = n2 > 0;
                break;
            }
            case 222: {
                bl = n2 < 0;
            }
        }
        oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    public void negate() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 5 || n == 22) {
            if (this.booleanValue) {
                this.objValue = ((BigDecimal)this.objValue).negate();
            } else {
                this.intValue = -this.intValue;
            }
        } else if (n == 4 || n == 3) {
            this.doubleValue = -this.doubleValue;
        }
    }

    public void arithmetic(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2) throws XQException {
        if (this.stype == null || oXMLItem.stype == null) {
            throw new XQException("type exception");
        }
        int n2 = this.stype.getPrimitiveId();
        int n3 = oXMLItem.stype.getPrimitiveId();
        switch (OXMLItem.getCase(this.basicType, oXMLItem.basicType, n)) {
            case 1: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() + oXMLItem.floatValue());
                return;
            }
            case 2: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() + oXMLItem.doubleValue());
                return;
            }
            case 3: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().add(oXMLItem.decimalValue());
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue + (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 4: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() - oXMLItem.floatValue());
                return;
            }
            case 5: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() - oXMLItem.doubleValue());
                return;
            }
            case 6: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().subtract(oXMLItem.decimalValue());
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue - (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 7: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() * oXMLItem.floatValue());
                return;
            }
            case 8: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() * oXMLItem.doubleValue());
                return;
            }
            case 9: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().multiply(oXMLItem.decimalValue());
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue * (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 10: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() / oXMLItem.floatValue());
                return;
            }
            case 11: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() / oXMLItem.doubleValue());
                return;
            }
            case 12: {
                if (!this.booleanValue && !oXMLItem.booleanValue && this.intValue % oXMLItem.intValue == 0) {
                    long l = (long)this.intValue / (long)oXMLItem.intValue;
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                } else {
                    BigDecimal bigDecimal = this.decimalValue().divide(oXMLItem.decimalValue(), 10, 1);
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                }
                return;
            }
            case 13: {
                if (n2 != 22 || n3 != 22) {
                    throw new XQException("type exception");
                }
                if (this.booleanValue || oXMLItem.booleanValue) {
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, this.decimalValue().divide(oXMLItem.decimalValue(), 0, 1));
                } else {
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, this.intValue / oXMLItem.intValue);
                }
                return;
            }
            case 14: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() % oXMLItem.floatValue());
                return;
            }
            case 15: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() % oXMLItem.doubleValue());
                return;
            }
            case 16: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().subtract(this.decimalValue().divide(oXMLItem.decimalValue(), 0, 1).multiply(oXMLItem.decimalValue()));
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue % (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 17: {
                if (n2 != n3 || n2 == 6) {
                    throw new XQException("type error");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), this.intValue + oXMLItem.intValue, this.doubleValue + oXMLItem.doubleValue);
                return;
            }
            case 18: {
                if (n2 != n3 || n2 == 6) {
                    throw new XQException("type error");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), this.intValue - oXMLItem.intValue, this.doubleValue - oXMLItem.doubleValue);
                return;
            }
            case 19: {
                if (n2 == 6) {
                    throw new XQException("type error");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), (int)((double)this.intValue * oXMLItem.doubleValue), this.doubleValue * oXMLItem.doubleValue());
                return;
            }
            case 20: {
                if (n2 == 6) {
                    throw new XQException("type error");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), (int)((double)this.intValue / oXMLItem.doubleValue()), this.doubleValue / oXMLItem.doubleValue());
                return;
            }
            case 21: 
            case 22: {
                long l = ((GregorianCalendar)this.objValue).getTimeInMillis() - ((GregorianCalendar)oXMLItem.objValue).getTimeInMillis();
                oXMLItem2.setDuration(OXMLSequenceType.TDTDURATION, 0, (double)l / 1000.0);
                return;
            }
            case 23: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                SimpleTimeZone simpleTimeZone = (SimpleTimeZone)gregorianCalendar.getTimeZone();
                gregorianCalendar.setTimeZone(UTC);
                gregorianCalendar.add(2, oXMLItem.intValue);
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(simpleTimeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 24: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                SimpleTimeZone simpleTimeZone = (SimpleTimeZone)gregorianCalendar.getTimeZone();
                gregorianCalendar.setTimeZone(UTC);
                gregorianCalendar.add(2, -oXMLItem.intValue);
                this.addTime(gregorianCalendar, -oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(simpleTimeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 25: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                SimpleTimeZone simpleTimeZone = (SimpleTimeZone)gregorianCalendar.getTimeZone();
                gregorianCalendar.setTimeZone(UTC);
                gregorianCalendar.add(2, oXMLItem.intValue);
                this.addDays(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(simpleTimeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, this.booleanValue, gregorianCalendar);
                return;
            }
            case 26: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                SimpleTimeZone simpleTimeZone = (SimpleTimeZone)gregorianCalendar.getTimeZone();
                gregorianCalendar.setTimeZone(UTC);
                gregorianCalendar.add(2, -oXMLItem.intValue);
                this.addDays(gregorianCalendar, -oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(simpleTimeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, this.booleanValue, gregorianCalendar);
                return;
            }
            case 27: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 28: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                this.addTime(gregorianCalendar, -oXMLItem.doubleValue);
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 29: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                gregorianCalendar.add(2, this.intValue);
                gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                SimpleTimeZone simpleTimeZone = (SimpleTimeZone)gregorianCalendar.getTimeZone();
                gregorianCalendar.setTimeZone(UTC);
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(simpleTimeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
            case 30: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                SimpleTimeZone simpleTimeZone = (SimpleTimeZone)gregorianCalendar.getTimeZone();
                gregorianCalendar.setTimeZone(UTC);
                gregorianCalendar.add(2, this.intValue);
                this.addDays(gregorianCalendar, this.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(simpleTimeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
            case 31: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)oXMLItem.objValue;
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
        }
        throw new XQException("type exception");
    }

    private void addTime(GregorianCalendar gregorianCalendar, double d) {
        if (d == 0.0) {
            return;
        }
        int n = (int)d / 86400;
        gregorianCalendar.add(5, n);
        d -= (double)(n * 86400);
        n = (int)d;
        gregorianCalendar.add(13, n);
        d -= (double)n;
        n = (int)d * 1000;
        gregorianCalendar.add(14, n);
    }

    private void addDays(GregorianCalendar gregorianCalendar, double d) {
        if (d == 0.0) {
            return;
        }
        int n = (int)d / 86400;
        gregorianCalendar.add(5, n);
    }

    public void copyItem(OXMLItem oXMLItem) {
        this.copyDataValue(oXMLItem);
        this.nodeValue = oXMLItem.nodeValue;
        this.stype = oXMLItem.stype;
    }

    public XMLNode getNode() {
        return this.nodeValue;
    }

    public void setNode(XMLNode xMLNode) throws XQException {
        short s = xMLNode.getNodeType();
        this.stype = xMLNode instanceof XSLNamespace ? OXMLSequenceType.createNodeType(FNUtil.getNodeQName(xMLNode), null, 99, false, 1) : OXMLSequenceType.createNodeType(xMLNode);
        this.nodeValue = xMLNode;
        this.lexicalValue = null;
        this.objValue = null;
    }

    public String getLexicalValue() {
        if (this.lexicalValue != null) {
            return this.lexicalValue;
        }
        if (this.stype.isNode()) {
            this.lexicalValue = this.nodeValue.getText().intern();
            return this.lexicalValue;
        }
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue)) {
                    this.lexicalValue = "NaN";
                    break;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    this.lexicalValue = this.doubleValue > 0.0 ? "INF" : "-INF";
                    break;
                }
                double d = Math.abs(this.doubleValue);
                if (d > 1000000.0 || d < 1.0E-6) {
                    DecimalFormat decimalFormat = new DecimalFormat("0.0################E0##");
                    this.lexicalValue = decimalFormat.format(this.doubleValue);
                    break;
                }
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setGroupingUsed(false);
                decimalFormat.setMaximumFractionDigits(100);
                this.lexicalValue = decimalFormat.format(this.doubleValue);
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    this.lexicalValue = this.getBigDecimalLexical((BigDecimal)this.objValue);
                    break;
                }
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setGroupingUsed(false);
                decimalFormat.setMaximumFractionDigits(100);
                this.lexicalValue = decimalFormat.format(this.intValue);
                break;
            }
            case 2: {
                this.lexicalValue = this.booleanValue ? "true" : "false";
                break;
            }
            case 20: 
            case 21: {
                this.lexicalValue = this.getDurationLexical(n);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.lexicalValue = this.getDateTimeLexical(n);
                break;
            }
            case 18: {
                QName qName = (QName)this.objValue;
                String string = qName.getPrefix();
                String string2 = qName.getLocalPart();
                if (string == null || string.length() == 0) {
                    this.lexicalValue = string2;
                    break;
                }
                this.lexicalValue = string + ':' + string2;
                break;
            }
        }
        this.lexicalValue = this.lexicalValue.intern();
        return this.lexicalValue;
    }

    private String getBigDecimalLexical(BigDecimal bigDecimal) {
        int n;
        String string = bigDecimal.toString();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = string.indexOf(46);
        if (n3 < 0) {
            n3 = n2;
        }
        int n4 = n = string.charAt(0) == '+' ? 1 : 0;
        while (n < n3 - 1 && string.charAt(n) == '0') {
            ++n;
        }
        stringBuffer.append(string.substring(n, n3));
        if (n3 != n2) {
            for (n = n2 - 1; n > n3 + 1 && string.charAt(n) == '0'; --n) {
            }
            stringBuffer.append(string.substring(n3, n + 1));
        }
        return stringBuffer.toString();
    }

    String getDurationLexical(int n) {
        long l;
        long l2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.intValue < 0 || this.doubleValue < 0.0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (n != 21) {
            l2 = this.intValue >= 0 ? (long)this.intValue : (long)(-this.intValue);
            l = l2 / 12L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('Y');
            }
            if ((l = l2 % 12L) > 0L || n == 20) {
                stringBuffer.append(l);
                stringBuffer.append('M');
            }
        }
        if (n != 20) {
            l2 = (long)(this.doubleValue >= 0.0 ? this.doubleValue * 1000.0 : -this.doubleValue * 1000.0);
            l = l2 / 86400000L;
            l2 %= 86400000L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('D');
            }
            stringBuffer.append('T');
            l = l2 / 3600000L;
            l2 %= 3600000L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('H');
            }
            l = l2 / 60000L;
            l2 %= 60000L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('M');
            }
            if (l2 > 0L || stringBuffer.charAt(stringBuffer.length() - 1) == 'T') {
                l = l2 / 1000L;
                stringBuffer.append(l);
                if ((l2 %= 1000L) > 0L) {
                    stringBuffer.append('.');
                    stringBuffer.append(l2);
                }
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }

    String getDateTimeLexical(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
        if (n == 7 || n == 9 || n == 10 || n == 11) {
            if (gregorianCalendar.get(0) == 0) {
                stringBuffer.append('-');
                n2 = 1;
            }
            stringBuffer.append(gregorianCalendar.get(1));
            while (stringBuffer.length() - n2 < 4) {
                stringBuffer.insert(n2, '0');
            }
        }
        if (n != 11 && n != 8) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append('-');
            if (n != 14) {
                n2 = gregorianCalendar.get(2) + 1;
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2);
            } else {
                stringBuffer.append('-');
            }
            if (n != 12 && n != 10) {
                if (n != 14) {
                    stringBuffer.append('-');
                }
                if ((n2 = gregorianCalendar.get(5)) < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2);
            }
        }
        if (n == 7 || n == 8) {
            if (n == 7) {
                stringBuffer.append('T');
            }
            if ((n2 = gregorianCalendar.get(11)) < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            stringBuffer.append(':');
            n2 = gregorianCalendar.get(12);
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            stringBuffer.append(':');
            n2 = gregorianCalendar.get(13);
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            n2 = gregorianCalendar.get(14);
            if (n2 > 0) {
                stringBuffer.append('.');
                stringBuffer.append(n2);
            }
        }
        if (this.booleanValue) {
            int n3 = ((SimpleTimeZone)gregorianCalendar.getTimeZone()).getRawOffset() / 60000;
            if (n3 == 0) {
                stringBuffer.append('Z');
                return stringBuffer.toString();
            }
            if (n3 > 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
                n3 = -n3;
            }
            n2 = n3 / 60;
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            n2 = n3 % 60;
            stringBuffer.append(':');
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public Object getExternalObject() {
        return this.objValue;
    }

    public void setExternalObject(Object object) throws XQException {
        this.stype = null;
        this.basicType = -1;
        this.objValue = object;
        this.lexicalValue = null;
        this.nodeValue = null;
    }

    public void setUntypedLexical(String string) throws XQException {
        this.lexicalValue = string;
        this.basicType = 0;
        this.nodeValue = null;
        this.objValue = null;
        this.stype = OXMLSequenceType.TUNTYPED;
    }

    public String getString() {
        return this.lexicalValue;
    }

    public void setString(OXMLSequenceType oXMLSequenceType, String string) throws XQException {
        this.setType(oXMLSequenceType);
        this.lexicalValue = string;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 1 && this.basicType != 17 && this.basicType != 19 && this.basicType != 16 && this.basicType != 15) {
            throw new XQException("type error");
        }
    }

    public boolean getBoolean() {
        return this.booleanValue;
    }

    public void setBoolean(OXMLSequenceType oXMLSequenceType, boolean bl) throws XQException {
        this.setType(oXMLSequenceType);
        this.booleanValue = bl;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 2) {
            throw new XQException("type error");
        }
    }

    public GregorianCalendar getCalendar() {
        return (GregorianCalendar)this.objValue;
    }

    public boolean hasTimeZone() {
        return this.booleanValue;
    }

    public void setCalendar(OXMLSequenceType oXMLSequenceType, boolean bl, GregorianCalendar gregorianCalendar) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = gregorianCalendar;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.booleanValue = bl;
        if (this.basicType < 7 || this.basicType > 14 || !bl && gregorianCalendar.get(15) != 0) {
            throw new XQException("type error");
        }
    }

    public int getYearMonthDuration() {
        return this.intValue;
    }

    public double getDayTimeDuration() {
        return this.doubleValue;
    }

    public void setDuration(OXMLSequenceType oXMLSequenceType, int n, double d) throws XQException {
        this.setType(oXMLSequenceType);
        this.intValue = n;
        this.doubleValue = d;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 6) {
            throw new XQException("type error");
        }
    }

    public boolean withinRange() throws XQException {
        return !this.booleanValue;
    }

    public int getInt() {
        return this.intValue;
    }

    public void setInt(OXMLSequenceType oXMLSequenceType, int n) throws XQException {
        this.setType(oXMLSequenceType);
        this.intValue = n;
        this.booleanValue = false;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 5) {
            throw new XQException("type error");
        }
    }

    public double getDouble() {
        return this.doubleValue;
    }

    public void setDouble(OXMLSequenceType oXMLSequenceType, double d) throws XQException {
        this.setType(oXMLSequenceType);
        this.doubleValue = d;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 4 && this.basicType != 3) {
            throw new XQException("type error");
        }
    }

    public BigDecimal getDecimal() {
        if (this.booleanValue) {
            return (BigDecimal)this.objValue;
        }
        return new BigDecimal((double)this.intValue);
    }

    public void setDecimal(OXMLSequenceType oXMLSequenceType, BigDecimal bigDecimal) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = bigDecimal;
        this.booleanValue = true;
        this.lexicalValue = null;
        this.nodeValue = null;
        if (this.basicType != 5) {
            throw new XQException("type error");
        }
    }

    public QName getQName() {
        return (QName)this.objValue;
    }

    public void setQName(OXMLSequenceType oXMLSequenceType, QName qName) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = qName;
        this.lexicalValue = null;
        this.nodeValue = null;
        if (this.basicType != 18) {
            throw new XQException("type error");
        }
    }

    private void setType(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (oXMLSequenceType == null) {
            throw new XQException("type error");
        }
        this.stype = oXMLSequenceType;
        int n = oXMLSequenceType.getPrimitiveId();
        this.basicType = n == 21 || n == 20 ? 6 : (n == 22 ? 5 : n);
    }

    static int getCase(int n, int n2, int n3) throws XQException {
        if (n3 > 2005 || n < 3 || n2 < 3 || n > 9 || n2 > 9) {
            throw new XQException("type error");
        }
        return opTable[n3 - 200][opComb[n - 3][n2 - 3]];
    }

    static {
        int n;
        castTable = new boolean[22][22];
        for (n = 0; n < 22; ++n) {
            for (int i = 0; i < 22; ++i) {
                OXMLItem.castTable[n][i] = false;
            }
        }
        for (n = 0; n < 22; ++n) {
            OXMLItem.castTable[n][n] = true;
            OXMLItem.castTable[0][n] = true;
            OXMLItem.castTable[n][0] = true;
            OXMLItem.castTable[n][1] = true;
            OXMLItem.castTable[1][n] = true;
        }
        OXMLItem.castTable[18][1] = false;
        OXMLItem.castTable[18][0] = false;
        OXMLItem.castTable[19][1] = false;
        OXMLItem.castTable[1][19] = false;
        OXMLItem.castTable[19][0] = false;
        OXMLItem.castTable[0][19] = false;
        OXMLItem.castTable[6][20] = true;
        OXMLItem.castTable[6][21] = true;
        OXMLItem.castTable[20][6] = true;
        OXMLItem.castTable[21][6] = true;
        OXMLItem.castTable[7][8] = true;
        OXMLItem.castTable[7][9] = true;
        OXMLItem.castTable[7][10] = true;
        OXMLItem.castTable[7][11] = true;
        OXMLItem.castTable[7][13] = true;
        OXMLItem.castTable[7][12] = true;
        OXMLItem.castTable[7][14] = true;
        OXMLItem.castTable[8][7] = true;
        OXMLItem.castTable[9][7] = true;
        OXMLItem.castTable[9][10] = true;
        OXMLItem.castTable[9][11] = true;
        OXMLItem.castTable[9][13] = true;
        OXMLItem.castTable[9][12] = true;
        OXMLItem.castTable[9][14] = true;
        OXMLItem.castTable[3][4] = true;
        OXMLItem.castTable[3][5] = true;
        OXMLItem.castTable[3][2] = true;
        OXMLItem.castTable[4][3] = true;
        OXMLItem.castTable[4][5] = true;
        OXMLItem.castTable[4][2] = true;
        OXMLItem.castTable[5][3] = true;
        OXMLItem.castTable[5][4] = true;
        OXMLItem.castTable[5][2] = true;
        OXMLItem.castTable[2][3] = true;
        OXMLItem.castTable[2][4] = true;
        OXMLItem.castTable[2][5] = true;
        OXMLItem.castTable[16][15] = true;
        OXMLItem.castTable[15][16] = true;
        opComb = new int[][]{{1, 2, 1, 0, 0, 0, 0}, {2, 2, 2, 0, 0, 0, 0}, {1, 2, 3, 4, 0, 0, 0}, {0, 0, 5, 6, 10, 14, 13}, {0, 0, 0, 9, 0, 0, 0}, {0, 0, 0, 11, 0, 8, 0}, {0, 0, 0, 12, 0, 0, 7}};
        opTable = new int[][]{{0, 1, 2, 3, 0, 0, 17, 0, 0, 23, 29, 27, 25, 30, 31}, {0, 4, 5, 6, 0, 0, 18, 21, 22, 24, 0, 28, 26, 0, 0}, {0, 7, 8, 9, 19, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 10, 11, 12, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 14, 15, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        compTable = new boolean[][]{{false, true, true, true, false, false}, {true, false, false, true, false, true}, {false, true, false, false, true, true}};
    }
}

