/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class BaseURI
extends OXMLFunction {
    private int numParams;

    BaseURI(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "base-uri";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.NODE_ZERO_OR_ONE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        String string = oXMLFunctionContext.getBaseURI();
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        if (string != null) {
            OXMLItem oXMLItem = oXMLFunctionContext.createItem();
            oXMLItem.setString(OXMLSequenceType.TSTRING, string);
            oXMLSequence.appendItem(oXMLItem);
        }
        return oXMLSequence;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            return oXMLSequence2;
        }
        String string = oXMLItem.getNode().getBaseURI();
        if (string != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, string);
            oXMLSequence2.appendItem(oXMLItem2);
        }
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        OXMLSequence oXMLSequence = oXMLSequenceArray.length == 0 ? this.invoke(oXMLFunctionContext) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
        return oXMLSequence;
    }
}

