/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.i18n.text.OraCollator;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Compare
extends OXMLFunction {
    private int numParams;

    Compare(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "compare";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(2, 22);
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0 || n == 1) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n == 2) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        String string = oXMLFunctionContext.getDefaultCollation();
        OraCollator oraCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        return this.compare(oXMLFunctionContext, oXMLSequence, oXMLSequence2, oraCollator);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 2: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
                break;
            }
            case 3: {
                OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequenceArray[2]);
                OraCollator oraCollator = FNUtil.getCollator(oXMLItem.getString(), oXMLFunctionContext.getDBCharSet());
                oXMLSequence = this.compare(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1], oraCollator);
            }
        }
        return oXMLSequence;
    }

    private OXMLSequence compare(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OraCollator oraCollator) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
            return oXMLSequence3;
        }
        OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
        if (oXMLItem2 == null) {
            OXMLSequence oXMLSequence4 = oXMLFunctionContext.createSequence();
            return oXMLSequence4;
        }
        int n = oraCollator.compare(oXMLItem.getString(), oXMLItem2.getString());
        n = n > 0 ? 1 : (n < 0 ? -1 : 0);
        OXMLSequence oXMLSequence5 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
        oXMLItem3.setInt(OXMLSequenceType.TINTEGER, n);
        oXMLSequence5.appendItem(oXMLItem3);
        return oXMLSequence5;
    }
}

