/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class EscapeURI
extends OXMLFunction {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    EscapeURI() {
    }

    public String getFunctionName() {
        return "escape-uri";
    }

    public int getNumberArgs() {
        return 2;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n == 1) {
            return OXMLSequenceType.TBOOLEAN;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence3.appendItem(oXMLItem2);
            return oXMLSequence3;
        }
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequence2);
        boolean bl = oXMLItem3.getBoolean();
        String string = oXMLItem.getString();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')' || c == '%' || c == '#') {
                stringBuffer.append(c);
                continue;
            }
            if (!(bl || c != ';' && c != '/' && c != '?' && c != ':' && c != '@' && c != '&' && c != '=' && c != '+' && c != '$' && c != ',' && c != '#' && c != '[' && c != ']')) {
                stringBuffer.append(c);
                continue;
            }
            try {
                byte[] byArray = null;
                if ((c & 0xFC00) == 55296 && i + 1 < n) {
                    byArray = new String(new char[]{c, string.charAt(i + 1)}).getBytes("UTF-8");
                    ++i;
                } else {
                    byArray = string.substring(i, i + 1).getBytes("UTF-8");
                }
                for (int j = 0; j < byArray.length; ++j) {
                    int n2 = byArray[j] & 0xFF;
                    stringBuffer.append('%');
                    stringBuffer.append(hexDigits[n2 >> 4 & 0xF]);
                    stringBuffer.append(hexDigits[n2 & 0xF]);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OXMLSequence oXMLSequence4 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem4 = oXMLFunctionContext.createItem();
        oXMLItem4.setString(OXMLSequenceType.TSTRING, stringBuffer.toString());
        oXMLSequence4.appendItem(oXMLItem4);
        return oXMLSequence4;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != 2) {
            throw new XQException("invalid number of parameters");
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
    }
}

