/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.GregorianCalendar;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNDateTimeSubtract
extends OXMLFunction {
    boolean isYearMonth;

    FNDateTimeSubtract(boolean bl) {
        this.isYearMonth = bl;
    }

    public String getFunctionName() {
        if (this.isYearMonth) {
            return "subtract-dateTimes-yielding-yearMonthDuration";
        }
        return "subtract-dateTimes-yielding-dayTimeDuration";
    }

    public int getNumberArgs() {
        return 2;
    }

    public OXMLSequenceType getReturnType() {
        if (this.isYearMonth) {
            return OXMLSequenceType.getConstantType(2, 20);
        }
        return OXMLSequenceType.getConstantType(2, 21);
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0 || n == 1) {
            return OXMLSequenceType.getConstantType(2, 7);
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
        if (oXMLItem != null && oXMLItem2 != null) {
            GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
            long l = gregorianCalendar.getTimeInMillis();
            gregorianCalendar = oXMLItem2.getCalendar();
            long l2 = l - gregorianCalendar.getTimeInMillis();
            OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            long l3 = l2 / 86400000L;
            long l4 = l2 - l3 * 86400000L;
            long l5 = l4 / 60000L;
            gregorianCalendar2.add(5, (int)l3);
            gregorianCalendar2.add(12, (int)l5);
            gregorianCalendar2.add(14, (int)(l4 %= 60000L));
            gregorianCalendar2.getTime();
            if (this.isYearMonth) {
                int n = (gregorianCalendar2.get(1) - gregorianCalendar.get(1)) * 12 + gregorianCalendar2.get(2) - gregorianCalendar.get(2);
                oXMLItem3.setDuration(this.getReturnType(), n, 0.0);
            } else {
                oXMLItem3.setDuration(this.getReturnType(), 0, (double)l2 / 1000.0);
            }
            oXMLSequence3.appendItem(oXMLItem3);
        }
        return oXMLSequence3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length == 2) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        throw new XQException("invalid number of parameters");
    }
}

