/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.builtIns.Avg;
import oracle.xml.xqxp.functions.builtIns.Boolean;
import oracle.xml.xqxp.functions.builtIns.Collection;
import oracle.xml.xqxp.functions.builtIns.Count;
import oracle.xml.xqxp.functions.builtIns.DeepEqual;
import oracle.xml.xqxp.functions.builtIns.DistinctNode;
import oracle.xml.xqxp.functions.builtIns.DistinctValue;
import oracle.xml.xqxp.functions.builtIns.Doc;
import oracle.xml.xqxp.functions.builtIns.Empty;
import oracle.xml.xqxp.functions.builtIns.Exists;
import oracle.xml.xqxp.functions.builtIns.ID;
import oracle.xml.xqxp.functions.builtIns.IDRef;
import oracle.xml.xqxp.functions.builtIns.IndexOf;
import oracle.xml.xqxp.functions.builtIns.Input;
import oracle.xml.xqxp.functions.builtIns.InsertBefore;
import oracle.xml.xqxp.functions.builtIns.ItemAt;
import oracle.xml.xqxp.functions.builtIns.Max;
import oracle.xml.xqxp.functions.builtIns.Min;
import oracle.xml.xqxp.functions.builtIns.NodeIdentical;
import oracle.xml.xqxp.functions.builtIns.One;
import oracle.xml.xqxp.functions.builtIns.OneOrMore;
import oracle.xml.xqxp.functions.builtIns.Remove;
import oracle.xml.xqxp.functions.builtIns.Reverse;
import oracle.xml.xqxp.functions.builtIns.Subsequence;
import oracle.xml.xqxp.functions.builtIns.Sum;
import oracle.xml.xqxp.functions.builtIns.Unordered;
import oracle.xml.xqxp.functions.builtIns.ZeroOrOne;

class FNSequences {
    static final int zero_or_one = 0;
    static final int one_or_more = 1;
    static final int exactly_one = 2;
    static final int Boolean = 3;
    static final int item_at = 4;
    static final int index_of = 5;
    static final int empty = 6;
    static final int exists = 7;
    static final int distinct_nodes = 8;
    static final int distinct_values = 9;
    static final int insert_before = 10;
    static final int remove = 11;
    static final int subsequence = 12;
    static final int unordered = 13;
    static final int deep_equal = 14;
    static final int sequence_node_identical = 15;
    static final int count = 16;
    static final int avg = 17;
    static final int max = 18;
    static final int min = 19;
    static final int sum = 20;
    static final int id = 21;
    static final int idref = 22;
    static final int doc = 23;
    static final int collection = 24;
    static final int input = 25;
    static final int reverse = 26;

    private FNSequences() {
    }

    static OXMLFunction getFunction(int n, int n2) {
        OXMLFunction oXMLFunction = null;
        switch (n) {
            case 0: {
                oXMLFunction = new ZeroOrOne();
                break;
            }
            case 1: {
                oXMLFunction = new OneOrMore();
                break;
            }
            case 2: {
                oXMLFunction = new One();
                break;
            }
            case 3: {
                oXMLFunction = new Boolean();
                break;
            }
            case 4: {
                oXMLFunction = new ItemAt();
                break;
            }
            case 5: {
                oXMLFunction = new IndexOf(n2);
                break;
            }
            case 6: {
                oXMLFunction = new Empty();
                break;
            }
            case 7: {
                oXMLFunction = new Exists();
                break;
            }
            case 8: {
                oXMLFunction = new DistinctNode();
                break;
            }
            case 9: {
                oXMLFunction = new DistinctValue(n2);
                break;
            }
            case 10: {
                oXMLFunction = new InsertBefore();
                break;
            }
            case 11: {
                oXMLFunction = new Remove();
                break;
            }
            case 12: {
                oXMLFunction = new Subsequence(n2);
                break;
            }
            case 13: {
                oXMLFunction = new Unordered();
                break;
            }
            case 14: {
                oXMLFunction = new DeepEqual(n2);
                break;
            }
            case 15: {
                oXMLFunction = new NodeIdentical();
                break;
            }
            case 16: {
                oXMLFunction = new Count();
                break;
            }
            case 17: {
                oXMLFunction = new Avg();
                break;
            }
            case 18: {
                oXMLFunction = new Max(n2);
                break;
            }
            case 19: {
                oXMLFunction = new Min(n2);
                break;
            }
            case 20: {
                oXMLFunction = new Sum(n2);
                break;
            }
            case 21: {
                oXMLFunction = new ID();
                break;
            }
            case 22: {
                oXMLFunction = new IDRef();
                break;
            }
            case 23: {
                oXMLFunction = new Doc();
                break;
            }
            case 24: {
                oXMLFunction = new Collection();
                break;
            }
            case 25: {
                oXMLFunction = new Input();
                break;
            }
            case 26: {
                oXMLFunction = new Reverse();
            }
        }
        return oXMLFunction;
    }
}

