/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNPatternMatch;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNTokenize
extends FNPatternMatch {
    boolean hasFlag;

    FNTokenize(boolean bl) {
        this.hasFlag = bl;
    }

    public String getFunctionName() {
        return "tokenize";
    }

    public int getNumberArgs() {
        if (this.hasFlag) {
            return 3;
        }
        return 2;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(3, 1);
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.getConstantType(2, 1);
        }
        if (n == 1 || n == 2 && this.hasFlag) {
            return OXMLSequenceType.getConstantType(1, 1);
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
        String string = "";
        if (oXMLItem != null) {
            string = oXMLItem.getString();
        }
        if (oXMLItem2 == null) {
            throw new XQException("exactly-one called with sequence containing zero or more than one item");
        }
        try {
            String[] stringArray = string.split(oXMLItem2.getString());
            for (int i = 0; i < stringArray.length; ++i) {
                OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
                oXMLItem3.setString(this.getReturnType(), stringArray[i]);
                oXMLSequence3.appendItem(oXMLItem3);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new XQException("invalid regurar expression");
        }
        return oXMLSequence3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length == 2) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        if (oXMLSequenceArray.length == 3) {
            OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[0]);
            OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[1]);
            OXMLItem oXMLItem3 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[2]);
            String string = "";
            if (oXMLItem != null) {
                string = oXMLItem.getString();
            }
            if (oXMLItem2 == null || oXMLItem3 == null) {
                throw new XQException("exactly-one called with sequence containing zero or more than one item");
            }
            try {
                Pattern pattern = Pattern.compile(oXMLItem2.getString(), FNTokenize.getFlag(oXMLItem3.getString()));
                String[] stringArray = pattern.split(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    OXMLItem oXMLItem4 = oXMLFunctionContext.createItem();
                    oXMLItem4.setString(this.getReturnType(), stringArray[i]);
                    oXMLSequence.appendItem(oXMLItem4);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XQException("invalid regurar expression");
            }
            return oXMLSequence;
        }
        throw new XQException("invalid number of parameters");
    }
}

