/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.HashMap;
import java.util.HashSet;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraCollator;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLNamespace;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FNUtil {
    static HashMap XDTTYPE = new HashMap(3);
    static OXMLSequenceType TNSTRING;
    static OXMLSequenceType TTOKEN;
    static OXMLSequenceType TLANGUAGE;
    static OXMLSequenceType TNMTOKEN;
    static OXMLSequenceType TNAME;
    static OXMLSequenceType TNCNAME;
    static OXMLSequenceType TID;
    static OXMLSequenceType TIDREF;
    static OXMLSequenceType TENTITY;
    static OXMLSequenceType TNPINTEGER;
    static OXMLSequenceType TNINTEGER;
    static OXMLSequenceType TLONG;
    static OXMLSequenceType TINT;
    static OXMLSequenceType TSHORT;
    static OXMLSequenceType TBYTE;
    static OXMLSequenceType TNNINTEGER;
    static OXMLSequenceType TULONG;
    static OXMLSequenceType TUINT;
    static OXMLSequenceType TUSHORT;
    static OXMLSequenceType TUBYTE;
    static OXMLSequenceType TPINTEGER;
    static HashMap XSDTYPE;
    public static final String CODEPOINT_COLLA = "http://www.w3.org/2003/11/xpath-functions/collation/codepoint";

    public static void main(String[] stringArray) {
        boolean bl = TPINTEGER.isOfType(OXMLSequenceType.TINTEGER);
        boolean bl2 = TLANGUAGE.isOfType(OXMLSequenceType.TSTRING);
        boolean bl3 = TUINT.isOfType(TSHORT);
        System.out.println(bl + " " + bl2 + " " + bl3);
    }

    static OXMLItem getSingleItem(OXMLSequence oXMLSequence) throws XQException {
        if (!oXMLSequence.next()) {
            throw new XQException("type exception");
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException("type exception");
        }
        return oXMLItem;
    }

    static OXMLItem getEmptyOrSingleItem(OXMLSequence oXMLSequence) throws XQException {
        if (!oXMLSequence.next()) {
            return null;
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException("type exception");
        }
        return oXMLItem;
    }

    public static Node getFirstElement(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static void checkCollation(String string) throws XQException {
        if (!string.equals(CODEPOINT_COLLA) && OraBoot.getInstance().getLinguisticFileName(string) == null) {
            throw new XQException("unsupported collation");
        }
    }

    public static OraCollator getCollator(String string, String string2) throws XQException {
        if (string == null || string.equals(CODEPOINT_COLLA)) {
            return OraCollator.getInstance((String)"BINARY", (String)"AL32UTF8");
        }
        try {
            return OraCollator.getInstance((String)string, (String)(string2 == null ? "AL32UTF8" : string2));
        }
        catch (Throwable throwable) {
            throw new XQException("unsupported collation");
        }
    }

    public static void checkSubstringCollation(String string) throws XQException {
        if (string != null && !string.equals(CODEPOINT_COLLA)) {
            throw new XQException("collation unsuitable for this function");
        }
    }

    static int getUNFMode(String string) throws XQException {
        if (string != null) {
            String string2 = string.trim().toUpperCase();
            if (string2.equals("NFC")) {
                return 1;
            }
            if (string2.equals("NFD")) {
                return 0;
            }
            if (string2.equals("NFKC")) {
                return 3;
            }
            if (string2.equals("NFKD")) {
                return 2;
            }
        }
        throw new XQException("unsupported normalization form");
    }

    private static QxName getQName(Node node) {
        String string = node.getNodeName();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        QxName qxName = null;
        qxName = n > 0 ? new QxName(node.getNamespaceURI(), string.substring(n + 1)) : new QxName("", string);
        return qxName;
    }

    public static QxName getNodeQName(Node node) {
        QxName qxName = null;
        switch (node.getNodeType()) {
            case 1: 
            case 2: {
                qxName = FNUtil.getQName(node);
                break;
            }
            case 7: {
                qxName = new QxName("", ((ProcessingInstruction)node).getTarget());
                break;
            }
            default: {
                if (!(node instanceof XSLNamespace)) break;
                String string = node.getNodeName();
                if (string.equals("xmlns")) {
                    qxName = new QxName("", "");
                    break;
                }
                if (!string.startsWith("xmlns:")) break;
                qxName = new QxName("", string.substring(6));
            }
        }
        return qxName;
    }

    private static String getLocalPart(Node node) {
        String string = node.getNodeName();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        String string2 = n > 0 ? string.substring(n + 1) : string;
        return string2;
    }

    static String getNodeName(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 3: 
            case 8: 
            case 9: {
                string = "";
                break;
            }
            case 7: {
                string = ((ProcessingInstruction)node).getTarget();
                break;
            }
            default: {
                string = node.getNodeName();
            }
        }
        return string;
    }

    static String getLocalName(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 3: 
            case 8: 
            case 9: {
                string = "";
                break;
            }
            case 7: {
                string = ((ProcessingInstruction)node).getTarget();
                break;
            }
            default: {
                string = FNUtil.getLocalPart(node);
            }
        }
        return string;
    }

    static String recGetAttribute(Node node, String string, String string2) {
        String string3 = null;
        if (node.getNodeType() == 1 && (string3 = ((Element)node).getAttributeNS(string, string2)) != null && string3.length() != 0) {
            return string3;
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            string3 = FNUtil.recGetAttribute(node2, string, string2);
        }
        return string3;
    }

    static Node getRoot(Node node) {
        Node node2 = node;
        Node node3 = FNUtil.getParentNode(node);
        if (node3 != null) {
            node2 = FNUtil.getRoot(node3);
        }
        return node2;
    }

    private static Node getParentNode(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public static boolean isNode(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() == 90;
    }

    public static boolean isUntypedAtomic(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() == 0;
    }

    private static boolean recEqualNode(Node node, Node node2) {
        int n;
        Node node3;
        Object object;
        String string;
        String string2 = FNUtil.getNodeKind(node);
        if (string2 != (string = FNUtil.getNodeKind(node2))) {
            return false;
        }
        QxName qxName = FNUtil.getNodeQName(node);
        QxName qxName2 = FNUtil.getNodeQName(node2);
        if (qxName != null && qxName2 != null && !qxName.equals(qxName2)) {
            return false;
        }
        if (string2 == "text" || string2 == "namespace" || string2 == "attribute") {
            return node.getNodeValue().equals(node2.getNodeValue());
        }
        if (string2 == "element") {
            NamedNodeMap namedNodeMap = node.getAttributes();
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            object = null;
            node3 = null;
            n = -1;
            if (namedNodeMap != null) {
                object = namedNodeMap;
                node3 = (Element)node2;
                n = namedNodeMap2 == null ? 0 : namedNodeMap2.getLength();
            } else if (namedNodeMap2 != null) {
                object = namedNodeMap2;
                node3 = (Element)node;
                n = 0;
            }
            if (object != null) {
                String string3;
                Object object2;
                int n2;
                int n3 = object.getLength();
                int n4 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    Attr attr = (Attr)object.item(n2);
                    object2 = attr.getNodeName();
                    if (((String)object2).equals("xmlns") || ((String)object2).startsWith("xmlns:")) continue;
                    ++n4;
                    string3 = node3.getAttribute((String)object2);
                    if (string3 != null && string3.equals(attr.getNodeValue())) continue;
                    return false;
                }
                n2 = 0;
                if (n != 0) {
                    for (int i = 0; i < n3; ++i) {
                        object2 = (Attr)namedNodeMap2.item(i);
                        string3 = object2.getNodeName();
                        if (string3.equals("xmlns") || string3.startsWith("xmlns:")) continue;
                        ++n2;
                    }
                }
                if (n4 != n2) {
                    return false;
                }
            }
        }
        if (string2 == "element" || string2 == "document") {
            boolean bl = node.hasChildNodes();
            boolean bl2 = node2.hasChildNodes();
            if (bl && bl2) {
                object = node.getFirstChild();
                node3 = node2.getFirstChild();
                n = 0;
                do {
                    if (!FNUtil.recEqualNode((Node)object, node3)) {
                        return false;
                    }
                    object = object.getNextSibling();
                    node3 = node3.getNextSibling();
                } while (object != null && node3 != null);
                if (object != null || node3 != null) {
                    return false;
                }
            } else if (bl || bl2) {
                return false;
            }
        }
        return true;
    }

    static boolean isEqualNode(Node node, Node node2) {
        String string = FNUtil.getNodeKind(node);
        boolean bl = FNUtil.recEqualNode(node, node2);
        if (string == "comment" || string == "processing-instruction") {
            bl = node.getNodeValue().equals(node2.getNodeValue());
        }
        return bl;
    }

    static String getNodeKind(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 1: {
                string = "element";
                break;
            }
            case 8: {
                string = "comment";
                break;
            }
            case 7: {
                string = "processing-instruction";
                break;
            }
            case 9: {
                string = "document";
                break;
            }
            case 3: 
            case 4: {
                string = "text";
                break;
            }
            case 2: {
                String string2 = node.getNodeName();
                string = string2.startsWith("xmlns:") || string2.equals("xmlns") ? "namespace" : "attribute";
            }
        }
        return string;
    }

    static String getNamespaceURI(String string, Element element) {
        String string2;
        String string3;
        int n = string == null ? 0 : string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 6);
        stringBuffer.append("xmlns");
        if (n != 0) {
            stringBuffer.append(':').append(string);
        }
        if ((string3 = element.getAttribute(string2 = stringBuffer.toString())) != null && string3.length() != 0) {
            return string3;
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            String string4;
            if (node.getNodeType() != 1 || (string4 = ((Element)node).getAttribute(string2)) == null || string4.length() == 0) continue;
            return string4;
        }
        return null;
    }

    static void getPrefixes(Node node, HashSet hashSet) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            FNUtil.getPrefixes(node.getParentNode(), hashSet);
            return;
        }
        Element element = (Element)node;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNodeName();
            if (string.equals("xmlns")) {
                hashSet.add("");
                continue;
            }
            if (!string.startsWith("xmlns:")) continue;
            hashSet.add(string.substring(6));
        }
        FNUtil.getPrefixes(node.getParentNode(), hashSet);
    }

    public static int compareNodeOrder(XMLNode xMLNode, XMLNode xMLNode2) {
        short s = xMLNode.compareDocumentPosition(xMLNode2);
        int n = -1;
        switch (s) {
            case 2: 
            case 8: 
            case 10: {
                n = 1;
                break;
            }
            case 4: 
            case 16: 
            case 20: {
                n = -1;
                break;
            }
            case 0: {
                n = 0;
            }
        }
        return n;
    }

    static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static {
        XDTTYPE.put("yearMonthDuration", OXMLSequenceType.TYMDURATION);
        XDTTYPE.put("dayTimeDuration", OXMLSequenceType.TDTDURATION);
        XDTTYPE.put("untypedAtomic", OXMLSequenceType.TUNTYPED);
        TNSTRING = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "normalizedString"), 1);
        TTOKEN = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "token"), 1);
        TLANGUAGE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "language"), 1);
        TNMTOKEN = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NMTOKEN"), 1);
        TNAME = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "Name"), 1);
        TNCNAME = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NCName"), 1);
        TID = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ID"), 1);
        TIDREF = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "IDREF"), 1);
        TENTITY = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ENTITY"), 1);
        TNPINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger"), 1);
        TNINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "negativeInteger"), 1);
        TLONG = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "long"), 1);
        TINT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "int"), 1);
        TSHORT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "short"), 1);
        TBYTE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "byte"), 1);
        TNNINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger"), 1);
        TULONG = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedLong"), 1);
        TUINT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedInt"), 1);
        TUSHORT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedShort"), 1);
        TUBYTE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedByte"), 1);
        TPINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), 1);
        XSDTYPE = new HashMap(43);
        XSDTYPE.put("string", OXMLSequenceType.TSTRING);
        XSDTYPE.put("boolean", OXMLSequenceType.TBOOLEAN);
        XSDTYPE.put("decimal", OXMLSequenceType.TDECIMAL);
        XSDTYPE.put("float", OXMLSequenceType.TFLOAT);
        XSDTYPE.put("double", OXMLSequenceType.TDOUBLE);
        XSDTYPE.put("QName", OXMLSequenceType.TQNAME);
        XSDTYPE.put("duration", OXMLSequenceType.TDURATION);
        XSDTYPE.put("dateTime", OXMLSequenceType.TDATETIME);
        XSDTYPE.put("time", OXMLSequenceType.TTIME);
        XSDTYPE.put("date", OXMLSequenceType.TDATE);
        XSDTYPE.put("gYearMonth", OXMLSequenceType.TGYEARMONTH);
        XSDTYPE.put("gYear", OXMLSequenceType.TGYEAR);
        XSDTYPE.put("gMonthDay", OXMLSequenceType.TGMONTHDAY);
        XSDTYPE.put("gDay", OXMLSequenceType.TGDAY);
        XSDTYPE.put("gMonth", OXMLSequenceType.TGMONTH);
        XSDTYPE.put("hexBinary", OXMLSequenceType.THEXBINARY);
        XSDTYPE.put("base64Binary", OXMLSequenceType.TBASE64BINARY);
        XSDTYPE.put("anyURI", OXMLSequenceType.TANYURI);
        XSDTYPE.put("normalizedString", TNSTRING);
        XSDTYPE.put("token", TTOKEN);
        XSDTYPE.put("language", TLANGUAGE);
        XSDTYPE.put("NMTOKEN", TNMTOKEN);
        XSDTYPE.put("Name", TNAME);
        XSDTYPE.put("NCName", TNCNAME);
        XSDTYPE.put("ID", TID);
        XSDTYPE.put("IDREF", TIDREF);
        XSDTYPE.put("ENTITY", TENTITY);
        XSDTYPE.put("integer", OXMLSequenceType.TINTEGER);
        XSDTYPE.put("nonPositiveInteger", TNPINTEGER);
        XSDTYPE.put("negativeInteger", TNINTEGER);
        XSDTYPE.put("long", TLONG);
        XSDTYPE.put("int", TINT);
        XSDTYPE.put("short", TSHORT);
        XSDTYPE.put("byte", TBYTE);
        XSDTYPE.put("nonNegativeInteger", TNNINTEGER);
        XSDTYPE.put("unsignedLong", TULONG);
        XSDTYPE.put("unsignedInt", TUINT);
        XSDTYPE.put("unsignedShort", TUSHORT);
        XSDTYPE.put("unsignedByte", TUBYTE);
        XSDTYPE.put("positiveInteger", TPINTEGER);
    }
}

