/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class IndexOf
extends OXMLFunction {
    private int numParams;

    IndexOf(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "index-of";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(4, 22);
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE;
        }
        if (n == 1) {
            return OXMLSequenceType.ANYATOMIC_ONE;
        }
        if (n == 2) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        int n = 1;
        while (oXMLSequence.next()) {
            OXMLItem oXMLItem2 = oXMLSequence.getItem();
            if (oXMLItem2.compareValue(oXMLItem) == 0) {
                OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
                oXMLItem3.setInt(OXMLSequenceType.TINTEGER, n);
                oXMLSequence3.appendItem(oXMLItem3);
            }
            ++n;
        }
        return oXMLSequence3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        if (oXMLSequenceArray.length == 3) {
            OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequenceArray[2]);
            FNUtil.checkSubstringCollation(oXMLItem.getString());
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
    }
}

