/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.i18n.text.OraCollator;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xml.xqxp.functions.builtIns.Max;

class Min
extends OXMLFunction {
    private int numParams;

    Min(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "min";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE;
        }
        if (n == 1) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        OraCollator oraCollator = FNUtil.getCollator(oXMLItem.getString(), oXMLFunctionContext.getDBCharSet());
        return this.min(oXMLFunctionContext, oXMLSequence, oraCollator);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        String string = oXMLFunctionContext.getDefaultCollation();
        OraCollator oraCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        return this.min(oXMLFunctionContext, oXMLSequence, oraCollator);
    }

    private OXMLSequence min(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OraCollator oraCollator) throws XQException {
        Max max = (Max)FNFunctionLibrary.getInstance().getFunction("max", 1);
        OXMLItem oXMLItem = max.compare(oXMLFunctionContext, oXMLSequence, 212, oraCollator);
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        if (oXMLItem != null) {
            oXMLSequence2.appendItem(oXMLItem);
        }
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
                break;
            }
            case 2: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
            }
        }
        return oXMLSequence;
    }
}

