/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.i18n.text.OraNormalizer;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class NormalizeUnicode
extends OXMLFunction {
    private int numParams;

    NormalizeUnicode(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "normalize-unicode";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n == 1) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence3.appendItem(oXMLItem2);
            return oXMLSequence3;
        }
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequence2);
        int n = FNUtil.getUNFMode(oXMLItem3.getString());
        return this.normalize(oXMLFunctionContext, oXMLItem, n);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        return this.normalize(oXMLFunctionContext, oXMLItem, FNUtil.getUNFMode("NFC"));
    }

    private OXMLSequence normalize(OXMLFunctionContext oXMLFunctionContext, OXMLItem oXMLItem, int n) throws XQException {
        String string = null;
        string = oXMLItem == null ? "" : OraNormalizer.getInstance().normalize(oXMLItem.getString(), n);
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence.appendItem(oXMLItem2);
        return oXMLSequence;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
                break;
            }
            case 2: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
            }
        }
        return oXMLSequence;
    }
}

