/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Number
extends OXMLFunction {
    private int numParams;

    Number(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "number";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TDOUBLE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.ITEM_ZERO_OR_ONE;
        }
        return null;
    }

    private OXMLItem number(OXMLFunctionContext oXMLFunctionContext, OXMLItem oXMLItem) throws XQException {
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        if (FNUtil.isNode(oXMLItem)) {
            String string = oXMLItem.getLexicalValue();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, string);
        } else {
            oXMLItem2.copyItem(oXMLItem);
        }
        try {
            oXMLItem2.convert(OXMLSequenceType.TDOUBLE);
        }
        catch (XQException xQException) {
            oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, Double.NaN);
        }
        return oXMLItem2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        OXMLItem oXMLItem = oXMLFunctionContext.getContextItem();
        OXMLItem oXMLItem2 = null;
        if (oXMLItem == null) {
            oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, Double.NaN);
        } else {
            oXMLItem2 = this.number(oXMLFunctionContext, oXMLItem);
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        oXMLSequence.appendItem(oXMLItem2);
        return oXMLSequence;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        OXMLItem oXMLItem2 = null;
        if (oXMLItem == null) {
            oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, Double.NaN);
        } else {
            oXMLItem2 = this.number(oXMLFunctionContext, oXMLItem);
        }
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        oXMLSequence2.appendItem(oXMLItem2);
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        OXMLSequence oXMLSequence = oXMLSequenceArray.length == 0 ? this.invoke(oXMLFunctionContext) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
        return oXMLSequence;
    }
}

