/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class StringLength
extends OXMLFunction {
    private int numParams;

    StringLength(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "string-length";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TINTEGER;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        int n = -1;
        n = oXMLItem == null ? 0 : oXMLItem.getString().length();
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setInt(OXMLSequenceType.TINTEGER, n);
        oXMLSequence2.appendItem(oXMLItem2);
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        OXMLSequence oXMLSequence = FNFunctionLibrary.getInstance().getFunction("string", 0).invoke(oXMLFunctionContext);
        return this.invoke(oXMLFunctionContext, oXMLSequence);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 0: {
                oXMLSequence = this.invoke(oXMLFunctionContext);
                break;
            }
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
            }
        }
        return oXMLSequence;
    }
}

