/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Sum
extends OXMLFunction {
    private int numParams;

    Sum(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "sum";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        if (this.numParams == 1) {
            return OXMLSequenceType.ANYATOMIC_ONE;
        }
        return OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE;
        }
        if (n == 1) {
            return OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE;
        }
        return null;
    }

    int sum(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLItem oXMLItem) throws XQException {
        OXMLItem oXMLItem2;
        int n = 0;
        if (!oXMLSequence.next()) {
            return n;
        }
        OXMLItem oXMLItem3 = oXMLSequence.getItem();
        if (FNUtil.isUntypedAtomic(oXMLItem3)) {
            oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.copyItem(oXMLItem3);
            oXMLItem2.convert(OXMLSequenceType.TDOUBLE);
            oXMLItem3 = oXMLItem2;
        }
        ++n;
        while (oXMLSequence.next()) {
            oXMLItem2 = oXMLSequence.getItem();
            ++n;
            if (FNUtil.isUntypedAtomic(oXMLItem2)) {
                OXMLItem oXMLItem4 = oXMLFunctionContext.createItem();
                oXMLItem4.copyItem(oXMLItem2);
                oXMLItem4.convert(OXMLSequenceType.TDOUBLE);
                oXMLItem2 = oXMLItem4;
            }
            try {
                oXMLItem2.arithmetic(oXMLItem3, 200, oXMLItem3);
            }
            catch (XQException xQException) {
                throw new XQException("invalid argument to aggregate function");
            }
        }
        oXMLItem.copyItem(oXMLItem3);
        return n;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = oXMLFunctionContext.createItem();
        int n = this.sum(oXMLFunctionContext, oXMLSequence, oXMLItem);
        if (n == 0) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, 0.0);
            oXMLSequence2.appendItem(oXMLItem2);
        } else {
            oXMLSequence2.appendItem(oXMLItem);
        }
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = oXMLFunctionContext.createItem();
        int n = this.sum(oXMLFunctionContext, oXMLSequence, oXMLItem);
        if (n == 0) {
            OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
            if (oXMLItem2 != null) {
                oXMLSequence3.appendItem(oXMLItem2);
            }
        } else {
            oXMLSequence3.appendItem(oXMLItem);
        }
        return oXMLSequence3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("invalid number of parameters");
        }
        return oXMLSequenceArray.length == 1 ? this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
    }
}

