/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.parser.v2.NSName;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;

public class XSLOutput
extends XSLNode
implements XSLConstants {
    String method;
    String version;
    String encoding;
    String standalone;
    String mediaType;
    int indent;
    int omitXMLDecl;
    boolean ignoreOmitXMLDecl;
    String doctypePublic;
    String doctypeSystem;
    Hashtable cdataSectionElements;
    boolean isChMapped = false;
    HashMap mappings;
    NSName name2;
    boolean ict = true;
    boolean eua = true;
    boolean normunicode = false;
    static String INCLUDE_CONTENT_TYPE = "include-content-type";
    static String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    static String NORMALIZE_UNICODE = "normalize-unicode";
    String oraHref;
    String oraName;
    boolean oraOmitXMLEncoding;
    Hashtable outProps;
    static String HTML = "html";
    static String XML = "xml";
    static String TEXT = "text";
    static String XHTML = "xhtml";
    static String YES = "yes";
    static String NO = "no";
    static String ORAHREF = "href";
    static String OMIT_XML_ENCODING = "omit-xml-encoding";
    Properties m_props;
    Properties m_defaultProps;

    public XSLOutput(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
        this.initialize();
    }

    void initialize() {
        this.method = "";
        this.version = "";
        this.encoding = "";
        this.standalone = "";
        this.mediaType = "";
        this.doctypePublic = "";
        this.doctypeSystem = "";
        this.outProps = new Hashtable(20);
        this.omitXMLDecl = -1;
        this.ignoreOmitXMLDecl = false;
        this.indent = -1;
        this.name2 = null;
        this.ict = true;
        this.eua = true;
        this.normunicode = false;
        this.oraName = "";
        this.oraOmitXMLEncoding = false;
        this.m_defaultProps = new Properties();
        this.m_props = new Properties(this.m_defaultProps);
        JXUtil.setDefaultProps(this.m_defaultProps, XML);
    }

    boolean isCDATASectionElement() {
        return this.cdataSectionElements != null;
    }

    boolean checkCDATASectionElement(String string) {
        if (this.cdataSectionElements == null) {
            return false;
        }
        return this.cdataSectionElements.get(string) != null;
    }

    String getOraHref() {
        return this.oraHref;
    }

    void setOraHref(String string) {
        this.oraHref = string;
    }

    boolean getOraOmitXMLEncoding() {
        return this.oraOmitXMLEncoding;
    }

    void setOraOmitXMLEncoding(boolean bl) {
        this.oraOmitXMLEncoding = bl;
    }

    NSName getName2() {
        return this.name2;
    }

    String getName() {
        return this.oraName;
    }

    void setName(String string) {
        this.oraName = string;
    }

    String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    String getVersion() {
        if (this.version == "") {
            if (this.method == HTML) {
                this.version = "4.0";
            } else if (this.method != "") {
                this.version = "1.0";
            } else {
                return "1.0";
            }
        }
        return this.version;
    }

    boolean isEncodingSpecified() {
        return this.encoding != "";
    }

    String getEncoding() {
        if (this.encoding == "") {
            return "UTF-8";
        }
        return this.encoding;
    }

    String getStandalone() {
        return this.standalone;
    }

    boolean getOmitXMLDecl() {
        if (this.omitXMLDecl == -1) {
            this.omitXMLDecl = this.method == XML || this.method == "" ? 0 : 1;
        }
        return this.omitXMLDecl == 1;
    }

    String getDoctypePublic() {
        return this.doctypePublic;
    }

    String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    boolean getIndent() {
        if (this.indent == -1) {
            if (this.method == XML || this.method == "") {
                this.indent = 0;
            } else if (this.method == HTML) {
                this.indent = 1;
            }
        }
        return this.indent == 1;
    }

    String getMediaType() {
        if (this.mediaType == "") {
            if (this.method == HTML) {
                this.mediaType = "text/html";
            } else if (this.method == TEXT) {
                this.mediaType = "text/plain";
            } else if (this.method == XHTML) {
                this.mediaType = "text/html";
            } else if (this.method != "") {
                this.mediaType = "text/xml";
            } else {
                return "text/xml";
            }
        }
        return this.mediaType;
    }

    boolean getIncludeContentType() {
        return this.ict;
    }

    boolean getEscapeURIAttributes() {
        return this.eua;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            this.outProps.put(string3, string4);
        } else {
            super.setAttribute(string, string2, string3, string4);
        }
    }

    public String getAttribute(String string, String string2) throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            return (String)this.outProps.get(string2);
        }
        return super.getAttribute(string, string2);
    }

    public void startContent() throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            if (this.getAttribute("", "name") == null) {
                this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
            }
            if (this.getAttribute("", ORAHREF) == null) {
                this.xss.err.error2(1009, 2, "href", this.getQualifiedName());
            }
        }
    }

    void merge(XSLOutput xSLOutput) throws XSLException {
        Object object;
        String string = xSLOutput.getAttribute("", "name");
        if (string != null) {
            this.name2 = this.resolveQname(string);
        }
        if ((string = xSLOutput.getAttribute("", "method")) != null) {
            this.method = string.intern();
            this.m_props.put("method", this.method);
            JXUtil.setDefaultProps(this.m_defaultProps, this.method);
        }
        if ((string = xSLOutput.getAttribute("", "version")) != null) {
            this.version = string;
            this.m_props.put("version", this.version);
        }
        if ((string = xSLOutput.getAttribute("", "encoding")) != null) {
            this.encoding = string;
            if (!(this.xss.getXSLTVersion() < 20 || this.encoding.equalsIgnoreCase("UTF-8") || this.encoding.equalsIgnoreCase("UTF-16") || this.ignoreOmitXMLDecl)) {
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
            }
            this.m_props.put("encoding", this.encoding);
        }
        if ((string = xSLOutput.getAttribute("", "standalone")) != null) {
            this.standalone = string;
            if (this.xss.getXSLTVersion() >= 20 && !this.ignoreOmitXMLDecl) {
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
            }
            this.m_props.put("standalone", this.standalone);
        }
        if ((string = xSLOutput.getAttribute("", "media-type")) != null) {
            this.mediaType = string;
            this.m_props.put("media-type", this.mediaType);
        }
        if ((string = xSLOutput.getAttribute("", "doctype-public")) != null) {
            this.doctypePublic = string;
            this.m_props.put("doctype-public", this.doctypePublic);
        }
        if ((string = xSLOutput.getAttribute("", "doctype-system")) != null) {
            this.doctypeSystem = string;
            this.m_props.put("doctype-system", this.doctypeSystem);
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            this.oraHref = xSLOutput.getAttribute("", ORAHREF);
            this.oraName = xSLOutput.getAttribute("", "name");
            if (this.oraName == null) {
                this.oraName = "";
            }
        }
        if ((string = xSLOutput.getAttribute("", "indent")) != null) {
            this.m_props.put("indent", string);
            if (string.equals("yes")) {
                this.indent = 1;
            } else if (string.equals("no")) {
                this.indent = 0;
            }
        }
        if ((string = xSLOutput.getAttribute("", "omit-xml-declaration")) != null) {
            this.m_props.put("omit-xml-declaration", string);
            if (!this.ignoreOmitXMLDecl) {
                if (string.equals("yes")) {
                    this.omitXMLDecl = 1;
                } else if (string.equals("no")) {
                    this.omitXMLDecl = 0;
                }
            }
        }
        if ((string = xSLOutput.getAttribute("", OMIT_XML_ENCODING)) != null) {
            this.m_props.put(OMIT_XML_ENCODING, string);
            if (string.equals("yes")) {
                this.oraOmitXMLEncoding = true;
            } else if (string.equals("no")) {
                this.oraOmitXMLEncoding = false;
            }
        }
        if (this.xss.getXSLTVersion() == 10) {
            this.ict = true;
            this.normunicode = false;
            this.eua = false;
        } else if (this.xss.getXSLTVersion() >= 20) {
            string = xSLOutput.getAttribute("", INCLUDE_CONTENT_TYPE);
            if (string != null && string.equals("no")) {
                this.ict = false;
            }
            if ((string = xSLOutput.getAttribute("", NORMALIZE_UNICODE)) != null && string.equals("yes")) {
                this.normunicode = true;
            }
            if ((string = xSLOutput.getAttribute("", ESCAPE_URI_ATTRIBUTES)) != null && string.equals("no")) {
                this.eua = false;
            }
            if ((string = xSLOutput.getAttribute("", "use-character-maps")) != null) {
                int n;
                this.xss.expandedCharacterMaps = null;
                object = this.processUseCharacterMaps(string);
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    this.xss.getCharacterMap((NSName)((Vector)object).get(n));
                }
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    this.xss.expandedCharacterMaps.add(((Vector)object).get(n));
                }
                Properties properties = this.xss.mergeCharacterMap();
                this.isChMapped = true;
                this.makeCharacterMap(properties);
            }
        }
        object = xSLOutput.getAttribute("", "cdata-section-elements");
        if (object != null) {
            this.m_props.put("cdata-section-elements", object);
            this.processCdataSectionElement((String)object, xSLOutput, true);
        }
    }

    private Vector processUseCharacterMaps(String string) throws XSLException {
        Vector<NSName> vector = new Vector<NSName>(5, 5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            NSName nSName = this.resolveQname(string2);
            vector.add(nSName);
        }
        return vector;
    }

    private void makeCharacterMap(Properties properties) {
        int n = properties.size();
        char[] cArray = new char[n];
        String[] stringArray = new String[n];
        Enumeration<?> enumeration = properties.propertyNames();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            cArray[n2] = string.toCharArray()[0];
            stringArray[n2++] = (String)properties.get(string);
        }
        this.mappings = new HashMap(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.mappings.put(new Character(cArray[n2]), stringArray[n2]);
        }
    }

    boolean isCharacterMapped() {
        return this.isChMapped;
    }

    HashMap getMappings() {
        return this.mappings;
    }

    boolean isNormalizeUnicode() {
        return this.normunicode;
    }

    private void processCdataSectionElement(String string, XSLOutput xSLOutput, boolean bl) throws XSLException {
        int n = 0;
        int n2 = 0;
        do {
            String string2 = (n2 = string.indexOf(32, n)) == -1 ? string.substring(n, string.length()) : string.substring(n, n2);
            n = n2 + 1;
            String string3 = xSLOutput.resolveQname(string2).getExpandedName();
            if (this.cdataSectionElements == null) {
                this.cdataSectionElements = new Hashtable(20);
            }
            if (bl) {
                this.cdataSectionElements.put(string3, string3);
                continue;
            }
            Object v = this.cdataSectionElements.get(string3);
            if (v != null && v.toString().equals(string3)) continue;
            this.cdataSectionElements.put(string3, string3);
        } while (n2 != -1);
    }

    void printAttributes(PrintWriter printWriter) {
        super.printAttributes(printWriter);
        Hashtable hashtable = this.attrHash;
        this.attrHash = this.outProps;
        super.printAttributes(printWriter);
        this.attrHash = hashtable;
    }

    public Properties getDefaultProps() {
        return this.m_defaultProps;
    }

    public Properties getProps() {
        return this.m_props;
    }

    public void setProps(Properties properties) {
        this.m_props = properties;
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement().toString();
            if (string2.equals("method")) {
                this.method = this.m_props.getProperty("method");
                if (this.method != null) {
                    this.method = this.method.intern();
                    JXUtil.setDefaultProps(this.m_defaultProps, this.method);
                    continue;
                }
                this.method = "";
                continue;
            }
            if (string2.equals("version")) {
                this.version = this.m_props.getProperty("version");
                if (this.version != null) {
                    this.version = this.version.intern();
                    continue;
                }
                this.version = "";
                continue;
            }
            if (string2.equals("encoding")) {
                this.encoding = (String)this.m_props.get("encoding");
                this.encoding = this.encoding != null ? this.encoding.intern() : "";
                if (this.xss.getXSLTVersion() < 20 || this.encoding.equalsIgnoreCase("UTF-8") || this.encoding.equalsIgnoreCase("UTF-16") || this.ignoreOmitXMLDecl) continue;
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
                continue;
            }
            if (string2.equals("standalone")) {
                this.standalone = this.m_props.getProperty("standalone");
                if (this.standalone != null) {
                    this.standalone = this.standalone.intern();
                    if (this.xss.getXSLTVersion() < 20 || this.ignoreOmitXMLDecl) continue;
                    this.omitXMLDecl = 0;
                    this.ignoreOmitXMLDecl = true;
                    continue;
                }
                this.standalone = "";
                continue;
            }
            if (string2.equals("media-type")) {
                this.mediaType = this.m_props.getProperty("media-type");
                if (this.mediaType != null) {
                    this.mediaType = this.mediaType.intern();
                    continue;
                }
                this.mediaType = "";
                continue;
            }
            if (string2.equals("doctype-public")) {
                this.doctypePublic = this.m_props.getProperty("doctype-public");
                if (this.doctypePublic != null) {
                    this.doctypePublic = this.doctypePublic.intern();
                    continue;
                }
                this.doctypePublic = "";
                continue;
            }
            if (string2.equals("doctype-system")) {
                this.doctypeSystem = this.m_props.getProperty("doctype-system");
                if (this.doctypeSystem != null) {
                    this.doctypeSystem = this.doctypeSystem.intern();
                    continue;
                }
                this.doctypeSystem = "";
                continue;
            }
            if (string2.equals("indent")) {
                string = this.m_props.getProperty("indent");
                if (string == null) continue;
                if ((string = string.intern()) == "yes") {
                    this.indent = 1;
                    continue;
                }
                if (string != "no") continue;
                this.indent = 0;
                continue;
            }
            if (string2.equals("omit-xml-declaration")) {
                string = this.m_props.getProperty("omit-xml-declaration");
                if (string == null) continue;
                string = string.intern();
                if (this.ignoreOmitXMLDecl) continue;
                if (string == "yes") {
                    this.omitXMLDecl = 1;
                    continue;
                }
                if (string != "no") continue;
                this.omitXMLDecl = 0;
                continue;
            }
            if (!string2.equals("cdata-section-elements")) continue;
            string = this.m_props.getProperty("cdata-section-elements");
            try {
                if (string == null) continue;
                this.processCdataSectionElement(string, this, false);
            }
            catch (XSLException xSLException) {}
        }
    }
}

