/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XSLExtensionElement;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLElement;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public class XSLResultElement
extends XSLNode
implements XSLConstants {
    private QxName qxname;
    private FastVector attrPrefixVec;
    private FastVector attrLocalNameVec;
    private FastVector attrNamespaceVec;
    private FastVector attrValueVec;
    private FastVector nsKeyVec;
    private FastVector nsValVec;
    private String oraOutputName;
    private XSLNode.AttrValueTmpl oraOutputHrefVal;
    private XSLOutput oraXSLOutput;
    private XSLExtensionElement extElem;

    XSLResultElement(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 7;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        String string = this.xss.getNamespaceAlias(this.namespace);
        if (xSLTContext.isInDebugMode()) {
            if (string != null) {
                this.addJDWPDataBefore(xSLTContext, this, string + ":" + this.localName, "", (byte)-1);
            } else {
                this.addJDWPDataBefore(xSLTContext, this, this.localName, "", (byte)-1);
            }
        }
        this.setContextBaseURL(xSLTContext);
        if (this.extElem != null) {
            this.extElem.setXSLNode(this);
            try {
                this.extElem.processAction(xSLTContext);
            }
            catch (oracle.xml.parser.v2.XSLException xSLException) {
                throw (XSLException)xSLException;
            }
            return;
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output") {
            this.processOraOutput(xSLTContext);
            return;
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        xSLEventHandler.startElement(this.qxname);
        this.processAttrSets(xSLTContext);
        if (this.attrPrefixVec != null) {
            int n = this.attrPrefixVec.size();
            for (int i = 0; i < n; ++i) {
                XSLNode.AttrValueTmpl attrValueTmpl = (XSLNode.AttrValueTmpl)this.attrValueVec.elementAt(i);
                String string2 = (String)this.attrNamespaceVec.elementAt(i);
                String string3 = this.xss.getNamespaceAlias(string2);
                if (string3 == null) {
                    string3 = string2;
                }
                xSLEventHandler.attribute((String)this.attrPrefixVec.elementAt(i), (String)this.attrLocalNameVec.elementAt(i), string3, attrValueTmpl.getValue(xSLTContext));
            }
        }
        if (this.nsKeyVec != null) {
            int n = this.nsKeyVec.size();
            for (int i = 0; i < n; ++i) {
                xSLEventHandler.namespaceAttr((String)this.nsKeyVec.elementAt(i), (String)this.nsValVec.elementAt(i));
            }
        }
        if (xSLTContext.isInDebugMode() && !this.hasAttributeInsChild() && !this.isXSLMessageChildren()) {
            this.flushPartialOutput(xSLEventHandler, xSLTContext.getJDWPContentHandler());
        }
    }

    void processOraOutput(XSLTContext xSLTContext) throws XSLException, XQException {
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        String string = "";
        try {
            Object object;
            string = this.oraOutputHrefVal.getValue(xSLTContext);
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null && !((File)(object = new File(string2))).exists()) {
                ((File)object).mkdirs();
            }
            object = new FileOutputStream(file);
            XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver((OutputStream)object, this.oraXSLOutput);
            XSLEventHandler xSLEventHandler2 = new XSLEventHandler(xSLSAXPrintDriver, xSLSAXPrintDriver, xSLTContext);
            xSLTContext.setEventHandler(xSLEventHandler2);
            this.processChildren(xSLTContext);
            xSLSAXPrintDriver.flush();
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error1(1003, 1, string);
        }
        xSLTContext.setEventHandler(xSLEventHandler);
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output") {
            if (string == "") {
                if (string3 == "use") {
                    this.oraOutputName = string4;
                } else if (string3 == "href") {
                    this.oraOutputHrefVal = new XSLNode.AttrValueTmpl(string4, this);
                }
            }
            return;
        }
        if (string != "http://www.w3.org/1999/XSL/Transform") {
            if (this.attrPrefixVec == null) {
                this.attrPrefixVec = new FastVector();
                this.attrLocalNameVec = new FastVector();
                this.attrNamespaceVec = new FastVector();
                this.attrValueVec = new FastVector();
            }
            this.attrPrefixVec.addElement(string2);
            this.attrLocalNameVec.addElement(string3);
            this.attrNamespaceVec.addElement(string);
            this.attrValueVec.addElement(new XSLNode.AttrValueTmpl(string4, this));
        } else if (string3 == "exclude-result-prefixes") {
            this.addResultPrefixes(string4);
        } else if (string3 == "extension-element-prefixes") {
            this.xss.addExtensionNamespace(this, string4);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    public String getAttributeValue(String string, String string2) {
        XSLNode.AttrValueTmpl attrValueTmpl = this.getAttrTmpl(string, string2);
        if (attrValueTmpl != null) {
            return attrValueTmpl.getAttrValue();
        }
        return null;
    }

    public String getAttributeTemplateValue(XSLTContext xSLTContext, String string, String string2) throws XSLException, XQException {
        XSLNode.AttrValueTmpl attrValueTmpl = this.getAttrTmpl(string, string2);
        if (attrValueTmpl != null) {
            return attrValueTmpl.getValue(xSLTContext);
        }
        return null;
    }

    XSLNode.AttrValueTmpl getAttrTmpl(String string, String string2) {
        if (this.attrLocalNameVec != null) {
            int n = this.attrLocalNameVec.size();
            for (int i = 0; i < n; ++i) {
                if (!this.attrLocalNameVec.elementAt(i).equals(string2) || !this.attrNamespaceVec.elementAt(i).equals(string)) continue;
                return (XSLNode.AttrValueTmpl)this.attrValueVec.elementAt(i);
            }
        }
        return null;
    }

    public void startContent() throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output" && this.oraOutputName == null) {
            this.xss.err.error2(1009, 1, "use", this.getQualifiedName());
        }
        XSLNode xSLNode = this.parent;
        FastVector fastVector = null;
        while (xSLNode != null) {
            if (xSLNode.exclResPrefixes != null) {
                fastVector = xSLNode.exclResPrefixes;
                break;
            }
            xSLNode = xSLNode.parent;
        }
        if (fastVector != null) {
            if (this.exclResPrefixes == null) {
                this.exclResPrefixes = fastVector;
            } else {
                int n = fastVector.size();
                for (int i = 0; i < n; ++i) {
                    String string = (String)fastVector.elementAt(i);
                    if (this.exclResPrefixes.indexOf(string) != -1) continue;
                    this.exclResPrefixes.addElement(string);
                }
            }
        }
    }

    public void finalizeXSLNode() throws XSLException, XQException {
        Object object;
        Object object2;
        super.finalizeXSLNode();
        if (this.prefixHash != null) {
            object2 = this.prefixHash.keys();
            while (object2.hasMoreElements()) {
                String string;
                object = (String)object2.nextElement();
                if (((String)object).equals("#xpath-default-namespace") || (string = (String)this.prefixHash.get(object)) == "http://www.w3.org/1999/XSL/Transform") continue;
                String string2 = this.xss.getNamespaceAlias(string);
                if (string2 == null) {
                    string2 = string;
                }
                if (this.excludeResultNamespace(string2)) continue;
                if (object == "#default") {
                    object = "";
                }
                if (this.nsKeyVec == null) {
                    this.nsKeyVec = new FastVector();
                    this.nsValVec = new FastVector();
                }
                this.nsKeyVec.addElement(object);
                this.nsValVec.addElement(string2);
            }
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output") {
            this.oraXSLOutput = this.xss.getOutput(this.oraOutputName);
            if (this.oraXSLOutput == null) {
                this.xss.err.error2(1030, 1, this.oraOutputName, "output");
                return;
            }
            if (this.oraOutputHrefVal == null && (object2 = this.oraXSLOutput.getOraHref()) != null) {
                this.oraOutputHrefVal = new XSLNode.AttrValueTmpl((String)object2, this.oraXSLOutput);
            }
            if (this.oraOutputHrefVal == null) {
                this.xss.err.setLocator(this.oraXSLOutput);
                this.xss.err.error2(1009, 1, "href", this.oraXSLOutput.getQualifiedName());
                return;
            }
        } else if (this.xss.isExtensionNamespace(this.namespace)) {
            object2 = this.xss.getExtensionElement(this.namespace, this.localName);
            try {
                object = Class.forName((String)object2);
                this.extElem = (XSLExtensionElement)((Class)object).newInstance();
            }
            catch (Exception exception) {
                this.extElem = null;
            }
        } else {
            object2 = this.xss.getNamespaceAlias(this.namespace);
            if (object2 != null) {
                this.namespace = object2;
            }
            this.qxname = QxNameHash.create(this.namespace, this.localName, this.prefix);
            object = XSLElement.createEndElement(this.xss);
            ((XSLNode)object).nVars = this.nVars;
            this.appendChild((XSLNode)object);
            this.parent.children.insertAfter(this.children, this);
        }
    }

    private boolean excludeResultNamespace(String string) {
        if (this.exclResPrefixes == null) {
            return false;
        }
        String string2 = (String)this.exclResPrefixes.elementAt(0);
        if (string2.equals("#all")) {
            return true;
        }
        int n = this.exclResPrefixes.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.exclResPrefixes.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    void printAttributes(PrintWriter printWriter) {
        if (this.attrPrefixVec != null) {
            int n = this.attrPrefixVec.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.attrPrefixVec.elementAt(i);
                if (string != "") {
                    string = string + ":";
                }
                printWriter.print(" " + string + this.attrLocalNameVec.elementAt(i) + "=\"" + this.attrValueVec.elementAt(i) + "\"");
            }
        }
    }
}

