/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.util.UnicodeUtil;
import oracle.xml.util.XMLUtil;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLOutput;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XSLSAXPrintDriver
extends XMLContentHandler
implements XSLConstants {
    boolean printWriter;
    XMLOutputStream out;
    XSLOutput xslOut;
    Stack elemNames;
    String buffer = null;
    boolean prolog = false;
    boolean elemEmpty = true;
    boolean textPrinted = false;
    boolean disableOutEsc = false;
    boolean firstElement = true;
    boolean scriptORstyle = false;
    boolean cdataElements = false;
    boolean characterMapped = false;
    HashMap mappings;
    boolean unicodeNormalized = false;
    boolean extencspecified = false;
    String extEncoding;
    boolean needClosingTag = false;
    int outMethod = UNKNOWN;
    String prevElem = "";
    static int HTML = 0;
    static int XML = 1;
    static int TEXT = 2;
    static int UNKNOWN = 3;
    static int XHTML = 4;
    private static Hashtable emptyTags;
    private static Hashtable booleanAttrs;
    private static Hashtable uriAttrs;
    private static Hashtable hasHtmlIndentTag;

    public XSLSAXPrintDriver(PrintWriter printWriter, XSLOutput xSLOutput) {
        this.out = new XMLOutputStream(printWriter);
        this.printWriter = true;
        this.xslOut = xSLOutput;
    }

    public XSLSAXPrintDriver(OutputStream outputStream, XSLOutput xSLOutput) {
        this.out = new XMLOutputStream(outputStream);
        this.printWriter = false;
        this.xslOut = xSLOutput;
    }

    void init() throws SAXException {
        try {
            this.cdataElements = this.xslOut.isCDATASectionElement();
            this.characterMapped = this.xslOut.isCharacterMapped();
            if (this.characterMapped) {
                this.mappings = this.xslOut.getMappings();
            }
            this.unicodeNormalized = this.xslOut.isNormalizeUnicode();
            if (this.cdataElements) {
                this.elemNames = new Stack();
            }
            this.setEncoding(this.xslOut.getEncoding());
            String string = this.xslOut.getMethod();
            if (string == XSLOutput.HTML) {
                this.outMethod = HTML;
            } else if (string == XSLOutput.XHTML) {
                this.outMethod = XHTML;
            } else if (string == XSLOutput.TEXT) {
                this.outMethod = TEXT;
            } else if (string == XSLOutput.XML) {
                this.outMethod = XML;
                this.printXMLDecl();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    void setDisableOutEsc(boolean bl) {
        this.disableOutEsc = bl;
    }

    void setEncoding(String string) throws IOException {
        if (!this.printWriter) {
            this.out.setEncoding(string, true, true);
        }
    }

    void setOutputEncoding(String string) throws IOException {
        this.extencspecified = true;
        this.extEncoding = string;
        if (!this.printWriter && !string.equals("")) {
            this.out.setEncoding(string, true, true);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    void flushDebugStream() throws IOException {
        this.out.flushDebugStream();
    }

    void close() throws IOException {
        this.out.close();
    }

    void printXMLDecl() throws IOException {
        if (!this.xslOut.getOmitXMLDecl()) {
            String string = null;
            String string2 = null;
            if (this.xslOut.isEncodingSpecified()) {
                string = this.xslOut.getEncoding();
            } else if (!this.xslOut.getOraOmitXMLEncoding()) {
                string = System.getProperty("oracle.xml.parser.default.character.set", "UTF-8");
            }
            if (this.xslOut.getStandalone() != "") {
                string2 = this.xslOut.getStandalone();
            }
            XMLDeclPI.printXMLDecl(this.out, this.xslOut.getVersion(), string, string2);
        }
    }

    void printProlog(String string, String string2, String string3) throws IOException {
        this.prolog = true;
        if (this.outMethod == UNKNOWN) {
            if (string2.equals("html") && string.equals("http://www.w3.org/1999/xhtml")) {
                this.outMethod = XHTML;
                this.xslOut.setMethod(XSLOutput.XHTML);
            } else if (string2.equalsIgnoreCase("html") && string.equals("")) {
                this.outMethod = HTML;
                this.xslOut.setMethod(XSLOutput.HTML);
            } else {
                this.outMethod = XML;
                this.printXMLDecl();
            }
        }
        String string4 = this.xslOut.getDoctypeSystem();
        String string5 = this.xslOut.getDoctypePublic();
        if (string4 != "" || this.outMethod == HTML && string5 != "") {
            this.out.writeChars("<!DOCTYPE " + string3 + " ");
            if (string5 != "") {
                this.out.writeChars("PUBLIC ");
                this.out.writeQuotedString(string5);
                this.out.write(32);
            } else if (string4 != "") {
                this.out.writeChars("SYSTEM ");
            }
            if (string4 != "") {
                this.out.writeQuotedString(string4);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        if (!this.xslOut.getIndent()) {
            this.out.setOutputStyle(2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            this.writeClosingTag();
            if (!this.prolog) {
                this.printProlog(string, string2, string3);
            } else if (!(this.textPrinted || this.firstElement || this.outMethod == HTML && this.checkHtmlIndentTag(string2.toLowerCase()))) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            if (this.outMethod == HTML && (string2.equalsIgnoreCase("script") || string2.equalsIgnoreCase("style"))) {
                this.scriptORstyle = true;
            }
            this.firstElement = false;
            this.elemEmpty = true;
            this.textPrinted = false;
            if (this.cdataElements) {
                String string4 = string != null && !string.equals("") ? string + ":" + string2 : string2;
                this.elemNames.push(string4);
            }
            this.out.writeChars("<");
            this.out.writeChars(string3);
            this.printAttributes(string2, attributes);
            this.needClosingTag = true;
            this.out.addIndent(1);
            if ((this.outMethod == HTML || this.outMethod == XHTML) && string2.equalsIgnoreCase("head")) {
                this.writeClosingTag();
                if (this.xslOut.getIncludeContentType()) {
                    this.out.writeNewLine();
                    this.out.writeIndent();
                }
                if (this.extencspecified && !this.extEncoding.equals("") && this.xslOut.getIncludeContentType()) {
                    this.out.writeChars("<META http-equiv=\"Content-Type\" content=\"" + this.xslOut.getMediaType() + "; charset=" + this.extEncoding + "\">");
                } else if (!this.extencspecified && this.xslOut.getIncludeContentType()) {
                    this.out.writeChars("<META http-equiv=\"Content-Type\" content=\"" + this.xslOut.getMediaType() + "; charset=" + this.xslOut.getEncoding() + "\">");
                } else if (this.xslOut.getIncludeContentType()) {
                    this.out.writeChars("<META http-equiv=\"Content-Type\" content=\"" + this.xslOut.getMediaType() + "\">");
                }
                this.elemEmpty = false;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
        this.prevElem = string2;
    }

    void printAttributes(String string, Attributes attributes) throws SAXException, IOException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.out.writeChars(" ");
            this.out.writeChars(attributes.getQName(i));
            String string2 = attributes.getValue(i);
            if (this.unicodeNormalized && (string2 = UnicodeUtil.normalizeUnicodeNFC(string2)) == null) continue;
            if (this.outMethod == HTML || this.outMethod == XHTML) {
                String string3 = attributes.getLocalName(i).toLowerCase();
                String string4 = string.toLowerCase();
                if (this.checkHtmlAttribute(string4, string3, booleanAttrs) && string3.equalsIgnoreCase(string2)) continue;
                if (this.checkHtmlAttribute(string4, string3, uriAttrs)) {
                    string2 = XMLUtil.encodeURL(string2);
                    if (this.xslOut.getXSLTVersion() >= 20 && this.xslOut.getEscapeURIAttributes()) {
                        string2 = UnicodeUtil.normalize2RFC2396(string2);
                    }
                }
            }
            this.out.writeChars("=");
            this.out.write(34);
            int n2 = string2.length();
            for (int j = 0; j < n2; ++j) {
                if (string2.charAt(j) == '&') {
                    if (this.outMethod == HTML && j + 1 < n2 && string2.charAt(j + 1) == '{') {
                        this.out.write(38);
                        continue;
                    }
                    this.out.writeChars("&amp;");
                    continue;
                }
                if (string2.charAt(j) == '<') {
                    this.out.writeChars("&lt;");
                    continue;
                }
                if (string2.charAt(j) == '\"') {
                    this.out.writeChars("&quot;");
                    continue;
                }
                if (!this.characterMapped) {
                    this.out.write(string2.charAt(j));
                    continue;
                }
                this.write(string2.charAt(j));
            }
            this.out.write(34);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            this.out.addIndent(-1);
            if (this.cdataElements) {
                this.elemNames.pop();
            }
            if (this.outMethod == HTML) {
                this.scriptORstyle = false;
                if (emptyTags.get(string2.toLowerCase()) != null && string.equals("")) {
                    this.elemEmpty = false;
                    this.textPrinted = false;
                    this.writeClosingTag();
                    return;
                }
            }
            if (this.outMethod == XHTML) {
                this.elemEmpty = emptyTags.get(string2) != null;
            }
            if (this.elemEmpty) {
                if (this.outMethod == HTML) {
                    this.writeClosingTag();
                    this.out.writeChars("</" + string3 + ">");
                } else {
                    if (this.outMethod == XHTML) {
                        this.out.writeChars(" ");
                    }
                    this.out.writeChars("/>");
                }
            } else {
                if (!this.textPrinted) {
                    if (this.outMethod == XHTML && this.prevElem.equals(string2)) {
                        this.writeClosingTag();
                        if (string2.equals("head") && this.xslOut.getIncludeContentType()) {
                            this.out.writeNewLine();
                            this.out.writeIndent();
                        }
                    } else {
                        this.out.writeNewLine();
                        this.out.writeIndent();
                    }
                }
                this.out.writeChars("</" + string3 + ">");
            }
            this.elemEmpty = false;
            this.textPrinted = false;
            this.needClosingTag = false;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            if (this.outMethod == UNKNOWN) {
                this.outMethod = XML;
                this.printXMLDecl();
            }
            this.writeClosingTag();
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            if (this.unicodeNormalized) {
                if ((cArray = UnicodeUtil.normalizeUnicodeNFC(cArray, n, n2)) == null) {
                    return;
                }
                n = 0;
                n2 = cArray.length;
            }
            this.out.writeChars("<!--");
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.out.write(cArray[i]);
            }
            this.out.writeChars("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            if (this.outMethod == UNKNOWN) {
                this.outMethod = XML;
                this.printXMLDecl();
            }
            this.writeClosingTag();
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<?");
            this.out.writeChars(string + " " + string2);
            if (this.outMethod == HTML) {
                this.out.writeChars(">");
            } else {
                this.out.writeChars("?>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elemEmpty = false;
        this.textPrinted = true;
        if (this.unicodeNormalized) {
            if ((cArray = UnicodeUtil.normalizeUnicodeNFC(cArray, n, n2)) == null) {
                return;
            }
            n = 0;
            n2 = cArray.length;
        }
        try {
            int n3;
            int n4;
            this.writeClosingTag();
            if (this.outMethod == UNKNOWN) {
                n4 = 1;
                for (n3 = 0; n3 < n2; ++n3) {
                    if (XMLUtil.isWhiteSpaceChar(cArray[n3])) continue;
                    n4 = 0;
                    break;
                }
                if (n4 == 0) {
                    this.outMethod = XML;
                    this.printXMLDecl();
                } else {
                    return;
                }
            }
            n4 = n + n2;
            if (this.outMethod == TEXT || this.disableOutEsc || this.scriptORstyle) {
                for (n3 = n; n3 < n4; ++n3) {
                    if (!this.characterMapped) {
                        this.out.write(cArray[n3]);
                        continue;
                    }
                    this.write(cArray[n3]);
                }
                return;
            }
            if (this.cdataElements && !this.elemNames.empty() && this.xslOut.checkCDATASectionElement((String)this.elemNames.peek())) {
                this.out.writeChars("<![CDATA[");
                for (n3 = n; n3 < n4; ++n3) {
                    if (cArray[n3] == '>' && n3 > 1) {
                        if (cArray[n3 - 1] == ']' && cArray[n3 - 2] == ']') {
                            this.out.writeChars("]]><![CDATA[");
                        }
                        this.out.write(62);
                        continue;
                    }
                    if (!this.characterMapped) {
                        this.out.write(cArray[n3]);
                        continue;
                    }
                    this.write(cArray[n3]);
                }
                this.out.writeChars("]]>");
                return;
            }
            for (n3 = n; n3 < n4; ++n3) {
                if (cArray[n3] == '&') {
                    this.out.writeChars("&amp;");
                    continue;
                }
                if (cArray[n3] == '<') {
                    this.out.writeChars("&lt;");
                    continue;
                }
                if (cArray[n3] == '>' && n3 > 1) {
                    if (this.outMethod == HTML || cArray[n3 - 1] == ']' && cArray[n3 - 2] == ']') {
                        this.out.writeChars("&gt;");
                        continue;
                    }
                    this.out.write(62);
                    continue;
                }
                if (cArray[n3] == '\u00a0') {
                    if (this.outMethod == HTML || this.outMethod == XHTML) {
                        this.out.writeChars("&nbsp;");
                        continue;
                    }
                    if (!this.characterMapped) {
                        this.out.write(cArray[n3]);
                        continue;
                    }
                    this.write(cArray[n3]);
                    continue;
                }
                if (!this.characterMapped) {
                    this.out.write(cArray[n3]);
                    continue;
                }
                this.write(cArray[n3]);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    private boolean checkHtmlAttribute(String string, String string2, Hashtable hashtable) {
        String string3 = (String)hashtable.get(string2);
        return string3 != null && string3.indexOf(string) != -1;
    }

    private boolean checkHtmlIndentTag(String string) {
        return hasHtmlIndentTag.get(string) != null;
    }

    private void write(char c) throws IOException {
        char[] cArray = XMLUtil.mappingChars(c, this.mappings);
        for (int i = 0; i < cArray.length; ++i) {
            this.out.write(cArray[i]);
        }
    }

    private void writeClosingTag() throws IOException {
        if (this.needClosingTag) {
            this.out.writeChars(">");
            this.needClosingTag = false;
        }
    }

    static {
        hasHtmlIndentTag = new Hashtable();
        hasHtmlIndentTag.put("tt", "tt");
        hasHtmlIndentTag.put("i", "i");
        hasHtmlIndentTag.put("b", "b");
        hasHtmlIndentTag.put("big", "big");
        hasHtmlIndentTag.put("small", "small");
        hasHtmlIndentTag.put("em", "em");
        hasHtmlIndentTag.put("strong", "strong");
        hasHtmlIndentTag.put("dfn", "dfn");
        hasHtmlIndentTag.put("code", "code");
        hasHtmlIndentTag.put("samp", "samp");
        hasHtmlIndentTag.put("kbd", "kbd");
        hasHtmlIndentTag.put("var", "var");
        hasHtmlIndentTag.put("cite", "cite");
        hasHtmlIndentTag.put("abbr", "abbr");
        hasHtmlIndentTag.put("acronym", "acronym");
        hasHtmlIndentTag.put("a", "a");
        hasHtmlIndentTag.put("img", "img");
        hasHtmlIndentTag.put("object", "object");
        hasHtmlIndentTag.put("br", "br");
        hasHtmlIndentTag.put("script", "script");
        hasHtmlIndentTag.put("map", "map");
        hasHtmlIndentTag.put("q", "q");
        hasHtmlIndentTag.put("sub", "sub");
        hasHtmlIndentTag.put("sup", "sup");
        hasHtmlIndentTag.put("span", "span");
        hasHtmlIndentTag.put("bdo", "bdo");
        hasHtmlIndentTag.put("input", "input");
        hasHtmlIndentTag.put("select", "select");
        hasHtmlIndentTag.put("textarea", "textarea");
        hasHtmlIndentTag.put("label", "label");
        hasHtmlIndentTag.put("button", "button");
        hasHtmlIndentTag.put("u", "u");
        hasHtmlIndentTag.put("s", "s");
        hasHtmlIndentTag.put("strike", "strike");
        hasHtmlIndentTag.put("applet", "applet");
        hasHtmlIndentTag.put("font", "font");
        hasHtmlIndentTag.put("basefont", "basefont");
        hasHtmlIndentTag.put("iframe", "iframe");
        emptyTags = new Hashtable(20);
        emptyTags.put("area", "area");
        emptyTags.put("base", "base");
        emptyTags.put("basefont", "basefont");
        emptyTags.put("br", "br");
        emptyTags.put("col", "col");
        emptyTags.put("frame", "frame");
        emptyTags.put("hr", "hr");
        emptyTags.put("img", "img");
        emptyTags.put("input", "input");
        emptyTags.put("isindex", "isindex");
        emptyTags.put("link", "link");
        emptyTags.put("meta", "meta");
        emptyTags.put("param", "param");
        booleanAttrs = new Hashtable(20);
        booleanAttrs.put("checked", "input");
        booleanAttrs.put("compact", "dir, menu, dl, ol, ul");
        booleanAttrs.put("declare", "object");
        booleanAttrs.put("defer", "script");
        booleanAttrs.put("disabled", "button, input, optgroup, option, select, textarea");
        booleanAttrs.put("ismap", "img");
        booleanAttrs.put("multiple", "select");
        booleanAttrs.put("nohref", "area");
        booleanAttrs.put("noresize", "frame");
        booleanAttrs.put("noshade", "hr");
        booleanAttrs.put("nowrap", "td, th");
        booleanAttrs.put("readonly", "textarea, input");
        booleanAttrs.put("selected", "option");
        uriAttrs = new Hashtable(20);
        uriAttrs.put("action", "form");
        uriAttrs.put("archive", "object");
        uriAttrs.put("background", "body");
        uriAttrs.put("cite", "blockquote, del, ins");
        uriAttrs.put("classid", "object");
        uriAttrs.put("codebase", "object, applet");
        uriAttrs.put("data", "object");
        uriAttrs.put("href", "a, area, base");
        uriAttrs.put("longdesc", "img, frame");
        uriAttrs.put("profile", "head");
        uriAttrs.put("src", "script, input, frame, img");
        uriAttrs.put("usemap", "img, input");
    }
}

