/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class JDevOUIUtilities {
    private static boolean b_debug = false;
    private static String javaVM;

    public static String retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return (String)aie.getObject();
    }

    public static String[] retArrayItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return (String[])aie.getObject();
    }

    public static Integer retIntItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return (Integer)aie.getObject();
    }

    public static String GetOSFileSep() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUNIX = true;
        boolean isNT = false;
        int i = osName.indexOf("win");
        if (i != -1) {
            isUNIX = false;
        }
        if (!isUNIX) {
            int j = osName.indexOf("2000");
            if (j == -1) {
                j = osName.indexOf("nt");
            }
            if (j != -1) {
                isNT = true;
            }
        }
        if (isNT) {
            return new String(";");
        }
        return new String(":");
    }

    public static String GetOSEXEExt() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUNIX = true;
        boolean isNT = false;
        int i = osName.indexOf("win");
        if (i != -1) {
            isUNIX = false;
        }
        if (!isUNIX) {
            int j = osName.indexOf("2000");
            if (j == -1) {
                j = osName.indexOf("nt");
            }
            if (j != -1) {
                isNT = true;
            }
        }
        if (isNT) {
            return new String(".exe");
        }
        return new String("");
    }

    public static String GetOSQuoteString() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUNIX = true;
        boolean isNT = false;
        int i = osName.indexOf("win");
        if (i != -1) {
            isUNIX = false;
        }
        if (!isUNIX) {
            int j = osName.indexOf("2000");
            if (j == -1) {
                j = osName.indexOf("nt");
            }
            if (j != -1) {
                isNT = true;
            }
        }
        if (isNT) {
            return new String("\"");
        }
        return new String("");
    }

    public static String CreateTempFile() {
        String res;
        block3: {
            String tmpDir = System.getProperty("user.home");
            int iCounter = 0;
            res = null;
            while (JDevOUIUtilities.fileExists(String.valueOf(String.valueOf(tmpDir).concat(String.valueOf("/jdevOUI"))).concat(String.valueOf(iCounter)))) {
                ++iCounter;
            }
            if (JDevOUIUtilities.fileExists(String.valueOf(String.valueOf(tmpDir).concat(String.valueOf("/jdevOUI"))).concat(String.valueOf(iCounter)))) break block3;
            try {
                File tmpFile = new File(String.valueOf(String.valueOf(tmpDir).concat(String.valueOf("/jdevOUI"))).concat(String.valueOf(iCounter)));
                FileOutputStream tmpFileOut = new FileOutputStream(tmpFile);
                tmpFileOut.close();
                res = tmpFile.getCanonicalPath();
            }
            catch (Exception exception) {}
        }
        return res;
    }

    public static String getCanonicalPath(String szPath) {
        String res = null;
        try {
            File tmpFile = new File(szPath);
            res = tmpFile.getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static void RemoveTempFile(String szFileName) {
        try {
            if (JDevOUIUtilities.fileExists(szFileName)) {
                File tmpFile = new File(szFileName);
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void InvokeJavaVM(String jdevInstallRoot, String args) throws Exception {
        if (javaVM == null) {
            javaVM = JDevOUIUtilities.parseJDevConf(jdevInstallRoot);
        }
        String jvm = String.valueOf(javaVM).concat(String.valueOf(" "));
        if (!JDevOUIUtilities.fileExists(javaVM)) {
            JDevOUIUtilities.logMessage("[InvokeJavaVM] Unable to locate a suitable JDK based on the jdev.conf entries.\n");
            return;
        }
        if (JDevOUIUtilities.isDebug()) {
            jvm = String.valueOf(jvm).concat(String.valueOf(" -XXdebugport4000 "));
        }
        jvm = String.valueOf(jvm).concat(String.valueOf(args));
        JDevOUIUtilities.logMessage(String.valueOf("Launching JVM: ").concat(String.valueOf(jvm)));
        Process p = Runtime.getRuntime().exec(jvm, null, null);
        class ProcessOutputThread
        extends Thread {
            private BufferedReader _br;

            ProcessOutputThread(String name, InputStream is) {
                super(name);
                this._br = new BufferedReader(new InputStreamReader(is));
            }

            public void run() {
                while (true) {
                    try {
                        String line = this._br.readLine();
                        if (line == null) break;
                        JDevOUIUtilities.logMessage(line);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[").concat(String.valueOf(this.getName()))).concat(String.valueOf("] finished")));
            }
        }
        ProcessOutputThread stdoutThread = new ProcessOutputThread("stdout", p.getInputStream());
        stdoutThread.start();
        ProcessOutputThread stderrThread = new ProcessOutputThread("stderr", p.getErrorStream());
        stderrThread.start();
        p.waitFor();
    }

    private static String findTokenInJDevConf(String jdevInstallRoot, String strKey, boolean excludeCommented) throws Exception {
        String jdevConf = String.valueOf(jdevInstallRoot).concat(String.valueOf("/jdev/bin/jdev.conf"));
        BufferedReader in = null;
        String line = null;
        JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[findTokenInJDevConf] preparing to parse jdev conf file: ").concat(String.valueOf(jdevConf))).concat(String.valueOf("\n")));
        File tmpFile = new File(jdevConf);
        jdevConf = tmpFile.getCanonicalPath();
        if (!JDevOUIUtilities.fileExists(jdevConf)) {
            throw new FileNotFoundException(String.valueOf(String.valueOf("Unable to find: [").concat(String.valueOf(jdevConf))).concat(String.valueOf("].")));
        }
        in = new BufferedReader(new FileReader(jdevConf));
        line = in.readLine();
        while (line != null) {
            int pos = line.indexOf(strKey);
            if (pos != -1) {
                if (excludeCommented && line.charAt(0) == '#') {
                    continue;
                }
                break;
            }
            line = in.readLine();
        }
        return line;
    }

    private static String parseJDevConf(String jdevInstallRoot) throws Exception {
        String jdevConf = String.valueOf(jdevInstallRoot).concat(String.valueOf("/jdev/bin/jdev.conf"));
        String line = null;
        String res = String.valueOf(jdevInstallRoot).concat(String.valueOf("/jdk"));
        File tmpFile = new File(jdevConf);
        if (!JDevOUIUtilities.fileExists(jdevConf = tmpFile.getCanonicalPath())) {
            throw new FileNotFoundException(String.valueOf(String.valueOf("Unable to find: [").concat(String.valueOf(jdevConf))).concat(String.valueOf("].")));
        }
        BufferedReader in = new BufferedReader(new FileReader(jdevConf));
        line = in.readLine();
        while (line != null) {
            int pos = line.indexOf("SetJavaHome");
            if (pos != -1 && line.indexOf("#") == -1) {
                res = line.substring(line.indexOf(" ") + 1);
            }
            line = in.readLine();
        }
        res = String.valueOf(res).concat(String.valueOf(String.valueOf("/bin/java").concat(String.valueOf(JDevOUIUtilities.GetOSEXEExt()))));
        return res;
    }

    private static boolean fileExists(String fileName) {
        boolean res = false;
        try {
            File fileObj = new File(fileName);
            if (fileObj.exists()) {
                res = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static boolean deleteDir(File dir) {
        String[] files = dir.list();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File f = new File(dir, files[i]);
                if (f.isDirectory()) {
                    if (JDevOUIUtilities.deleteDir(f)) continue;
                    return false;
                }
                JDevOUIUtilities.logMessage(String.valueOf("Deleting file ").concat(String.valueOf(f.getPath())));
                if (f.delete()) continue;
                return false;
            }
        }
        JDevOUIUtilities.logMessage(String.valueOf("Deleting directory ").concat(String.valueOf(dir.getPath())));
        return dir.delete();
    }

    public static void renameSystemFolder(String jdevRoot) throws Exception {
        String ver = null;
        File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/system/ide.properties"))));
        OrderedProperties prop = new OrderedProperties();
        JDevOUIUtilities.logMessage("[renameSystemFolder] preparing to load prop file.\n");
        try {
            FileInputStream reader = new FileInputStream(tmpFileProperties);
            prop.load(reader);
            reader.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[renameSystemFolder] - Read PropFile - ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            return;
        }
        try {
            ver = (String)prop.get("Ide.IntegVersion");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (ver == null) {
            ver = new String("old");
        }
        JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[renameSystemFolder] IntegVersion number: ").concat(String.valueOf(ver))).concat(String.valueOf("\n")));
        String oldDir = JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/system")));
        String backupDir = JDevOUIUtilities.getCanonicalPath(String.valueOf(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/system."))).concat(String.valueOf(ver)));
        JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[renameSystemFolder] Old Directory: ").concat(String.valueOf(oldDir))).concat(String.valueOf(" New Directory: "))).concat(String.valueOf(backupDir))).concat(String.valueOf("\n")));
        try {
            File tmp = new File(oldDir);
            if (tmp.isDirectory()) {
                boolean res = tmp.renameTo(new File(backupDir));
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[renameSystemFolder] res is: ").concat(String.valueOf(res))).concat(String.valueOf("\n")));
            }
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[renameSystemFolder] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void registerAddin(String jdevRoot, String addinPackage) throws Exception {
        try {
            File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/bin/addins.properties"))));
            OrderedProperties prop = new OrderedProperties();
            JDevOUIUtilities.logMessage("[registerAddin] preparing to load prop file.\n");
            try {
                FileInputStream reader = new FileInputStream(tmpFileProperties);
                prop.load(reader);
                reader.close();
            }
            catch (Exception ex) {
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[registerAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - Read PropFile - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                return;
            }
            JDevOUIUtilities.logMessage("[registerAddin] Loaded...\n");
            int addinCount = Integer.parseInt(prop.getProperty("AddinCount"), 10);
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerAddin] Found: ").concat(String.valueOf(addinCount))).concat(String.valueOf(" addins.\n")));
            for (int iCounter = 0; iCounter < addinCount; ++iCounter) {
                try {
                    String tmpString = prop.getProperty(String.valueOf("Addin").concat(String.valueOf(new Integer(iCounter))));
                    if (tmpString.indexOf(addinPackage) == -1) continue;
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" was already registered.\n")));
                    return;
                }
                catch (Exception ex) {
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[registerAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - CheckForPrevInstall - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                }
            }
            prop.put(String.valueOf("Addin").concat(String.valueOf(addinCount)), addinPackage);
            prop.put("AddinCount", String.valueOf("").concat(String.valueOf(++addinCount)));
            FileOutputStream writer = new FileOutputStream(tmpFileProperties);
            prop.save(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerAddin] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void deregisterAddin(String jdevRoot, String addinPackage) throws Exception {
        try {
            File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/bin/addins.properties"))));
            OrderedProperties prop = new OrderedProperties();
            JDevOUIUtilities.logMessage("[deregisterAddin] preparing to load prop file.\n");
            try {
                FileInputStream reader = new FileInputStream(tmpFileProperties);
                prop.load(reader);
                reader.close();
            }
            catch (Exception ex) {
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[deregisterAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - Read PropFile - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                return;
            }
            JDevOUIUtilities.logMessage("[deregisterAddin] Loaded...\n");
            int addinCount = Integer.parseInt(prop.getProperty("AddinCount"), 10);
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[deregisterAddin] Found: ").concat(String.valueOf(addinCount))).concat(String.valueOf(" addins.\n")));
            for (int iCounter = 0; iCounter < addinCount; ++iCounter) {
                try {
                    String tmpString = prop.getProperty(String.valueOf("Addin").concat(String.valueOf(new Integer(iCounter))));
                    if (tmpString.indexOf(addinPackage) == -1) continue;
                    prop.remove(String.valueOf("Addin").concat(String.valueOf(iCounter)));
                    continue;
                }
                catch (Exception ex) {
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[deregisterAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - CheckForPrevInstall - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                }
            }
            FileOutputStream writer = new FileOutputStream(tmpFileProperties);
            prop.save(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[deregisterAddin] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void registerRunAddin(String jdevRoot, String addinPackage) throws Exception {
        try {
            File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/bin/addins.properties"))));
            OrderedProperties prop = new OrderedProperties();
            JDevOUIUtilities.logMessage("[registerRunAddin] preparing to load prop file.\n");
            try {
                FileInputStream reader = new FileInputStream(tmpFileProperties);
                prop.load(reader);
                reader.close();
            }
            catch (Exception ex) {
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[registerRunAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - Read PropFile - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                return;
            }
            JDevOUIUtilities.logMessage("[registerRunAddin] Loaded...\n");
            int addinCount = Integer.parseInt(prop.getProperty("RunAddinCount"), 10);
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerRunAddin] Found: ").concat(String.valueOf(addinCount))).concat(String.valueOf(" addins.\n")));
            for (int iCounter = 0; iCounter < addinCount; ++iCounter) {
                try {
                    String tmpString = prop.getProperty(String.valueOf("RunAddin").concat(String.valueOf(new Integer(iCounter))));
                    if (tmpString.indexOf(addinPackage) == -1) continue;
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerRunAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" was already registered.\n")));
                    return;
                }
                catch (Exception ex) {
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[registerRunAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - CheckForPrevInstall - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                }
            }
            prop.put(String.valueOf("RunAddin").concat(String.valueOf(addinCount)), addinPackage);
            prop.put("RunAddinCount", String.valueOf("").concat(String.valueOf(++addinCount)));
            FileOutputStream writer = new FileOutputStream(tmpFileProperties);
            prop.save(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerRunAddin] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void deregisterRunAddin(String jdevRoot, String addinPackage) throws Exception {
        try {
            File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/bin/addins.properties"))));
            OrderedProperties prop = new OrderedProperties();
            JDevOUIUtilities.logMessage("[deregisterAddin] preparing to load prop file.\n");
            try {
                FileInputStream reader = new FileInputStream(tmpFileProperties);
                prop.load(reader);
                reader.close();
            }
            catch (Exception ex) {
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[deregisterRunAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - Read PropFile - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                return;
            }
            JDevOUIUtilities.logMessage("[deregisterRunAddin] Loaded...\n");
            int addinCount = Integer.parseInt(prop.getProperty("RunAddinCount"), 10);
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[deregisterRunAddin] Found: ").concat(String.valueOf(addinCount))).concat(String.valueOf(" addins.\n")));
            for (int iCounter = 0; iCounter < addinCount; ++iCounter) {
                try {
                    String tmpString = prop.getProperty(String.valueOf("RunAddin").concat(String.valueOf(new Integer(iCounter))));
                    if (tmpString.indexOf(addinPackage) == -1) continue;
                    prop.remove(String.valueOf("Addin").concat(String.valueOf(iCounter)));
                    continue;
                }
                catch (Exception ex) {
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[deregisterRunAddin] ").concat(String.valueOf(addinPackage))).concat(String.valueOf(" - CheckForPrevInstall - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                }
            }
            FileOutputStream writer = new FileOutputStream(tmpFileProperties);
            prop.save(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[deregisterRunAddin] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void registerHelpSet(String jdevRoot, String helpSetJar) throws Exception {
        try {
            File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/doc/ohj/helpbooks.properties"))));
            OrderedProperties prop = new OrderedProperties();
            JDevOUIUtilities.logMessage("[registerHelpSet] preparing to load prop file.\n");
            try {
                FileInputStream reader = new FileInputStream(tmpFileProperties);
                prop.load(reader);
                reader.close();
            }
            catch (Exception ex) {
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[registerHelpSet] ").concat(String.valueOf(helpSetJar))).concat(String.valueOf(" - Read PropFile - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                return;
            }
            JDevOUIUtilities.logMessage("[registerHelpSet] Loaded...\n");
            int bookCount = Integer.parseInt(prop.getProperty("Book.NumFiles"), 10);
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerHelpSet] Found: ").concat(String.valueOf(bookCount))).concat(String.valueOf(" books.\n")));
            for (int iCounter = 0; iCounter < bookCount; ++iCounter) {
                try {
                    String tmpString = prop.getProperty(String.valueOf("Book.FileName.").concat(String.valueOf(new Integer(iCounter))));
                    if (tmpString.indexOf(helpSetJar) == -1) continue;
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerHelpSet] ").concat(String.valueOf(helpSetJar))).concat(String.valueOf(" was already registered.\n")));
                    return;
                }
                catch (Exception ex) {
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[registerHelpSet] ").concat(String.valueOf(helpSetJar))).concat(String.valueOf(" - CheckForPrevInstall - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                }
            }
            prop.put(String.valueOf("Book.FileName.").concat(String.valueOf(bookCount)), helpSetJar);
            prop.put("Book.NumFiles", String.valueOf("").concat(String.valueOf(++bookCount)));
            FileOutputStream writer = new FileOutputStream(tmpFileProperties);
            prop.save(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[registerHelpSet] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void deregisterHelpSet(String jdevRoot, String helpSetJar) throws Exception {
        try {
            File tmpFileProperties = new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(jdevRoot).concat(String.valueOf("/jdev/doc/ohj/helpbooks.properties"))));
            OrderedProperties prop = new OrderedProperties();
            JDevOUIUtilities.logMessage("[deregisterHelpSet] preparing to load prop file.\n");
            try {
                FileInputStream reader = new FileInputStream(tmpFileProperties);
                prop.load(reader);
                reader.close();
            }
            catch (Exception ex) {
                JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[deregisterHelpSet] ").concat(String.valueOf(helpSetJar))).concat(String.valueOf(" - Read PropFile - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                return;
            }
            JDevOUIUtilities.logMessage("[deregisterHelpSet] Loaded...\n");
            int bookCount = Integer.parseInt(prop.getProperty("Book.NumFiles"), 10);
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[deregisterHelpSet] Found: ").concat(String.valueOf(bookCount))).concat(String.valueOf(" books.\n")));
            for (int iCounter = 0; iCounter < bookCount; ++iCounter) {
                try {
                    String tmpString = prop.getProperty(String.valueOf("Book.FileName.").concat(String.valueOf(new Integer(iCounter))));
                    if (tmpString.indexOf(helpSetJar) == -1) continue;
                    prop.remove(String.valueOf("Book.FileName.").concat(String.valueOf(iCounter)));
                    continue;
                }
                catch (Exception ex) {
                    JDevOUIUtilities.logMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[deregisterHelpSet] ").concat(String.valueOf(helpSetJar))).concat(String.valueOf(" - CheckForPrevInstall - "))).concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
                }
            }
            FileOutputStream writer = new FileOutputStream(tmpFileProperties);
            prop.save(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[deregisterHelpSet] ").concat(String.valueOf(ex.getLocalizedMessage()))).concat(String.valueOf("\n")));
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String getIntegVersion(String jdevRoot) throws Exception {
        int iStart;
        String ver = null;
        String line = null;
        line = JDevOUIUtilities.findTokenInJDevConf(jdevRoot, "-Dproduct.version", true);
        if (line != null && (iStart = line.indexOf("=")) != -1) {
            ver = line.substring(iStart + 1);
        }
        if (ver == null) {
            ver = new String("notfound");
        }
        JDevOUIUtilities.logMessage(String.valueOf(String.valueOf("[getIntegVersion] IntegVersion number: ").concat(String.valueOf(ver))).concat(String.valueOf("\n")));
        return ver;
    }

    public static boolean isConfigured(String jdevRoot) throws Exception {
        String _javavm = null;
        JDevOUIUtilities.logMessage("[isConfigured] About to call parseJDevConf.\n");
        _javavm = JDevOUIUtilities.parseJDevConf(jdevRoot);
        if (!JDevOUIUtilities.fileExists(_javavm)) {
            JDevOUIUtilities.logMessage("[isConfigured] Unable to locate a suitable JDK based on the jdev.conf entries.\n");
            return false;
        }
        JDevOUIUtilities.logMessage("[isConfigured] returning true.\n");
        return true;
    }

    public static boolean isDebug() {
        return b_debug;
    }

    public static void logMessage(String strMsg) {
        if (JDevOUIUtilities.isDebug()) {
            System.out.println(strMsg);
        } else {
            OiiolTextLogger.appendText((String)strMsg);
        }
    }

    public static void main(String[] args) {
        b_debug = true;
        String t = JDevOUIUtilities.CreateTempFile();
        JDevOUIUtilities.logMessage(String.valueOf("TempFile: ").concat(String.valueOf(t)));
        JDevOUIUtilities.logMessage(String.valueOf("Removing: ").concat(String.valueOf(t)));
        JDevOUIUtilities.RemoveTempFile(t);
        JDevOUIUtilities.logMessage(String.valueOf("JDevRoot: ").concat(String.valueOf(args[0])));
        try {
            JDevOUIUtilities.logMessage(String.valueOf("JDK: ").concat(String.valueOf(JDevOUIUtilities.parseJDevConf(args[0]))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            JDevOUIUtilities.registerAddin(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            JDevOUIUtilities.deregisterAddin(args[0], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JDevOUIUtilities.deleteDir(new File(JDevOUIUtilities.getCanonicalPath(String.valueOf(args[0]).concat(String.valueOf("/doc")))));
        try {
            JDevOUIUtilities.renameSystemFolder(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            boolean e = JDevOUIUtilities.isConfigured(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String e = JDevOUIUtilities.getIntegVersion(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

