/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.InvalidHandleException;
import oracle.ias.cache.NotAPoolException;
import oracle.ias.cache.NotARetrievableObjectException;
import oracle.ias.cache.NullObj;
import oracle.ias.cache.NullObjectException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.ObjectStatus;
import oracle.ias.cache.PoolAccess;
import oracle.ias.cache.PoolInstanceFactory;
import oracle.ias.cache.RegionNotFoundException;
import oracle.ias.cache.TimeoutException;

public class CacheAccess {
    static final String DEF_QUAL_ = "oracle_java_cache_service";
    static final String DEF_GROUP_NAME_ = "oracle_java_cache_service";
    static final String SUBREGION_DELIM = "/";
    static CacheAttributes defcacheattr_;
    private String region_ = null;
    private String owned_ = null;
    private CacheHandle grphandle_ = null;

    private CacheHandle getHandle() throws InvalidHandleException {
        if (this.grphandle_ == null) {
            throw new InvalidHandleException(CacheInternal.EXP_INVALHDL);
        }
        return this.grphandle_;
    }

    private void releaseHandle() {
        try {
            if (this.grphandle_ != null) {
                CacheHandleQ.releaseHandle(this.grphandle_);
                this.grphandle_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean initCacheService() {
        boolean bl = true;
        try {
            if (!CacheInternal.isReady()) {
                if (!CacheInternal.autoInit()) {
                    return false;
                }
                CacheInternal.open("javacache.properties");
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static boolean isRegionExist(String string) {
        boolean bl = false;
        try {
            bl = CacheHandle.regionExists(string, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private String getDefGrpName() {
        return this.getRegionName();
    }

    private static CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(CacheInternal.EXP_EXCEPTIONIN + " " + string, exception);
    }

    private static void createSubRegions(String string, String string2, Attributes attributes) throws CacheException {
        CacheAccess cacheAccess = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SUBREGION_DELIM);
        try {
            if (string == null && !CacheAccess.isRegionExist(string = stringTokenizer.nextToken())) {
                try {
                    CacheAccess.defineRegion(string, attributes);
                }
                catch (ObjectExistsException objectExistsException) {
                    // empty catch block
                }
            }
            cacheAccess = new CacheAccess(string);
            CacheHandle cacheHandle = cacheAccess.getHandle();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string + SUBREGION_DELIM + string3;
                if (!CacheAccess.isRegionExist(string4)) {
                    try {
                        cacheHandle.createGroup(string4, string4, string, string, attributes);
                    }
                    catch (ObjectExistsException objectExistsException) {
                        // empty catch block
                    }
                }
                string = string + SUBREGION_DELIM + string3;
            }
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.defineRegion", exception);
        }
        finally {
            if (cacheAccess != null) {
                cacheAccess.close();
            }
        }
    }

    public static void defineRegion(String string, Attributes attributes) throws CacheNotAvailableException, NullObjectNameException, ObjectExistsException, CacheException {
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("defineRegion(\"" + string + "\", " + attributes + ")");
        }
        try {
            if (string == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = CacheHandleQ.getHandle();
            cacheHandle.createGroup(string, string, null, null, attributes);
            cacheHandle.setRegionNumber();
            CacheHandleQ.releaseHandle(cacheHandle);
            cacheHandle = null;
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.defineRegion", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public static void defineRegion(String string) throws CacheNotAvailableException, NullObjectNameException, ObjectExistsException, CacheException {
        CacheAccess.defineRegion(string, null);
    }

    public static CacheAccess getAccess() throws CacheException {
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAccess()");
        }
        CacheAccess cacheAccess = new CacheAccess(CacheAccess.getDefRegionName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public static CacheAccess getAccess(String string) throws CacheNotAvailableException {
        CacheAccess cacheAccess = null;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAccess(\"" + string + "\")");
        }
        cacheAccess = new CacheAccess(string);
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public static CacheAccess getAccess(String string, boolean bl) throws CacheNotAvailableException, RegionNotFoundException, CacheException {
        CacheAccess cacheAccess = null;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAccess(\"" + string + "\", " + bl + ")");
        }
        if (bl && !CacheAccess.isRegionExist(string)) {
            throw CacheAccess.exceptionHandler("CacheAccess.getAccess", new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + string + "\""));
        }
        cacheAccess = new CacheAccess(string);
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public static CacheAccess getAccess(String string, Attributes attributes, boolean bl) throws CacheNotAvailableException, RegionNotFoundException, CacheException {
        CacheAccess cacheAccess = null;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAccess(\"" + string + "\", " + attributes + ")");
        }
        if (!CacheAccess.isRegionExist(string)) {
            if (bl) {
                CacheAccess.createSubRegions(null, string, attributes);
            } else {
                try {
                    CacheAccess.defineRegion(string, attributes);
                }
                catch (ObjectExistsException objectExistsException) {
                    // empty catch block
                }
            }
        }
        cacheAccess = new CacheAccess(string);
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public void defineObject(Object object, Attributes attributes) throws CacheException {
        this.defineObject(object, this.getDefGrpName(), attributes);
    }

    public void defineObject(Object object, String string, Attributes attributes) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("defineObject(" + object + ", \"" + string + "\", " + attributes + ")");
        }
        try {
            if (string == null || object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.register(object, this.getRegionName(), string, attributes);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.defineObject", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void resetAttributes(Attributes attributes) throws CacheException, InvalidHandleException {
        this.resetAttributes(this.getDefGrpName(), attributes);
    }

    public void resetAttributes(Object object, Attributes attributes) throws CacheException, InvalidHandleException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("resetAttributes(" + object + ", " + attributes + ")");
        }
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.resetAttributes(object, this.getRegionName(), attributes);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.resetAttributes", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object) throws ObjectNotFoundException, NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        Object object2;
        block12: {
            long l;
            block10: {
                block11: {
                    l = 0L;
                    if (CacheInternal.logger.shouldLog(7)) {
                        l = CacheAccess.TRACE("get(" + object + ")");
                    }
                    object2 = null;
                    try {
                        try {
                            if (object == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object2 = cacheHandle.locateObject(object, this.getRegionName(), this.getDefGrpName(), null);
                        }
                        catch (NullObjectException nullObjectException) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + "\"" + object + "\""));
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", exception);
                        }
                        Object var7_7 = null;
                        if (!CacheInternal.logger.shouldLog(7)) break block10;
                        if (object2 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (!CacheInternal.logger.shouldLog(7)) {
                            if (!CacheInternal.logger.shouldLog(15)) throw throwable;
                            CacheAccess.TRACE("return:" + object2, l);
                            throw throwable;
                        }
                        if (object2 != null) {
                            CacheAccess.TRACE("return: " + object2.hashCode() + " " + object2.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE("return null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE("return: " + object2.hashCode() + " " + object2.getClass().getName(), l);
                    break block12;
                }
                CacheAccess.TRACE("return null", l);
                break block12;
            }
            if (CacheInternal.logger.shouldLog(15)) {
                CacheAccess.TRACE("return:" + object2, l);
            }
        }
        if (!(object2 instanceof NullObj)) return object2;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object, Object object2) throws ObjectNotFoundException, NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        Object object3;
        block12: {
            long l;
            block10: {
                block11: {
                    l = 0L;
                    if (CacheInternal.logger.shouldLog(7)) {
                        l = CacheAccess.TRACE("get(" + object + ", " + object2 + ")");
                    }
                    object3 = null;
                    try {
                        try {
                            if (object == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object3 = cacheHandle.locateObject(object, this.getRegionName(), this.getDefGrpName(), object2);
                        }
                        catch (NullObjectException nullObjectException) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + "\"" + object + "\""));
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", exception);
                        }
                        Object var8_8 = null;
                        if (!CacheInternal.logger.shouldLog(7)) break block10;
                        if (object3 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (!CacheInternal.logger.shouldLog(7)) {
                            if (!CacheInternal.logger.shouldLog(15)) throw throwable;
                            CacheAccess.TRACE("return:" + object3, l);
                            throw throwable;
                        }
                        if (object3 != null) {
                            CacheAccess.TRACE("return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE("return null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE("return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                    break block12;
                }
                CacheAccess.TRACE("return null", l);
                break block12;
            }
            if (CacheInternal.logger.shouldLog(15)) {
                CacheAccess.TRACE("return:" + object3, l);
            }
        }
        if (!(object3 instanceof NullObj)) return object3;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object, String string, Object object2) throws ObjectNotFoundException, NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        Object object3;
        block12: {
            long l;
            block10: {
                block11: {
                    l = 0L;
                    if (CacheInternal.logger.shouldLog(7)) {
                        l = CacheAccess.TRACE("get(" + object + ", \"" + string + "\", " + object2 + ")");
                    }
                    object3 = null;
                    try {
                        try {
                            if (object == null) throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            if (string == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object3 = cacheHandle.locateObject(object, this.getRegionName(), string, object2);
                        }
                        catch (NullObjectException nullObjectException) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + "\"" + object + "\"", nullObjectException));
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", exception);
                        }
                        Object var9_9 = null;
                        if (!CacheInternal.logger.shouldLog(7)) break block10;
                        if (object3 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (!CacheInternal.logger.shouldLog(7)) {
                            if (!CacheInternal.logger.shouldLog(15)) throw throwable;
                            CacheAccess.TRACE("return:" + object3, l);
                            throw throwable;
                        }
                        if (object3 != null) {
                            CacheAccess.TRACE("return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE("return null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE("return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                    break block12;
                }
                CacheAccess.TRACE("return null", l);
                break block12;
            }
            if (CacheInternal.logger.shouldLog(15)) {
                CacheAccess.TRACE("return:" + object3, l);
            }
        }
        if (!(object3 instanceof NullObj)) return object3;
        return null;
    }

    public void loadList(Object[] objectArray) throws NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        this.loadList(objectArray, this.getDefGrpName(), null);
    }

    public void loadList(Object[] objectArray, Object object) throws NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        this.loadList(objectArray, this.getDefGrpName(), object);
    }

    public void loadList(Object[] objectArray, String string, Object object) throws NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("loadList(" + objectArray + ", \"" + string + "\", " + object + ")");
        }
        try {
            if (objectArray == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.loadList(objectArray, this.getRegionName(), string, object);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.loadList", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void preLoad(Object object) throws ObjectNotFoundException, InvalidHandleException, CacheException {
        this.preLoad(object, this.getDefGrpName(), null);
    }

    public void preLoad(Object object, Object object2) throws ObjectNotFoundException, InvalidHandleException, CacheException {
        this.preLoad(object, this.getDefGrpName(), object2);
    }

    public void preLoad(Object object, String string, Object object2) throws ObjectNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("preLoad(" + object + ", \"" + string + "\", " + object2 + ")");
        }
        try {
            if (object == null || string == null) {
                throw new ObjectNotFoundException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.preLoadObject(object, this.getRegionName(), string, object2);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.preLoad", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void put(Object object, Object object2) throws CacheException {
        this.put(object, this.getDefGrpName(), object2, null);
    }

    public void put(Object object, String string, Object object2) throws CacheException {
        this.put(object, string, object2, null);
    }

    public void put(Object object, Attributes attributes, Object object2) throws CacheException {
        this.put(object, this.getDefGrpName(), object2, attributes);
    }

    public void put(Object object, String string, Object object2, Attributes attributes) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("put(" + object + ", \"" + string + "\", " + object2 + ", " + attributes + ")");
        }
        try {
            if (object == null || string == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.putObject(object, this.getRegionName(), string, object2, attributes);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.put", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public Object replace(Object object, Object object2) throws CacheException {
        return this.replace(object, this.getDefGrpName(), object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object replace(Object object, String string, Object object2) throws CacheException, NullObjectException {
        Object object3;
        block11: {
            long l;
            block9: {
                block10: {
                    l = 0L;
                    if (CacheInternal.logger.shouldLog(7)) {
                        l = CacheAccess.TRACE("replace(" + object + ", \"" + string + "\", " + object2 + ")");
                    }
                    object3 = null;
                    try {
                        try {
                            if (object == null) throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            if (string == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object3 = cacheHandle.replaceObject(object, this.getRegionName(), string, object2);
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.replace", exception);
                        }
                        Object var9_8 = null;
                        if (!CacheInternal.logger.shouldLog(7)) break block9;
                        if (object3 == null) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (!CacheInternal.logger.shouldLog(7)) {
                            if (!CacheInternal.logger.shouldLog(15)) throw throwable;
                            CacheAccess.TRACE("return:" + object3, l);
                            throw throwable;
                        }
                        if (object3 != null) {
                            CacheAccess.TRACE("return: " + object3.hashCode() + ", " + object3.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE("return:null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE("return: " + object3.hashCode() + ", " + object3.getClass().getName(), l);
                    break block11;
                }
                CacheAccess.TRACE("return:null", l);
                break block11;
            }
            if (CacheInternal.logger.shouldLog(15)) {
                CacheAccess.TRACE("return:" + object3, l);
            }
        }
        if (!(object3 instanceof NullObj)) return object3;
        return null;
    }

    public void replaceRemote(Object object, Object object2, CacheAddress cacheAddress) throws CacheException {
        this.replaceRemote(object, this.getDefGrpName(), object2, cacheAddress);
    }

    public void replaceRemote(Object object, String string, Object object2, CacheAddress cacheAddress) throws CacheException, NullObjectException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("replaceRemote(" + object + ", \"" + string);
        }
        try {
            if (object == null || string == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.replaceRemoteObject(object, this.getRegionName(), string, object2, cacheAddress);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.replaceRemote", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void invalidate() throws CacheException {
        this.invalidate(this.getDefGrpName(), false);
    }

    public void invalidate(boolean bl) throws CacheException {
        this.invalidate(this.getDefGrpName(), bl);
    }

    public void invalidate(Object object) throws CacheException {
        this.invalidate(object, false);
    }

    public void invalidate(Object object, boolean bl) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("invalidate(" + object + ")");
        }
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.invalidate(object, this.getRegionName(), bl);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.invalidate", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void invalidate(Object[] objectArray) throws CacheException {
        this.invalidate(objectArray, false);
    }

    public void invalidate(Object[] objectArray, boolean bl) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("invalidate(" + objectArray + ")");
        }
        try {
            if (objectArray == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.invalidate(objectArray, this.getRegionName(), bl);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.invalidate", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void disable() throws CacheException {
        this.disable(this.getDefGrpName());
    }

    public void disable(Object object) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("disable(" + object + ")");
        }
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.disable(object, this.getRegionName());
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.disable", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void enable() throws CacheException {
        this.enable(this.getDefGrpName());
    }

    public void enable(Object object) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("enable(" + object + ")");
        }
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.enable(object, this.getRegionName());
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.enable", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public boolean isDisabled() throws CacheException {
        return this.isDisabled(this.getDefGrpName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDisabled(Object object) throws CacheException {
        long l = 0L;
        boolean bl = false;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("isDisabled(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                bl = cacheHandle.isDisabled(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.isDisabled", exception);
            }
            Object var7_6 = null;
            if (!CacheInternal.logger.shouldLog(7)) return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!CacheInternal.logger.shouldLog(7)) throw throwable;
            CacheAccess.TRACE("return:" + bl, l);
            throw throwable;
        }
        CacheAccess.TRACE("return:" + bl, l);
        return bl;
    }

    public void save() throws CacheException, NullObjectNameException {
        this.save(this.getDefGrpName());
    }

    public void save(Object object) throws CacheException, NullObjectNameException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("save(" + object + ")");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            cacheHandle.saveObject(object, this.getRegionName());
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.save", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void spool(Object object) throws CacheException, NullObjectNameException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("spool(" + object + ")");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            cacheHandle.spool(object, this.getRegionName());
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.spool", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void close() {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("close " + this.region_);
        }
        try {
            this.releaseHandle();
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
    }

    public void defineGroup(String string) throws CacheException {
        this.defineGroup(string, this.getDefGrpName(), null);
    }

    public void defineGroup(String string, String string2) throws CacheException {
        this.defineGroup(string, string2, null);
    }

    public void defineGroup(String string, Attributes attributes) throws CacheException {
        this.defineGroup(string, this.getDefGrpName(), attributes);
    }

    public void defineGroup(String string, String string2, Attributes attributes) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("defineGroup(\"" + string + "\", \"" + string2 + "\", " + attributes + ")");
        }
        try {
            if (string == null || string2 == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.createGroup(string, this.getRegionName(), null, string2, attributes);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.defineGroup", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void defineSubRegion(String string) throws CacheException {
        this.defineSubRegion(string, null);
    }

    public void defineSubRegion(String string, Attributes attributes) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("defineSubRegion(\"" + string + "\", \"" + attributes + ")");
        }
        try {
            if (string == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            String string2 = this.getRegionName() + SUBREGION_DELIM + string;
            cacheHandle.createGroup(string2, string2, this.getRegionName(), this.getRegionName(), attributes);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.defineGroup", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public CacheAccess getSubRegion(String string) throws CacheException {
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getSubRegion(" + string + ")");
        }
        String string2 = this.getRegionName() + SUBREGION_DELIM + string;
        CacheAccess cacheAccess = new CacheAccess(string2);
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public CacheAccess getSubRegion(String string, Attributes attributes) throws CacheException {
        String string2;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getSubRegion(" + string + ")");
        }
        if (!CacheAccess.isRegionExist(string2 = this.getRegionName() + SUBREGION_DELIM + string)) {
            CacheAccess.createSubRegions(this.getRegionName(), string, attributes);
        }
        CacheAccess cacheAccess = new CacheAccess(string2);
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public String getParent() throws CacheException {
        String string = null;
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getParent()");
        }
        try {
            CacheHandle cacheHandle = this.getHandle();
            string = cacheHandle.getParent(this.getDefGrpName());
        }
        catch (RegionNotFoundException regionNotFoundException) {
            throw CacheAccess.exceptionHandler("CacheAccess.getAccess", regionNotFoundException);
        }
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + string, l);
        }
        return string;
    }

    public void createPool(String string, PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2) throws InvalidArgumentException, CacheException {
        this.createPool(string, this.getDefGrpName(), poolInstanceFactory, attributes, n, n2);
    }

    public void createPool(String string, String string2, PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2) throws InvalidArgumentException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("createPool(\"" + string + "\", " + "\"" + string2 + "\", " + attributes + ", " + n + ", " + n2 + ")");
        }
        try {
            if (string == null || string2 == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            PoolAccess.createPool(this.getRegionName(), string2, string, poolInstanceFactory, attributes, n, n2);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.createPool", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void destroy() throws CacheException {
        this.destroy(false);
    }

    public void destroy(boolean bl) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("destroy() localOnly=" + bl);
        }
        try {
            if (!this.getRegionName().equals(CacheAccess.getDefRegionName())) {
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.destroy(this.getDefGrpName(), this.getRegionName(), bl);
                this.releaseHandle();
            }
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.destroy", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void destroy(Object object) throws CacheException {
        this.destroy(object, false);
    }

    public void destroy(Object object, boolean bl) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("destroy(" + object + ", localOnly=)" + bl);
        }
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            if (!object.equals(CacheAccess.getDefRegionName())) {
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.destroy(object, this.getRegionName(), bl);
                if (object.equals(this.getDefGrpName())) {
                    this.releaseHandle();
                }
            }
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.destroy", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void destroy(Object[] objectArray) throws CacheException {
        this.destroy(objectArray, false);
    }

    public void destroy(Object[] objectArray, boolean bl) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("destroy(" + objectArray + ", localOnly=)" + bl);
        }
        try {
            if (objectArray == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null || !objectArray[i].equals(CacheAccess.getDefRegionName())) continue;
                objectArray[i] = null;
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.destroy(objectArray, this.getRegionName(), bl);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.destroy", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void waitForResponse(int n) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("waitForResponse(" + n + ")");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            cacheHandle.waitForAllResponse(n);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.waitForResponse", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public void cancelResponse() throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("cancelResponse()");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            cacheHandle.cancelAllResponse();
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.cancelResponse", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public Object getOwnership(int n) throws CacheException {
        return this.getOwnership(this.getDefGrpName(), this.getDefGrpName(), n);
    }

    public Object getOwnership(Object object, int n) throws CacheException {
        return this.getOwnership(object, this.getDefGrpName(), n);
    }

    public Object getOwnership(Object object, String string, int n) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getOwnership(" + object + ", " + string + ", " + n + ")");
        }
        try {
            if (object == null || string == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            Object object2 = cacheHandle.getOwnership(object, this.getRegionName(), string, n);
            return object2;
        }
        catch (TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.getOwnership", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPresent(Object object) {
        long l = 0L;
        boolean bl = false;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("isPresent(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                bl = cacheHandle.isPresent(object, this.getRegionName());
            }
            catch (Exception exception) {
                CacheAccess.exceptionHandler("CacheAccess.isPresent", exception);
                Object var8_6 = null;
                if (!CacheInternal.logger.shouldLog(7)) return bl;
                CacheAccess.TRACE("return:" + bl, l);
                return bl;
            }
            Object var8_5 = null;
            if (!CacheInternal.logger.shouldLog(7)) return bl;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!CacheInternal.logger.shouldLog(7)) throw throwable;
            CacheAccess.TRACE("return:" + bl, l);
            throw throwable;
        }
        CacheAccess.TRACE("return:" + bl, l);
        return bl;
    }

    public void releaseOwnership(int n) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("releaseOwnership(" + n + ")");
        }
        this.releaseOwnership(this.getDefGrpName(), n);
    }

    public void releaseOwnership(Object object, int n) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("releaseOwnership(" + object + ", " + n + ")");
        }
        try {
            if (object == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            CacheHandle cacheHandle = this.getHandle();
            cacheHandle.releaseOwnership(object, this.getRegionName(), n);
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.releaseOwnership", exception);
        }
        finally {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheAccess.TRACE("return", l);
            }
        }
    }

    public Attributes getAttributes() throws CacheException {
        Attributes attributes = null;
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAttributes()");
        }
        attributes = this.getAttributes(this.getDefGrpName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + attributes, l);
        }
        return attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Attributes getAttributes(Object object) throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAttributes(" + object + ")");
        }
        Attributes attributes = null;
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                attributes = cacheHandle.getAttributes(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getAttributes", exception);
            }
            Object var7_6 = null;
            if (!CacheInternal.logger.shouldLog(7)) return attributes;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!CacheInternal.logger.shouldLog(7)) throw throwable;
            CacheAccess.TRACE("return:" + attributes, l);
            throw throwable;
        }
        CacheAccess.TRACE("return:" + attributes, l);
        return attributes;
    }

    public ObjectStatus getStatus() throws CacheException {
        long l = 0L;
        ObjectStatus objectStatus = null;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getStatus()");
        }
        objectStatus = this.getStatus(this.getDefGrpName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + objectStatus, l);
        }
        return objectStatus;
    }

    public AggregateStatus getAggregateStatus() throws CacheException {
        long l = 0L;
        AggregateStatus aggregateStatus = null;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getAggregateStatus()");
        }
        aggregateStatus = this.getAggregateStatus(this.getDefGrpName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:", l);
        } else if (CacheInternal.logger.shouldLog(15)) {
            CacheAccess.TRACE("return:" + aggregateStatus, l);
        }
        return aggregateStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectStatus getStatus(Object object) throws CacheException {
        long l = 0L;
        ObjectStatus objectStatus = null;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getStatus(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                objectStatus = cacheHandle.getStatus(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getStatus", exception);
            }
            Object var7_6 = null;
            if (!CacheInternal.logger.shouldLog(7)) return objectStatus;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!CacheInternal.logger.shouldLog(7)) throw throwable;
            CacheAccess.TRACE("return:" + objectStatus, l);
            throw throwable;
        }
        CacheAccess.TRACE("return:" + objectStatus, l);
        return objectStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AggregateStatus getAggregateStatus(Object object) throws CacheException {
        AggregateStatus aggregateStatus;
        long l;
        block8: {
            l = 0L;
            aggregateStatus = null;
            if (CacheInternal.logger.shouldLog(7)) {
                l = CacheAccess.TRACE("getAggregateStatus(" + object + ")");
            }
            try {
                try {
                    if (object == null) {
                        throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                    }
                    CacheHandle cacheHandle = this.getHandle();
                    aggregateStatus = cacheHandle.getAggregateStatus(object, this.getRegionName());
                }
                catch (Exception exception) {
                    throw CacheAccess.exceptionHandler("CacheAccess.getStatus", exception);
                }
                Object var7_6 = null;
                if (!CacheInternal.logger.shouldLog(7)) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (CacheInternal.logger.shouldLog(7)) {
                    CacheAccess.TRACE("return", l);
                    throw throwable;
                }
                if (!CacheInternal.logger.shouldLog(15)) throw throwable;
                CacheAccess.TRACE("return:" + aggregateStatus, l);
                throw throwable;
            }
            CacheAccess.TRACE("return", l);
            return aggregateStatus;
        }
        if (!CacheInternal.logger.shouldLog(15)) return aggregateStatus;
        CacheAccess.TRACE("return:" + aggregateStatus, l);
        return aggregateStatus;
    }

    public int getCount() throws CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getCount()");
        }
        CacheHandle cacheHandle = this.getHandle();
        int n = cacheHandle.getRegionCount(this.getRegionName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + n, l);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PoolAccess getPool(String string) throws NotAPoolException, ObjectNotFoundException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getPool(\"" + string + "\")");
        }
        PoolAccess poolAccess = null;
        try {
            try {
                poolAccess = PoolAccess.getPool(this.getRegionName(), string);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getPool", exception);
            }
            Object var7_4 = null;
            if (!CacheInternal.logger.shouldLog(7)) return poolAccess;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!CacheInternal.logger.shouldLog(7)) throw throwable;
            CacheAccess.TRACE("return:" + poolAccess, l);
            throw throwable;
        }
        CacheAccess.TRACE("return:" + poolAccess, l);
        return poolAccess;
    }

    public String getRegionName() {
        return this.region_;
    }

    public Object[] listNames() throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("listNames()");
        }
        CacheHandle cacheHandle = this.getHandle();
        Object[] objectArray = cacheHandle.listNames(this.getRegionName());
        if (CacheInternal.logger.shouldLog(7)) {
            if (objectArray != null) {
                CacheAccess.TRACE("return: list of " + objectArray.length + " objects", l);
            } else {
                CacheAccess.TRACE("return:null", l);
            }
        } else if (CacheInternal.logger.shouldLog(15)) {
            CacheAccess.TRACE("return:" + objectArray, l);
        }
        return objectArray;
    }

    public String[] listRegions() throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("listRegions()");
        }
        CacheHandle cacheHandle = this.getHandle();
        String[] stringArray = cacheHandle.listRegions(this.getRegionName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:", l);
        }
        return stringArray;
    }

    public Enumeration listObjects() throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("listObjects()");
        }
        CacheHandle cacheHandle = this.getHandle();
        Enumeration enumeration = cacheHandle.createList(this.getRegionName());
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return", l);
        } else if (CacheInternal.logger.shouldLog(15)) {
            CacheAccess.TRACE("return:" + enumeration, l);
        }
        return enumeration;
    }

    public Vector getAllCached(Object object, int n) throws ObjectNotFoundException, NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        return this.getAllCached(object, n, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllCached(Object object, int n, boolean bl) throws ObjectNotFoundException, NotARetrievableObjectException, RegionNotFoundException, InvalidHandleException, CacheException {
        Vector vector;
        long l;
        block10: {
            block11: {
                l = 0L;
                if (CacheInternal.logger.shouldLog(7)) {
                    l = CacheAccess.TRACE("getAllCached(" + object + ")");
                }
                vector = null;
                try {
                    try {
                        if (object == null) {
                            throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                        }
                        if (this.grphandle_ == null) {
                            throw new InvalidHandleException(CacheInternal.EXP_INVALHDL);
                        }
                        CacheHandle cacheHandle = this.getHandle();
                        vector = cacheHandle.netSearchList(object, this.getRegionName(), n, bl);
                    }
                    catch (Exception exception) {
                        throw CacheAccess.exceptionHandler("CacheAccess.getAllCached", exception);
                    }
                    Object var9_8 = null;
                    if (!CacheInternal.logger.shouldLog(7)) break block10;
                    if (vector == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (!CacheInternal.logger.shouldLog(7)) {
                        if (!CacheInternal.logger.shouldLog(15)) throw throwable;
                        CacheAccess.TRACE("return:" + vector, l);
                        throw throwable;
                    }
                    if (vector != null) {
                        CacheAccess.TRACE("return: list of " + vector.size() + " objects", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE("return:null", l);
                    throw throwable;
                }
                CacheAccess.TRACE("return: list of " + vector.size() + " objects", l);
                return vector;
            }
            CacheAccess.TRACE("return:null", l);
            return vector;
        }
        if (!CacheInternal.logger.shouldLog(15)) return vector;
        CacheAccess.TRACE("return:" + vector, l);
        return vector;
    }

    public String toString() {
        return this.region_;
    }

    CacheAccess(String string) {
        this.region_ = string;
        this.grphandle_ = CacheHandleQ.getHandle();
    }

    public static String getDefRegionName() {
        long l = 0L;
        if (CacheInternal.logger.shouldLog(7)) {
            l = CacheAccess.TRACE("getDefRegionName()");
        }
        String string = "oracle_java_cache_service";
        if (CacheInternal.logger.shouldLog(7)) {
            CacheAccess.TRACE("return:" + string, l);
        }
        return string;
    }

    private static final long TRACE(String string) {
        return CacheAccess.TRACE(string, 0L);
    }

    private static final long TRACE(String string, long l) {
        long l2 = l;
        if (l2 == 0L) {
            l2 = CacheInternal.getSeqId();
        }
        CacheInternal.logger.log("[Acc] (" + l2 + ") " + string);
        return l2;
    }
}

