/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.ias.cache.CacheInternal;

class CacheOutputStream
extends OutputStream {
    private byte[] buf;
    private int bufMax = CacheInternal.streamBufSize;
    private int buflength = 0;
    private int flushPtr = 0;
    private FileOutputStream fout;
    private File outFile;
    private boolean useFile = false;

    CacheOutputStream(File file, FileOutputStream fileOutputStream) {
        this.buf = new byte[this.bufMax];
        this.fout = fileOutputStream;
        this.outFile = file;
    }

    public void write(int n) throws IOException {
        if (!this.checkSize(1)) {
            this.fout.write(this.buf, 0, this.buflength);
            this.buflength = 0;
            this.flushPtr = 0;
        }
        this.buf[this.buflength++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.checkSize(n2)) {
            System.arraycopy(byArray, n, this.buf, this.buflength, n2);
            this.buflength += n2;
            return;
        }
        if (this.buflength > 0) {
            this.fout.write(this.buf, 0, this.buflength);
            this.buflength = 0;
            this.flushPtr = 0;
        }
        this.fout.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void flush() throws IOException {
        if (this.buflength > 0) {
            this.fout.write(this.buf, this.flushPtr, this.buflength - this.flushPtr);
            this.flushPtr = this.buflength;
        }
        this.fout.flush();
    }

    void forceToDisk() throws IOException {
        this.flush();
        this.useFile = true;
    }

    public void close() throws IOException {
        this.flush();
        this.fout.close();
    }

    boolean isFile() {
        return this.useFile;
    }

    Object getObject() {
        if (this.useFile) {
            return this.outFile.getAbsolutePath();
        }
        byte[] byArray = new byte[this.buflength];
        System.arraycopy(this.buf, 0, byArray, 0, this.buflength);
        this.buf = byArray;
        return this.buf;
    }

    long getSize() {
        if (this.useFile) {
            return this.outFile.length();
        }
        return this.buflength;
    }

    private boolean checkSize(int n) {
        if (this.buflength + n <= this.bufMax) {
            return true;
        }
        this.useFile = true;
        return false;
    }
}

