/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.AffinityObject;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.PoolAffinityFactory;
import oracle.ias.cache.PoolInstanceFactory;

class PoolMgr {
    PoolInstanceFactory factory;
    int max;
    int min;
    Attributes attr;
    private int[] indexStack;
    private int hot;
    private int top;
    private Object lock = new Object();
    private AffinityObject[] affinityList;
    private boolean affinityOn = false;
    private PoolAffinityFactory affinity = null;
    private int nextAffinity = -1;

    PoolMgr(PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2) {
        int n3;
        this.min = n;
        this.max = n2;
        this.factory = poolInstanceFactory;
        this.attr = attributes;
        this.indexStack = new int[n2];
        this.affinityList = new AffinityObject[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            this.indexStack[n3] = n3;
        }
        this.hot = 0;
        this.top = this.min;
        if (poolInstanceFactory instanceof PoolAffinityFactory) {
            this.affinityOn = true;
            this.affinity = (PoolAffinityFactory)poolInstanceFactory;
            for (n3 = 0; n3 < n2; ++n3) {
                this.affinityList[n3] = new AffinityObject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex() throws CacheException {
        int n = -1;
        Object object = this.lock;
        synchronized (object) {
            if (this.hot < this.min) {
                n = this.indexStack[this.hot++];
            } else if (this.top != this.max) {
                n = this.indexStack[this.top++];
            }
            if (this.affinityOn && n == -1) {
                for (int i = 0; i < this.max; ++i) {
                    CacheHandle cacheHandle;
                    ++this.nextAffinity;
                    this.nextAffinity %= this.max;
                    AffinityObject affinityObject = this.affinityList[this.nextAffinity];
                    if (affinityObject.isInUse() || (cacheHandle = affinityObject.handle) == null || !this.affinity.affinityRelease(cacheHandle.getObject())) continue;
                    CacheHandleQ.releaseHandle(cacheHandle);
                    affinityObject.reset();
                    return this.nextAffinity;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseIndex(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n < this.min) {
                this.indexStack[--this.hot] = n;
            } else {
                this.indexStack[--this.top] = n;
            }
            if (this.affinityOn) {
                this.affinityList[n].reset();
            }
        }
    }

    boolean hasAffinity() {
        return this.affinityOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheHandle getAffinity(int n, int n2) {
        CacheHandle cacheHandle = null;
        Object object = this.lock;
        synchronized (object) {
            AffinityObject affinityObject = this.affinityList[n];
            if (affinityObject.version == n2 && (cacheHandle = affinityObject.getHandle()) != null) {
                affinityObject.setInUse(true);
            }
            return cacheHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int releaseAffinity(int n, CacheHandle cacheHandle) {
        Object object = this.lock;
        synchronized (object) {
            this.affinityList[n].handle = cacheHandle;
            this.affinityList[n].setInUse(false);
        }
        return this.affinityList[n].version;
    }

    public String toString() {
        String string = "stack:{";
        for (int i = 0; i < this.indexStack.length; ++i) {
            string = i == this.indexStack.length - 1 ? string + this.indexStack[i] + "}" : string + this.indexStack[i] + ",";
        }
        string = string + "::hot:" + this.hot;
        string = string + "::top:" + this.top;
        return string;
    }
}

