/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.Transport;

class CoordinatorResolver
extends Thread {
    private MulticastSocket mSocket_ = null;
    private Address myAddress_ = null;
    private int myPort_ = 0;
    private boolean terminate_ = false;
    private int myAddressPosition_ = 0;
    private Address[] nlAddresses_ = null;
    private boolean conflict_ = false;
    private boolean useMulticast_ = false;
    private boolean localConflict_ = false;

    CoordinatorResolver(Address[] addressArray, Address address, MulticastSocket multicastSocket) {
        this(addressArray, address);
        this.useMulticast_ = true;
        this.mSocket_ = multicastSocket;
        this.myPort_ = address.getPort();
    }

    CoordinatorResolver(Address[] addressArray, Address address) {
        this.myAddress_ = address;
        this.nlAddresses_ = addressArray;
        this.myAddressPosition_ = this.getAddressPosition(address);
        this.setDaemon(true);
        this.setName("Coordinator Resolver");
        Transport.toEnableCollectingVotes(true);
    }

    boolean hasConflict(Address address, ElectionNotification electionNotification) {
        boolean bl = false;
        try {
            Address address2 = electionNotification.getNominee();
            boolean bl2 = electionNotification.istheWinner();
            if (bl2 && !address.equals(address2)) {
                if (address.getIPString().equals(address2.getIPString())) {
                    this.localConflict_ = true;
                }
                bl = true;
            } else {
                String string = address2.ip.getHostAddress();
                int n = address2.getPort();
                int n2 = this.getAddressPosition(address2);
                if (n2 < this.myAddressPosition_) {
                    bl = true;
                } else if (n2 == this.myAddressPosition_ && n < this.myPort_) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    boolean isLocalConflict() {
        return this.localConflict_;
    }

    private int getAddressPosition(Address address) {
        int n = -1;
        for (n = 0; n < this.nlAddresses_.length && !this.nlAddresses_[n].getIPString().equals(address.getIPString()); ++n) {
        }
        return n;
    }

    private Object byteToObject(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    void shutdown() {
        this.terminate_ = true;
        if (this.useMulticast_) {
            Transport.toEnableCollectingVotes(false);
            Transport.clearElectionVoteBuffer();
        }
    }

    boolean canBeCoordinator() {
        return !this.conflict_;
    }

    private ElectionNotification getAnElectionVote() {
        ElectionNotification electionNotification = null;
        if (this.useMulticast_) {
            DatagramPacket datagramPacket = null;
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[1024];
                datagramPacket = new DatagramPacket(byArray2, byArray2.length);
                this.mSocket_.receive(datagramPacket);
                if (datagramPacket != null && !this.terminate_ && (byArray = datagramPacket.getData()) != null) {
                    electionNotification = (ElectionNotification)this.byteToObject(byArray);
                }
            }
            catch (Exception exception) {}
        } else {
            electionNotification = Transport.getACoordinatorVote();
        }
        if (!this.terminate_ && electionNotification != null && GroupCommunication.shouldLog(15)) {
            GroupCommunication.log("Retrieved an election vote:" + electionNotification);
        }
        return electionNotification;
    }

    public void run() {
        if (GroupCommunication.shouldLog(7)) {
            GroupCommunication.log(this.getName() + " is started.");
        }
        while (!this.terminate_) {
            ElectionNotification electionNotification = this.getAnElectionVote();
            if (electionNotification != null) {
                this.conflict_ = this.hasConflict(this.myAddress_, electionNotification);
            }
            if (!this.conflict_) continue;
            if (!GroupCommunication.shouldLog(7)) break;
            GroupCommunication.log("Coordinator conflict is detected during election. Encountered a higher priority vote:" + electionNotification);
            break;
        }
        if (GroupCommunication.shouldLog(7)) {
            GroupCommunication.log(this.getName() + " is terminated.");
        }
    }
}

