/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.net.Socket;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.StreamHandler;

public class EndPoint {
    Address addr;
    Socket s;
    Receiver handler;
    byte[] lock;
    long counter;
    StreamHandler m_sh;

    EndPoint(Address address, Socket socket) throws GroupException, IOException {
        this.addr = address;
        this.s = socket;
        this.m_sh = new StreamHandler(this.s);
        this.lock = new byte[0];
        this.counter = 0L;
    }

    public StreamHandler getStreamHandler() {
        return this.m_sh;
    }

    public void write(Packet packet) throws IOException, GroupException {
        this.m_sh.write(packet);
    }

    public Packet read() throws IOException, GroupException {
        return this.m_sh.read();
    }

    public void reset() throws IOException {
        this.m_sh.reset();
    }

    public String getShortName() {
        return new String(this.addr.getIPString() + ":" + this.addr.getPort());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addr);
        stringBuffer.append(", Socket= ");
        stringBuffer.append(this.s);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        try {
            if (!bl) {
                this.handler.stopit();
            }
            this.m_sh.close();
            this.s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    void dump() {
        GroupCommunication.log("--- EndPoint Dump ---");
        GroupCommunication.log(this.toString());
    }
}

