/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import oracle.ias.cache.group.SSLManager;

public class GroupSocketOpener
implements Runnable {
    String m_host;
    int m_port;
    int m_timeout;
    boolean m_secure;
    Socket m_socket = null;
    IOException m_err = null;
    boolean m_hasTimedOut = false;

    public GroupSocketOpener(InetAddress inetAddress, int n, int n2) {
        this(inetAddress.getHostName(), n, n2);
    }

    public GroupSocketOpener(String string, int n, int n2) {
        this(string, n, n2, false);
    }

    public GroupSocketOpener(InetAddress inetAddress, int n, int n2, boolean bl) {
        this(inetAddress.getHostName(), n, n2, bl);
    }

    public GroupSocketOpener(String string, int n, int n2, boolean bl) {
        this.m_host = string;
        this.m_port = n;
        this.m_timeout = n2;
        this.m_secure = bl;
    }

    public Socket createSocket() throws IOException {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("Group Socket Opener: " + this.m_host + ":" + this.m_port);
        thread.start();
        try {
            thread.join(this.m_timeout);
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
        if (this.m_err != null) {
            throw this.m_err;
        }
        if (this.m_socket == null) {
            this.m_hasTimedOut = true;
            throw new IOException("Socket connection timed out: " + this.m_host + ":" + this.m_port);
        }
        return this.m_socket;
    }

    public void run() {
        try {
            if (this.m_secure) {
                SSLManager sSLManager = SSLManager.getInstance();
                this.m_socket = sSLManager.createSSLSocket(this.m_host, this.m_port);
            } else {
                this.m_socket = new Socket(this.m_host, this.m_port);
            }
        }
        catch (IOException iOException) {
            this.m_err = iOException;
        }
        if (this.m_hasTimedOut) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_socket = null;
            this.m_err = null;
        }
    }
}

